%%% Functors:
    fun  penc/2.
    fun  h/1.
    fun  a/0.   % the honest user(s)
    fun  b/0.   % the intruder
    fun  q/0.   % the intruder
    fun  k/1.   % k(A) -- the private key of A
    fun  pub/1. % the corresponding public key 
    fun  n/2.   % nonces
    fun  m/2. 

%%% Auxiliary predicates:
    part(a).            %    
    part(b).            % participants names
    honest(a).          % honest participants names
    dishonest(b).       % dishonest participants names

%%% RULES:

%%% Intruder rules
    rule  X, pub(K) -> penc(X,pub(K)).
    rule  penc(X,pub(K)), K -> X.
    rule  X -> h(X).

%%% Initial knowledge
    rule   A            :- part(A).
    rule   pub(k(A))    :- part(A).
    rule   k(A)         :- dishonest(A).

%%% Protocol Rules

%%% (1)  A -> B:   {N, A}_pub(skB)

    rule  penc((n(A,B), A), pub(k(B)))
    :- 
       honest(A), part(B).

%%% (2)  B -> A:   {M+N,B}_pub(skA)

    rule  penc((X,A), pub(k(B))) -> penc((m(B,A)+X,B), pub(k(A))) 
    :-
       honest(B), part(A).

%%% (3)  A -> B   {M}_pub(skB)

    rule  penc((Y+n(A,B),B), pub(k(A))) ->  penc(Y, pub(k(A)))
    :-
       honest(A), part(B). 

%%% The secret:
    query m(a,a).
