/*
 * Decompiled with CFR 0.152.
 */
package jsc.combinatorics;

import jsc.combinatorics.Selection;

public class MultiSetPermutation
implements Selection {
    private int[] p;
    private int[] subsetSizes;

    MultiSetPermutation(int[] nArray, int[] nArray2, boolean bl) {
        this.p = nArray;
        this.subsetSizes = nArray2;
    }

    public MultiSetPermutation(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        int[] nArray3 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray3[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            if (n4 < 1 || n4 > n2) {
                throw new IllegalArgumentException("Multi-set permutation array contains incorrect values.");
            }
            int n5 = n4 - 1;
            nArray3[n5] = nArray3[n5] + 1;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (nArray3[n3] != nArray2[n3]) {
                throw new IllegalArgumentException("Multi-set permutation array contains incorrect values.");
            }
            ++n3;
        }
        this.p = nArray;
        this.subsetSizes = nArray2;
    }

    public int getSubsetCount() {
        return this.subsetSizes.length;
    }

    public int[] getSubsetSizes() {
        return this.subsetSizes;
    }

    public int length() {
        return this.p.length;
    }

    public int[] toIntArray() {
        return this.p;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MultiSetPermutation:");
        int n = 0;
        while (n < this.p.length) {
            stringBuffer.append(" " + this.p[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int[] nArray = new int[]{2, 1, 3};
            int[] nArray2 = new int[]{2, 3, 1, 3, 1, 3};
            MultiSetPermutation multiSetPermutation = new MultiSetPermutation(nArray2, nArray);
            System.out.println(multiSetPermutation.toString());
        }
    }
}

