/*
 * Decompiled with CFR 0.152.
 */
package jsc.combinatorics;

import java.util.NoSuchElementException;
import java.util.Random;
import jsc.combinatorics.Enumerator;
import jsc.combinatorics.MultiSetPermutation;
import jsc.combinatorics.Selection;
import jsc.util.Arrays;
import jsc.util.Maths;

public class MultiSetPermutations
implements Enumerator {
    private boolean hasNext;
    private Random rand;
    private long count;
    private int k;
    private int k1;
    private int N;
    private int[] randPerm;
    private int[] ns;
    private int[] r;
    private int[][] A;
    private final double permutationCount;

    public MultiSetPermutations(int n) {
        this(Arrays.fill(n, 1));
    }

    public MultiSetPermutations(int[] nArray) {
        this.k = nArray.length;
        this.permutationCount = Maths.multinomialCoefficient(nArray);
        this.ns = nArray;
        this.r = new int[this.k + 1];
        System.arraycopy(nArray, 0, this.r, 1, this.k);
        this.N = 0;
        int n = 1;
        while (n <= this.k) {
            if (this.r[n] == 0) {
                throw new IllegalArgumentException("Empty subset.");
            }
            this.N += this.r[n];
            ++n;
        }
        if (this.N < 2) {
            throw new IllegalArgumentException("Less than 2 objects.");
        }
        this.A = new int[this.k + 1][this.N + 1];
        this.rand = new Random();
        this.randPerm = new int[this.N];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.k) {
            n = 0;
            while (n < nArray[n3]) {
                this.randPerm[n2] = n3 + 1;
                ++n2;
                ++n;
            }
            ++n3;
        }
        this.reset();
    }

    public double countSelections() {
        return this.permutationCount;
    }

    public int getN() {
        return this.N;
    }

    private MultiSetPermutation getPermutation() {
        int[] nArray = new int[this.N];
        int n = 1;
        while (n <= this.N) {
            nArray[n - 1] = this.A[this.k][n];
            ++n;
        }
        if ((double)this.count > this.permutationCount) {
            this.hasNext = false;
        }
        return new MultiSetPermutation(nArray, this.ns, false);
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    private void moveMarks(int n, int n2) {
        boolean bl;
        do {
            bl = false;
            int n3 = 1;
            while (n3 <= n2) {
                int n4 = n3 + 1;
                if (this.A[n][n3] == n + 1 && this.A[n][n4] == n) {
                    this.A[n][n3] = this.A[n][n4];
                    this.A[n][n4] = this.A[n][n3] + 1;
                    bl = true;
                }
                ++n3;
            }
        } while (bl);
    }

    public Selection nextSelection() {
        return this.nextPermutation();
    }

    public MultiSetPermutation nextPermutation() {
        int n = this.k - 1;
        int n2 = this.r[this.k] + this.r[n];
        if (this.count == 1L) {
            this.step5();
            ++this.count;
            return this.getPermutation();
        }
        while (true) {
            int n3 = 1;
            while (n3 <= n2 - 1) {
                int n4 = n3 + 1;
                if (this.A[n][n3] == n && this.A[n][n4] == n + 1) {
                    int n5 = n3 - 2;
                    this.A[n][n3] = this.A[n][n4];
                    this.A[n][n4] = this.A[n][n3] - 1;
                    if (n5 <= 0) {
                        this.step5();
                        ++this.count;
                        return this.getPermutation();
                    }
                    this.moveMarks(n, n5);
                    this.step5();
                    ++this.count;
                    return this.getPermutation();
                }
                ++n3;
            }
            if (n2 != 1) {
                int n6 = n2 / 2;
                n3 = 1;
                while (n3 <= n6) {
                    int n7 = n2 - n3 + 1;
                    int n8 = this.A[n][n3];
                    this.A[n][n3] = this.A[n][n7];
                    this.A[n][n7] = n8;
                    ++n3;
                }
            }
            if (--n <= 0) {
                throw new NoSuchElementException();
            }
            n2 += this.r[n];
        }
    }

    public Selection randomSelection() {
        return this.randomPermutation();
    }

    public MultiSetPermutation randomPermutation() {
        int n = 0;
        while (n < this.N) {
            int n2 = n + this.rand.nextInt(this.N - n);
            int n3 = this.randPerm[n2];
            this.randPerm[n2] = this.randPerm[n];
            this.randPerm[n] = n3;
            ++n;
        }
        return new MultiSetPermutation(this.randPerm, this.ns, false);
    }

    public void reset() {
        this.count = 1L;
        int n = this.N;
        this.k1 = this.k - 1;
        int n2 = 1;
        while (n2 <= this.k1) {
            int n3;
            int n4 = this.r[n2];
            int n5 = 1;
            while (n5 <= n4) {
                this.A[n2][n5] = n2;
                ++n5;
            }
            n5 = n3 = this.r[n2] + 1;
            while (n5 <= n) {
                this.A[n2][n5] = n2 + 1;
                ++n5;
            }
            n -= this.r[n2];
            ++n2;
        }
        this.hasNext = true;
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
    }

    private void step5() {
        int n = 1;
        while (n <= this.N) {
            this.A[this.k][n] = this.A[1][n];
            ++n;
        }
        if (this.k != 2) {
            int n2 = 2;
            while (n2 <= this.k1) {
                int n3 = 1;
                n = 1;
                while (n <= this.N) {
                    if (this.A[this.k][n] == n2) {
                        this.A[this.k][n] = this.A[n2][n3];
                        ++n3;
                    }
                    ++n;
                }
                ++n2;
            }
        }
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            MultiSetPermutation multiSetPermutation;
            int[] nArray = new int[]{2, 2, 1};
            MultiSetPermutations multiSetPermutations = new MultiSetPermutations(3);
            System.out.println("Number of permutations = " + multiSetPermutations.countSelections());
            System.out.println("All permutations");
            while (multiSetPermutations.hasNext()) {
                multiSetPermutation = multiSetPermutations.nextPermutation();
                System.out.println(multiSetPermutation.toString());
            }
            multiSetPermutations.reset();
            System.out.println("All permutations");
            while (multiSetPermutations.hasNext()) {
                multiSetPermutation = multiSetPermutations.nextPermutation();
                System.out.println(multiSetPermutation.toString());
            }
        }
    }
}

