/*
 * Decompiled with CFR 0.152.
 */
package jsc.correlation;

import jsc.ci.ConfidenceInterval;
import jsc.datastructures.PairedData;
import jsc.distributions.Normal;
import jsc.distributions.StudentsT;
import jsc.onesample.Ztest;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class LinearCorrelation
implements SignificanceTest,
ConfidenceInterval {
    private final int n;
    private final double r;
    private double confidenceCoeff;
    private double lowerLimit;
    private double upperLimit;
    private double SP;

    public LinearCorrelation(PairedData pairedData, double d, H1 h1, double d2) {
        this.n = pairedData.getN();
        this.r = LinearCorrelation.correlationCoeff(pairedData);
        if (d == 0.0) {
            double d3;
            double d4 = 0.0;
            if (this.r == 1.0) {
                d3 = Double.POSITIVE_INFINITY;
            } else if (this.r == -1.0) {
                d3 = Double.NEGATIVE_INFINITY;
            } else {
                d3 = this.r * Math.sqrt(((double)this.n - 2.0) / (1.0 - this.r * this.r));
                d4 = StudentsT.tailProb(d3, this.n - 2);
            }
            this.SP = h1 == H1.NOT_EQUAL ? d4 + d4 : (h1 == H1.LESS_THAN ? (d3 < 0.0 ? d4 : 1.0 - d4) : (d3 > 0.0 ? d4 : 1.0 - d4));
        } else {
            if (d <= -1.0 || d >= 1.0) {
                throw new IllegalArgumentException("Invalid null hypothesis.");
            }
            if (Math.abs(this.r) < 1.0) {
                if (this.n < 4) {
                    throw new IllegalArgumentException("Need more than 3 observations to use Fisher's z transformation.");
                }
                double d5 = 0.5 * Math.sqrt((double)this.n - 3.0) * Math.log((1.0 + this.r) / (1.0 - this.r) * ((1.0 + d) / (1.0 - d)));
                this.SP = Ztest.getSP(d5, h1);
            } else {
                double d6 = this.r == 1.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                this.SP = h1 == H1.NOT_EQUAL ? 0.0 : (h1 == H1.LESS_THAN ? (d6 < 0.0 ? 0.0 : 1.0) : (d6 > 0.0 ? 0.0 : 1.0));
            }
        }
        this.setConfidenceCoeff(d2);
    }

    public LinearCorrelation(PairedData pairedData, double d, H1 h1) {
        this(pairedData, d, h1, 0.95);
    }

    public LinearCorrelation(PairedData pairedData, double d) {
        this(pairedData, d, H1.NOT_EQUAL, 0.95);
    }

    public LinearCorrelation(PairedData pairedData) {
        this(pairedData, 0.0, H1.NOT_EQUAL, 0.95);
    }

    public static double correlationCoeff(PairedData pairedData) {
        int n = pairedData.getN();
        double[] dArray = pairedData.getX();
        double[] dArray2 = pairedData.getY();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d5 += dArray[n2];
            d4 += dArray2[n2];
            ++n2;
        }
        d5 /= (double)n;
        d4 /= (double)n;
        n2 = 0;
        while (n2 < n) {
            double d6 = dArray[n2] - d5;
            double d7 = dArray2[n2] - d4;
            d3 += d6 * d6;
            d += d7 * d7;
            d2 += d6 * d7;
            ++n2;
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("X data are constant.");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Y data are constant.");
        }
        return d2 / Math.sqrt(d3 * d);
    }

    public int getN() {
        return this.n;
    }

    public double getR() {
        return this.r;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.r;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public double getConfidenceCoeff() {
        return this.confidenceCoeff;
    }

    public void setConfidenceCoeff(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient.");
        }
        this.confidenceCoeff = d;
        double d2 = 0.5 * Math.log((1.0 + this.r) / (1.0 - this.r));
        Normal normal = new Normal();
        double d3 = 1.0 - d;
        double d4 = normal.inverseCdf(1.0 - 0.5 * d3);
        if (this.n < 4) {
            throw new IllegalArgumentException("Need more than 3 observations to calculate confidence interval.");
        }
        double d5 = d4 / Math.sqrt((double)this.n - 3.0);
        double d6 = Math.exp(2.0 * (d2 - d5));
        double d7 = Math.exp(2.0 * (d2 + d5));
        this.lowerLimit = (d6 - 1.0) / (d6 + 1.0);
        this.upperLimit = (d7 - 1.0) / (d7 + 1.0);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{8.000001, 8.000003, 8.000002, 8.000004, 8.000005};
            double[] dArray2 = new double[]{8.0, 9.0, 10.0, 11.0, 12.0};
            double[] dArray3 = new double[]{0.8, 1.7, 2.4, 0.9, 1.2, 1.6, 1.7, 2.9};
            double[] dArray4 = new double[]{1.3, 3.3, 3.8, 1.1, 2.4, 3.1, 3.5, 3.9};
            LinearCorrelation linearCorrelation = new LinearCorrelation(new PairedData(dArray3, dArray4), 0.0, H1.GREATER_THAN, 0.95);
            System.out.println("n = " + linearCorrelation.getN() + " r = " + linearCorrelation.getR() + " SP = " + linearCorrelation.getSP());
            System.out.println("CI = [" + linearCorrelation.getLowerLimit() + ", " + linearCorrelation.getUpperLimit() + "]");
            linearCorrelation = new LinearCorrelation(new PairedData(dArray3, dArray4), 0.0, H1.NOT_EQUAL, 0.95);
            System.out.println("n = " + linearCorrelation.getN() + " r = " + linearCorrelation.getR() + " SP = " + linearCorrelation.getSP());
            System.out.println("CI = [" + linearCorrelation.getLowerLimit() + ", " + linearCorrelation.getUpperLimit() + "]");
            double[] dArray5 = new double[]{8.2, 9.6, 7.0, 9.4, 10.9, 7.1, 9.0, 6.6, 8.4, 10.5};
            double[] dArray6 = new double[]{8.7, 9.6, 6.9, 8.5, 11.3, 7.6, 9.2, 6.3, 8.4, 12.3};
            linearCorrelation = new LinearCorrelation(new PairedData(dArray5, dArray6), 0.0, H1.NOT_EQUAL, 0.95);
            System.out.println("n = " + linearCorrelation.getN() + " r = " + linearCorrelation.getR() + " SP = " + linearCorrelation.getSP());
            System.out.println("CI = [" + linearCorrelation.getLowerLimit() + ", " + linearCorrelation.getUpperLimit() + "]");
            double[] dArray7 = new double[]{0.0, 4.0, 6.0, 8.0, 12.0, 14.0, 16.0, 22.0, 26.0};
            double[] dArray8 = new double[]{11.0, 13.0, 8.0, 4.0, 7.0, 6.0, 3.0, 2.0, 0.0};
            linearCorrelation = new LinearCorrelation(new PairedData(dArray7, dArray8), 0.0, H1.NOT_EQUAL, 0.99);
            System.out.println("n = " + linearCorrelation.getN() + " r = " + linearCorrelation.getR() + " SP = " + linearCorrelation.getSP());
            System.out.println("CI = [" + linearCorrelation.getLowerLimit() + ", " + linearCorrelation.getUpperLimit() + "]");
        }
    }
}

