/*
 * Decompiled with CFR 0.152.
 */
package jsc.curvefitting;

import jsc.ci.AbstractConfidenceInterval;
import jsc.ci.ConfidenceInterval;
import jsc.curvefitting.StraightLineFit;
import jsc.datastructures.PairedData;
import jsc.distributions.StudentsT;

public class LineFit
implements StraightLineFit {
    private final int n;
    private double a;
    private double b;
    private double chi2;
    private double ax;
    private double ay;
    private double sxx;

    public LineFit(PairedData pairedData) {
        this(pairedData, null);
    }

    public LineFit(PairedData pairedData, double[] dArray) {
        this.n = pairedData.getN();
        double[] dArray2 = pairedData.getX();
        double[] dArray3 = pairedData.getY();
        if (dArray == null) {
            this.unweightedLineFit(dArray2, dArray3);
        } else {
            if (this.n != dArray.length) {
                throw new IllegalArgumentException("Weights array is wrong length.");
            }
            this.weightedLineFit(dArray2, dArray3, dArray);
        }
    }

    private void unweightedLineFit(double[] dArray, double[] dArray2) {
        double d;
        int n;
        double d2;
        this.a = 0.0;
        this.b = 0.0;
        if (this.n == 2) {
            d2 = dArray[1] - dArray[0];
            if (d2 == 0.0) {
                throw new IllegalArgumentException("X data are constant.");
            }
            this.b = (dArray2[1] - dArray2[0]) / d2;
            this.a = dArray2[0] - this.b * dArray[0];
        } else {
            d2 = 0.0;
            this.ay = 0.0;
            this.ax = 0.0;
            this.sxx = 0.0;
            n = 0;
            while (n < this.n) {
                this.ax += dArray[n];
                this.ay += dArray2[n];
                ++n;
            }
            this.ax /= (double)this.n;
            this.ay /= (double)this.n;
            n = 0;
            while (n < this.n) {
                double d3 = dArray[n] - this.ax;
                d = dArray2[n] - this.ay;
                this.sxx += d3 * d3;
                d2 += d3 * d;
                ++n;
            }
            if (this.sxx <= 0.0) {
                throw new IllegalArgumentException("X data are constant.");
            }
            this.b = d2 / this.sxx;
            this.a = this.ay - this.b * this.ax;
        }
        this.chi2 = 0.0;
        n = 0;
        while (n < this.n) {
            d = dArray2[n] - this.a - this.b * dArray[n];
            this.chi2 += d * d;
            ++n;
        }
    }

    private void weightedLineFit(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        this.b = 0.0;
        double d5 = 0.0;
        int n = 0;
        while (n < this.n) {
            double d6 = dArray3[n] * dArray3[n];
            d5 += d6;
            d2 += dArray[n] * d6;
            d3 += dArray2[n] * d6;
            ++n;
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("Zero weights.");
        }
        double d7 = d2 / d5;
        n = 0;
        while (n < this.n) {
            d = (dArray[n] - d7) * dArray3[n];
            d4 += d * d;
            this.b += d * dArray2[n] * dArray3[n];
            ++n;
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("Weighted X data are constant.");
        }
        this.b /= d4;
        this.a = (d3 - d2 * this.b) / d5;
        this.chi2 = 0.0;
        n = 0;
        while (n < this.n) {
            d = (dArray2[n] - this.a - this.b * dArray[n]) * dArray3[n];
            this.chi2 += d * d;
            ++n;
        }
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public ConfidenceInterval getCIA(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient");
        }
        if (this.n < 3) {
            throw new IllegalArgumentException("Insufficient data for CI.");
        }
        double d2 = this.getQuantileOfT(d);
        double d3 = this.chi2 / (double)(this.n - 2);
        double d4 = Math.sqrt(d3 * (1.0 / (double)this.n + this.ax * this.ax / this.sxx));
        double d5 = d2 * d4;
        return new AbstractConfidenceInterval(d, this.a - d5, this.a + d5);
    }

    public ConfidenceInterval getCIB(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient");
        }
        if (this.n < 3) {
            throw new IllegalArgumentException("Insufficient data for CI.");
        }
        double d2 = this.getQuantileOfT(d);
        double d3 = this.chi2 / (double)(this.n - 2);
        double d4 = Math.sqrt(d3 / this.sxx);
        double d5 = d2 * d4;
        return new AbstractConfidenceInterval(d, this.b - d5, this.b + d5);
    }

    public double[][] getIntervals(double d, int n, double d2, double d3) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient");
        }
        if (this.n < 3) {
            throw new IllegalArgumentException("Insufficient data for CI.");
        }
        if (d3 <= d2) {
            throw new IllegalArgumentException("Invalid x values.");
        }
        double d4 = 1.0 / (double)this.n;
        double d5 = this.getQuantileOfT(d);
        double d6 = Math.sqrt(this.chi2 / (double)(this.n - 2));
        double[][] dArray = new double[n][5];
        double d7 = (d3 - d2) / ((double)n - 1.0);
        double d8 = d5 * d6;
        int n2 = 0;
        while (n2 < n) {
            double d9 = d2 + (double)n2 * d7;
            double d10 = d9 - this.ax;
            double d11 = this.a + this.b * d9;
            double d12 = d10 * d10 / this.sxx + d4;
            double d13 = d8 * Math.sqrt(d12);
            double d14 = d8 * Math.sqrt(d12 + 1.0);
            dArray[n2][0] = d9;
            dArray[n2][1] = d11 - d13;
            dArray[n2][2] = d11 + d13;
            dArray[n2][3] = d11 - d14;
            dArray[n2][4] = d11 + d14;
            ++n2;
        }
        return dArray;
    }

    public double getMeanX() {
        return this.ax;
    }

    public double getMeanY() {
        return this.ay;
    }

    public int getN() {
        return this.n;
    }

    double getQuantileOfT(double d) {
        StudentsT studentsT = new StudentsT(this.n - 2);
        double d2 = 1.0 - d;
        return studentsT.inverseCdf(1.0 - 0.5 * d2);
    }

    public double getSumOfSquares() {
        return this.chi2;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{8.000001, 8.000003, 8.000002, 8.000004, 8.000005};
            double[] dArray2 = new double[]{8.0, 9.0, 10.0, 11.0, 12.0};
            double[] dArray3 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
            LineFit lineFit = new LineFit(new PairedData(dArray, dArray2));
            System.out.println("n = " + lineFit.getN());
            System.out.println("a = " + lineFit.getA());
            System.out.println("b = " + lineFit.getB());
            System.out.println("ss = " + lineFit.getSumOfSquares());
            LineFit lineFit2 = new LineFit(new PairedData(dArray, dArray2), dArray3);
            System.out.println("n = " + lineFit2.getN());
            System.out.println("a = " + lineFit2.getA());
            System.out.println("b = " + lineFit2.getB());
            System.out.println("ss = " + lineFit2.getSumOfSquares());
            double[] dArray4 = new double[]{0.1, 0.2};
            double[] dArray5 = new double[]{1.0, 2.0};
            LineFit lineFit3 = new LineFit(new PairedData(dArray4, dArray5));
            System.out.println("n = " + lineFit3.getN());
            System.out.println("a = " + lineFit3.getA());
            System.out.println("b = " + lineFit3.getB());
            System.out.println("ss = " + lineFit3.getSumOfSquares());
        }
    }
}

