/*
 * Decompiled with CFR 0.152.
 */
package jsc.datastructures;

import java.util.Vector;
import jsc.util.Arrays;
import jsc.util.Rank;
import jsc.util.Sort;

public class MatchedData
implements Cloneable {
    private int n;
    private int blockCount;
    private int treatmentCount;
    private Vector blockLabels;
    private Vector treatmentLabels;
    private double[][] data;

    public MatchedData(double[] dArray, String[] stringArray, String[] stringArray2) {
        this.n = dArray.length;
        if (this.n < 1) {
            throw new IllegalArgumentException("No data.");
        }
        if (this.n != stringArray.length || this.n != stringArray2.length) {
            throw new IllegalArgumentException("Arrays not equal length.");
        }
        this.blockLabels = Sort.getLabels(stringArray);
        this.treatmentLabels = Sort.getLabels(stringArray2);
        this.blockCount = this.blockLabels.size();
        this.treatmentCount = this.treatmentLabels.size();
        this.data = new double[this.blockCount][this.treatmentCount];
        int n = 0;
        while (n < this.n) {
            this.data[this.blockLabels.indexOf((Object)stringArray[n])][this.treatmentLabels.indexOf((Object)stringArray2[n])] = dArray[n];
            ++n;
        }
    }

    public MatchedData(double[] dArray, int[] nArray, int[] nArray2) {
        this(dArray, Arrays.toStringArray(nArray), Arrays.toStringArray(nArray2));
    }

    public MatchedData(double[][] dArray, String[] stringArray, String[] stringArray2) {
        this.blockCount = stringArray.length;
        this.treatmentCount = stringArray2.length;
        if (this.blockCount < 1) {
            throw new IllegalArgumentException("No blocks labels.");
        }
        if (this.treatmentCount < 1) {
            throw new IllegalArgumentException("No treatment labels.");
        }
        if (this.blockCount != dArray.length) {
            throw new IllegalArgumentException("Number of block labels and data values do not match.");
        }
        int n = 0;
        while (n < this.blockCount) {
            if (dArray[n].length != this.treatmentCount) {
                throw new IllegalArgumentException("Number of treatment labels and data values do not match.");
            }
            ++n;
        }
        this.blockLabels = new Vector(this.blockCount);
        this.treatmentLabels = new Vector(this.treatmentCount);
        n = 0;
        while (n < this.blockCount) {
            this.blockLabels.add(stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < this.treatmentCount) {
            this.treatmentLabels.add(stringArray2[n]);
            ++n;
        }
        this.data = dArray;
        this.n = this.blockCount * this.treatmentCount;
    }

    public MatchedData(double[][] dArray, int[] nArray, int[] nArray2) {
        this(dArray, Arrays.toStringArray(nArray), Arrays.toStringArray(nArray2));
    }

    public MatchedData(double[][] dArray) {
        this(dArray, Arrays.sequence(0, dArray.length - 1), Arrays.sequence(0, dArray[0].length - 1));
    }

    public Object clone() {
        return this.copy();
    }

    public MatchedData copy() {
        String[] stringArray = new String[this.blockCount];
        String[] stringArray2 = new String[this.treatmentCount];
        double[][] dArray = new double[this.blockCount][this.treatmentCount];
        int n = 0;
        while (n < this.blockCount) {
            stringArray[n] = (String)this.blockLabels.get(n);
            ++n;
        }
        n = 0;
        while (n < this.treatmentCount) {
            stringArray2[n] = (String)this.treatmentLabels.get(n);
            ++n;
        }
        n = 0;
        while (n < this.blockCount) {
            int n2 = 0;
            while (n2 < this.treatmentCount) {
                dArray[n][n2] = this.data[n][n2];
                ++n2;
            }
            ++n;
        }
        return new MatchedData(dArray, stringArray, stringArray2);
    }

    public double[][] getData() {
        return this.data;
    }

    public double getDatum(int n, int n2) {
        return this.data[n][n2];
    }

    public int getN() {
        return this.n;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public double[] getBlockData(String string) {
        int n = this.blockLabels.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.data[n];
    }

    public double[] getBlockData(int n) {
        return this.data[n];
    }

    public String getBlockLabel(int n) {
        return (String)this.blockLabels.get(n);
    }

    public Vector getBlockLabels() {
        return this.blockLabels;
    }

    public double getBlockMean(int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.treatmentCount) {
            d += this.data[n][n2];
            ++n2;
        }
        return d / (double)this.treatmentCount;
    }

    public double[] getBlockPackedCopy() {
        double[] dArray = new double[this.blockCount * this.treatmentCount];
        int n = 0;
        while (n < this.blockCount) {
            int n2 = 0;
            while (n2 < this.treatmentCount) {
                dArray[n * this.treatmentCount + n2] = this.data[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public boolean hasBlockLabel(String string) {
        return this.blockLabels.contains(string);
    }

    public int indexOfBlock(String string) {
        return this.blockLabels.indexOf(string);
    }

    public int getTreatmentCount() {
        return this.treatmentCount;
    }

    public double[] getTreatmentData(String string) {
        int n = this.treatmentLabels.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.getTreatmentData(n);
    }

    public double[] getTreatmentData(int n) {
        double[] dArray = new double[this.blockCount];
        int n2 = 0;
        while (n2 < this.blockCount) {
            dArray[n2] = this.data[n2][n];
            ++n2;
        }
        return dArray;
    }

    public String getTreatmentLabel(int n) {
        return (String)this.treatmentLabels.get(n);
    }

    public Vector getTreatmentLabels() {
        return this.treatmentLabels;
    }

    public double getTreatmentMean(int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.blockCount) {
            d += this.data[n2][n];
            ++n2;
        }
        return d / (double)this.blockCount;
    }

    public double[] getTreatmentPackedCopy() {
        double[] dArray = new double[this.blockCount * this.treatmentCount];
        int n = 0;
        while (n < this.blockCount) {
            int n2 = 0;
            while (n2 < this.treatmentCount) {
                dArray[n + n2 * this.blockCount] = this.data[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public boolean hasTreatmentLabel(String string) {
        return this.treatmentLabels.contains(string);
    }

    public int indexOfTreatment(String string) {
        return this.treatmentLabels.indexOf(string);
    }

    public int rankByBlocks(double d) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.blockCount) {
            Rank rank = new Rank(this.getBlockData(n2), d);
            n += rank.getCorrectionFactor1();
            int n3 = 0;
            while (n3 < this.treatmentCount) {
                this.data[n2][n3] = rank.getRank(n3);
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public double sweepByBlocks() {
        double d = 0.0;
        int n = 0;
        while (n < this.blockCount) {
            double d2 = this.getBlockMean(n);
            int n2 = 0;
            while (n2 < this.treatmentCount) {
                double[] dArray = this.data[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] - d2;
                d += this.data[n][n2] * this.data[n][n2];
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double sweepByTreatments() {
        double d = 0.0;
        int n = 0;
        while (n < this.treatmentCount) {
            double d2 = this.getTreatmentMean(n);
            int n2 = 0;
            while (n2 < this.blockCount) {
                double[] dArray = this.data[n2];
                int n3 = n;
                dArray[n3] = dArray[n3] - d2;
                d += this.data[n2][n] * this.data[n2][n];
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nMatched data\n");
        int n = 0;
        while (n < this.treatmentCount) {
            stringBuffer.append("\t" + this.getTreatmentLabel(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.blockCount) {
            stringBuffer.append("\n" + this.getBlockLabel(n2));
            n = 0;
            while (n < this.treatmentCount) {
                stringBuffer.append("\t" + this.data[n2][n]);
                ++n;
            }
            ++n2;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[][] dArrayArray = new double[][]{{3.93, 3.99, 4.08}, {3.78, 3.96, 3.94}, {3.88, 3.96, 4.02}, {3.93, 4.03, 4.06}, {3.84, 4.1, 3.94}, {3.75, 4.02, 4.09}, {3.98, 4.06, 4.17}, {3.84, 3.92, 4.12}};
            MatchedData matchedData = new MatchedData(dArrayArray);
            double d = matchedData.sweepByBlocks();
            System.out.print(matchedData.toString());
            System.out.print("rss = " + d);
            d = matchedData.sweepByTreatments();
            System.out.print(matchedData.toString());
            System.out.print("rss = " + d);
        }
    }
}

