/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

public abstract class AbstractFrequencyTable {
    int n = 0;
    int numberOfBins = 0;
    int[] freq;
    private String name;

    public AbstractFrequencyTable(String string) {
        this.name = string;
    }

    public void clearData() {
        this.n = 0;
        int n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = 0;
            ++n;
        }
    }

    public int getCumulativeFrequency(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 <= n) {
            n2 += this.freq[n3];
            ++n3;
        }
        return n2;
    }

    public double getCumulativePercentage(int n) {
        return 100.0 * this.getCumulativeProportion(n);
    }

    public double getCumulativeProportion(int n) {
        return this.n > 0 ? (double)this.getCumulativeFrequency(n) / (double)this.n : 0.0;
    }

    public int[] getFrequencies() {
        return this.freq;
    }

    public int getFrequency(int n) {
        return this.freq[n];
    }

    public int getMaximumFreq() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numberOfBins) {
            if (this.freq[n2] > n) {
                n = this.freq[n2];
            }
            ++n2;
        }
        return n;
    }

    public double getMaximumProportion() {
        return this.n > 0 ? (double)this.getMaximumFreq() / (double)this.n : 0.0;
    }

    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    public int getN() {
        return this.n;
    }

    public String getName() {
        return this.name;
    }

    public double getPercentage(int n) {
        return 100.0 * this.getProportion(n);
    }

    public double getProportion(int n) {
        return this.n > 0 ? (double)this.freq[n] / (double)this.n : 0.0;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AbstractFrequencyTable: " + this.name + " from " + this.n + " observations, " + this.numberOfBins + " bins with frequencies:");
        int n = 0;
        while (n < this.numberOfBins) {
            stringBuffer.append(" ");
            stringBuffer.append(this.freq[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

