/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDistribution;
import jsc.distributions.Distribution;
import jsc.goodnessfit.ChiSquaredFitTest;

public class Geometric
extends AbstractDistribution {
    private double p;
    private double LOGQ;
    private double LOGP;

    public Geometric(double d) {
        this.setP(d);
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return 1.0 - Math.pow(1.0 - this.p, d + 1.0);
    }

    public double getP() {
        return this.p;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        return Math.round(Math.log(1.0 - d) / this.LOGQ - 1.0);
    }

    public boolean isDiscrete() {
        return true;
    }

    public double mean() {
        return this.p / (1.0 - this.p);
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return this.p * Math.pow(1.0 - this.p, d);
    }

    public double random() {
        return Math.max(0.0, Math.ceil(Math.log(1.0 - this.rand.nextDouble()) / this.LOGQ - 1.0));
    }

    public void setP(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.p = d;
        this.LOGQ = Math.log(1.0 - d);
        this.LOGP = Math.log(d);
    }

    public String toString() {
        return new String("Geometric distribution: p = " + this.p + ".");
    }

    public double variance() {
        return this.p / ((1.0 - this.p) * (1.0 - this.p));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 0.25;
            Geometric geometric = new Geometric(d);
            int n = 10000;
            geometric = new Geometric(0.25);
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)geometric.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)geometric, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

