/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDistribution;
import jsc.distributions.Distribution;
import jsc.goodnessfit.ChiSquaredFitTest;

public class LogarithmicSeries
extends AbstractDistribution {
    private double alpha;
    private double C1;
    private double P1;

    public LogarithmicSeries(double d) {
        this.setAlpha(d);
    }

    public double cdf(double d) {
        double d2;
        if (d < 1.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d * (1.0 - this.alpha) > 10.0) {
            return 1.0;
        }
        double d3 = d2 = this.P1;
        int n = 2;
        while ((double)n <= d) {
            d3 += (d2 *= (1.0 - 1.0 / (double)n) * this.alpha);
            if (d2 <= 0.0) break;
            if (d3 >= 1.0) {
                return 1.0;
            }
            ++n;
        }
        return d3;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double inverseCdf(double d) {
        double d2;
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d3 = 1.0;
        double d4 = d2 = this.P1;
        while (d4 < d && d2 > 0.0) {
            d4 += (d2 *= (1.0 - 1.0 / (d3 += 1.0)) * this.alpha);
        }
        return d3;
    }

    public boolean isDiscrete() {
        return true;
    }

    public double mean() {
        return this.P1 / (1.0 - this.alpha);
    }

    public double pdf(double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return -Math.pow(this.alpha, d) / (d * this.C1);
    }

    public double random() {
        if (this.alpha > 0.986) {
            double d = this.C1;
            double d2 = this.rand.nextDouble();
            if (d2 > this.alpha) {
                return 1.0;
            }
            double d3 = 1.0 - this.rand.nextDouble();
            double d4 = 1.0 - Math.exp(d3 * d);
            if (d2 < d4 * d4) {
                return Math.floor(1.0 + Math.log(d2) / Math.log(d4));
            }
            if (d2 > d4) {
                return 1.0;
            }
            return 2.0;
        }
        double d = this.P1;
        double d5 = this.rand.nextDouble();
        double d6 = 1.0;
        double d7 = d;
        while (d5 > d7) {
            d5 -= d7;
            d7 *= this.alpha * ((d6 += 1.0) - 1.0) / d6;
        }
        return d6;
    }

    public void setAlpha(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.alpha = d;
        this.C1 = Math.log(1.0 - d);
        this.P1 = -d / this.C1;
    }

    public String toString() {
        return new String("Logarithmic series distribution: alpha = " + this.alpha + ".");
    }

    public double variance() {
        return this.P1 * (1.0 - this.P1) / ((1.0 - this.alpha) * (1.0 - this.alpha));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 0.9;
            LogarithmicSeries logarithmicSeries = new LogarithmicSeries(d);
            int n = 10000;
            logarithmicSeries = new LogarithmicSeries(0.5);
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)logarithmicSeries.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)logarithmicSeries, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

