/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDistribution;
import jsc.distributions.Distribution;
import jsc.distributions.Gamma;
import jsc.distributions.Normal;
import jsc.goodnessfit.ChiSquaredFitTest;
import jsc.util.Maths;

public class Poisson
extends AbstractDistribution {
    private double mean;
    private double alxm;
    private double gg;
    private double sq;

    public Poisson(double d) {
        this.setMean(d);
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return 1.0 - Gamma.incompleteGamma(this.mean, 1.0 + d);
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d2 = 0.0;
        if (this.mean < 20.0) {
            while (this.cdf(d2) < d - 1.0E-8) {
                d2 += 1.0;
            }
        } else {
            Normal normal = new Normal(this.mean, Math.sqrt(this.mean));
            d2 = Math.floor(normal.inverseCdf(d) + 0.5);
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            double d3 = this.cdf(d2);
            while (d3 > d && d2 > 0.0) {
                d3 = this.cdf(d2 -= 1.0);
            }
            while (d3 < d) {
                d3 = this.cdf(d2 += 1.0);
            }
        }
        return d2;
    }

    public boolean isDiscrete() {
        return true;
    }

    public double mean() {
        return this.mean;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return Math.exp(d * Math.log(this.mean) - this.mean - Maths.logFactorial((long)d));
    }

    public double random() {
        double d;
        if (this.mean < 12.0) {
            d = -1.0;
            double d2 = 1.0;
            do {
                d += 1.0;
            } while ((d2 *= this.rand.nextDouble()) > this.gg);
        } else {
            while (true) {
                double d3;
                if ((d = this.sq * (d3 = Math.tan(Math.PI * this.rand.nextDouble())) + this.mean) < 0.0) {
                    continue;
                }
                d = Math.floor(d);
                double d4 = 0.9 * (1.0 + d3 * d3) * Math.exp(d * this.alxm - Maths.logGamma(d + 1.0) - this.gg);
                if (!(this.rand.nextDouble() > d4)) break;
            }
        }
        return d;
    }

    public void setMean(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid Poisson parameter.");
        }
        this.mean = d;
        if (d < 12.0) {
            this.gg = Math.exp(-d);
        } else {
            this.sq = Math.sqrt(2.0 * d);
            this.alxm = Math.log(d);
            this.gg = d * this.alxm - Maths.logGamma(d + 1.0);
        }
    }

    public String toString() {
        return new String("Poisson distribution: mean = " + this.mean + ".");
    }

    public double variance() {
        return this.mean;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 1000000;
            Poisson poisson = new Poisson(15.0);
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)poisson.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)poisson, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

