/*
 * Decompiled with CFR 0.152.
 */
package jsc.goodnessfit;

import java.util.Arrays;
import jsc.descriptive.CategoricalTally;
import jsc.descriptive.DoubleFrequencyTable;
import jsc.descriptive.DoubleTally;
import jsc.descriptive.Tally;
import jsc.distributions.ChiSquared;
import jsc.distributions.DiscreteUniform;
import jsc.distributions.Distribution;
import jsc.tests.SignificanceTest;

public class ChiSquaredFitTest
implements SignificanceTest {
    private int df;
    private int k;
    private int n;
    private int estimatedParasCount;
    private int smallExpectedFrequencyCount = 0;
    private double chi;
    private int[] O;
    private double[] E;
    private double[] probs;
    private double[] resids;
    private double SP;

    public ChiSquaredFitTest(int[] nArray) {
        this(nArray, ChiSquaredFitTest.getUniformProbs(nArray.length), 0);
    }

    public ChiSquaredFitTest(int[] nArray, double[] dArray, int n) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += nArray[n4];
            ++n4;
        }
        this.calculateChiSquared(n3, n2, nArray, dArray, n);
    }

    public ChiSquaredFitTest(CategoricalTally categoricalTally) {
        this(categoricalTally, ChiSquaredFitTest.getUniformProbs(categoricalTally.getNumberOfBins()), 0);
    }

    public ChiSquaredFitTest(CategoricalTally categoricalTally, double[] dArray, int n) {
        this.calculateChiSquared(categoricalTally.getN(), categoricalTally.getNumberOfBins(), categoricalTally.getFrequencies(), dArray, n);
    }

    public ChiSquaredFitTest(Tally tally) {
        this(tally, (Distribution)new DiscreteUniform(tally.getMin(), tally.getMax()), 0);
    }

    public ChiSquaredFitTest(Tally tally, Distribution distribution, int n) {
        int n2 = tally.getNumberOfBins();
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = distribution.pdf(tally.getBinValue(n3));
            ++n3;
        }
        this.calculateChiSquared(tally.getN(), n2, tally.getFrequencies(), dArray, n);
    }

    public ChiSquaredFitTest(DoubleTally doubleTally, Distribution distribution, int n) {
        int n2 = doubleTally.getValueCount();
        int[] nArray = new int[n2];
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = doubleTally.getFrequency(n3);
            dArray[n3] = distribution.pdf(doubleTally.getValue(n3));
            ++n3;
        }
        this.calculateChiSquared(doubleTally.getN(), n2, nArray, dArray, n);
    }

    public ChiSquaredFitTest(DoubleFrequencyTable doubleFrequencyTable, Distribution distribution, int n) {
        int n2 = doubleFrequencyTable.getNumberOfBins();
        double[] dArray = new double[n2];
        double d = distribution.cdf(doubleFrequencyTable.getBoundary(0));
        int n3 = 0;
        while (n3 < n2) {
            double d2 = distribution.cdf(doubleFrequencyTable.getBoundary(1 + n3));
            dArray[n3] = d2 - d;
            d = d2;
            ++n3;
        }
        this.calculateChiSquared(doubleFrequencyTable.getN(), n2, doubleFrequencyTable.getFrequencies(), dArray, n);
    }

    private void calculateChiSquared(int n, int n2, int[] nArray, double[] dArray, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Negative number of estimated parameters.");
        }
        this.df = n2 - n3 - 1;
        if (this.df < 1) {
            throw new IllegalArgumentException("Zero degrees of freedom.");
        }
        this.n = n;
        this.k = n2;
        this.O = nArray;
        this.estimatedParasCount = n3;
        this.probs = dArray;
        this.E = new double[n2];
        this.resids = new double[n2];
        this.chi = 0.0;
        this.smallExpectedFrequencyCount = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (dArray[n4] < 0.0 || dArray[n4] > 1.0) {
                throw new IllegalArgumentException("Invalid probability.");
            }
            this.E[n4] = (double)n * dArray[n4];
            if (this.E[n4] == 0.0) {
                throw new IllegalArgumentException("An expected frequency is zero.");
            }
            if (this.E[n4] < 5.0) {
                ++this.smallExpectedFrequencyCount;
            }
            this.resids[n4] = ((double)this.O[n4] - this.E[n4]) * ((double)this.O[n4] - this.E[n4]) / this.E[n4];
            this.chi += this.resids[n4];
            ++n4;
        }
        this.SP = ChiSquared.upperTailProb(this.chi, this.df);
    }

    public int getDegreesOfFreedom() {
        return this.df;
    }

    public int getN() {
        return this.n;
    }

    public int getNumberOfBins() {
        return this.k;
    }

    public double[] getExpectedFrequencies() {
        return this.E;
    }

    public double getExpectedFrequency(int n) {
        return this.E[n];
    }

    public int[] getObservedFrequencies() {
        return this.O;
    }

    public int getObservedFrequency(int n) {
        return this.O[n];
    }

    public double[] getResiduals() {
        return this.resids;
    }

    public double getResidual(int n) {
        return this.resids[n];
    }

    public int getSmallExpectedFrequencyCount() {
        return this.smallExpectedFrequencyCount;
    }

    public double getTestStatistic() {
        return this.chi;
    }

    private static double[] getUniformProbs(int n) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, 1.0 / (double)n);
        return dArray;
    }

    public double getSP() {
        return this.SP;
    }

    public boolean poolBins() {
        int n;
        do {
            n = this.k;
            if (this.df == 1) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.k - 1) {
                if (this.E[n2] < 5.0) {
                    double d = this.E[n2];
                    int n3 = n2;
                    int n4 = n3 + 1;
                    while (n4 < this.k) {
                        if ((d += this.E[n4]) >= 5.0) break;
                        ++n4;
                    }
                    if (n4 == this.k) {
                        --n4;
                    }
                    this.poolBins(n3, n4);
                }
                ++n2;
            }
            if (!(this.E[this.k - 1] < 5.0) || this.k <= 2) continue;
            this.poolBins(this.k - 2, this.k - 1);
        } while (n != this.k && this.k > 2);
        return this.smallExpectedFrequencyCount == 0;
    }

    public double poolBins(int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.k - n3;
        int n5 = 0;
        double d = 0.0;
        int[] nArray = new int[n4];
        double[] dArray = new double[n4];
        if (n3 < 1 || n < 0 || n2 >= this.k) {
            throw new IllegalArgumentException("Invalid pool indexes.");
        }
        int n6 = 0;
        while (n6 < n) {
            dArray[n6] = this.probs[n6];
            nArray[n6] = this.O[n6];
            ++n6;
        }
        n6 = n;
        while (n6 <= n2) {
            d += this.probs[n6];
            n5 += this.O[n6];
            ++n6;
        }
        dArray[n] = d;
        nArray[n] = n5;
        n6 = n + 1;
        while (n6 < n4) {
            dArray[n6] = this.probs[n6 + n3];
            nArray[n6] = this.O[n6 + n3];
            ++n6;
        }
        this.calculateChiSquared(this.n, n4, nArray, dArray, this.estimatedParasCount);
        return (double)this.n * d;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int[] nArray = new int[]{1, 2, 3, 2, 1, 3, 4, 2, 1};
            double[] dArray = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(nArray, dArray, 0);
            chiSquaredFitTest.poolBins();
            int n = 0;
            while (n < chiSquaredFitTest.getNumberOfBins()) {
                System.out.println("O = " + chiSquaredFitTest.getObservedFrequency(n) + " E = " + chiSquaredFitTest.getExpectedFrequency(n) + " resid = " + chiSquaredFitTest.getResidual(n));
                ++n;
            }
            System.out.println("Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

