/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.distributions.Gamma;
import jsc.independentsamples.MannWhitneyMedianDifferenceCI;
import jsc.util.Arrays;

public class RatioScaleCI
extends MannWhitneyMedianDifferenceCI {
    public RatioScaleCI(double[] dArray, double[] dArray2, double d, int n) {
        super(Arrays.log(dArray), Arrays.log(dArray2), d, n);
        this.lowerLimit = Math.exp(this.lowerLimit);
        this.upperLimit = Math.exp(this.upperLimit);
    }

    public RatioScaleCI(double[] dArray, double[] dArray2, double d) {
        this(dArray, dArray2, d, 0);
    }

    public double getPointEstimate() {
        if (this.method == 3) {
            return Math.exp(this.dpoint);
        }
        return Math.exp(MannWhitneyMedianDifferenceCI.getPointEstimate(this.xA, this.xB));
    }

    public static double getPointEstimate(double[] dArray, double[] dArray2) {
        return Math.exp(MannWhitneyMedianDifferenceCI.getPointEstimate(Arrays.log(dArray), Arrays.log(dArray2)));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 25;
            int n2 = n + 1;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n2];
            double d = 1.0;
            Gamma gamma = new Gamma(d, 2.0);
            Gamma gamma2 = new Gamma(d, 1.0);
            gamma.setSeed(123L);
            gamma2.setSeed(321L);
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = gamma.random();
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                dArray2[n3] = gamma2.random();
                ++n3;
            }
            long l = System.currentTimeMillis();
            RatioScaleCI ratioScaleCI = new RatioScaleCI(dArray, dArray2, 0.95, 3);
            long l2 = System.currentTimeMillis();
            System.out.println("n = " + n + " Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("  Fast CI=[" + ratioScaleCI.getLowerLimit() + "," + ratioScaleCI.getUpperLimit() + "]" + " d = " + ratioScaleCI.getD() + " Point estimate = " + ratioScaleCI.getPointEstimate() + " Achieved conf = " + ratioScaleCI.getAchievedConfidence());
            ratioScaleCI = new RatioScaleCI(dArray, dArray2, 0.95, 2);
            l2 = System.currentTimeMillis();
            System.out.println("n = " + n + " Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("Approx CI=[" + ratioScaleCI.getLowerLimit() + "," + ratioScaleCI.getUpperLimit() + "]" + " d = " + ratioScaleCI.getD() + " Point estimate = " + ratioScaleCI.getPointEstimate() + " Achieved conf = " + ratioScaleCI.getAchievedConfidence());
            ratioScaleCI = new RatioScaleCI(dArray, dArray2, 0.95, 1);
            l2 = System.currentTimeMillis();
            System.out.println("n = " + n + " Time = " + (l2 - l) / 1000L + " secs");
            System.out.println(" Exact CI=[" + ratioScaleCI.getLowerLimit() + "," + ratioScaleCI.getUpperLimit() + "]" + " d = " + ratioScaleCI.getD() + " Point estimate = " + ratioScaleCI.getPointEstimate() + " Achieved conf = " + ratioScaleCI.getAchievedConfidence());
        }
    }
}

