/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.combinatorics.Enumerator;
import jsc.combinatorics.MultiSetPermutations;
import jsc.distributions.ChiSquared;
import jsc.distributions.Normal;
import jsc.distributions.Tail;
import jsc.goodnessfit.SampleDistributionFunction;
import jsc.independentsamples.PermutableTwoSampleStatistic;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;
import jsc.util.Arrays;
import jsc.util.Maths;

public class SmirnovTest
extends PermutableTwoSampleStatistic
implements SignificanceTest {
    private static final double EPS = 1.0E-6;
    private static final double SMALL = Double.MIN_VALUE;
    private static final double SMALL_N = Math.log(Double.MIN_VALUE);
    private static final double ALN2 = Math.log(2.0);
    private static final double CHKNUM = 1.0E64;
    private static final int ITERUP = 1000;
    private static final int SMALL_SAMPLE_SIZE = 5000;
    private final H1 alternative;
    final int nA;
    final int nB;
    private double D;
    private long Dstar;
    private final double SP;
    private SampleDistributionFunction sdfA;
    private SampleDistributionFunction sdfB;

    public SmirnovTest(double[] dArray, double[] dArray2, H1 h1, boolean bl) {
        super(dArray, dArray2);
        this.alternative = h1;
        this.sdfA = new SampleDistributionFunction(dArray);
        this.sdfB = new SampleDistributionFunction(dArray2);
        this.nA = this.sdfA.getN();
        this.nB = this.sdfB.getN();
        this.permutedSampleA = new double[this.nA];
        this.permutedSampleB = new double[this.nB];
        this.originalSample = Arrays.append(dArray2, dArray);
        this.N = this.nA + this.nB;
        this.Dstar = this.calculateTestStatistic(this.sdfA, this.sdfB);
        this.D = (double)this.Dstar / (double)(this.nA * this.nB);
        this.SP = this.D == 0.0 ? 1.0 : (bl ? SmirnovTest.approxSP(this.nA, this.nB, this.D, h1) : SmirnovTest.exactSP(this.nA, this.nB, this.D, h1));
    }

    public SmirnovTest(double[] dArray, double[] dArray2, H1 h1) {
        this(dArray, dArray2, h1, dArray.length > 5000 && dArray2.length > 5000);
    }

    public SmirnovTest(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, H1.NOT_EQUAL, dArray.length > 5000 && dArray2.length > 5000);
    }

    public static double approxSP(int n, int n2, double d, H1 h1) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Invalid sample sizes.");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid D value.");
        }
        if (h1 == H1.NOT_EQUAL) {
            return SmirnovTest.probks(n, n2, d);
        }
        double d2 = n + n2;
        double d3 = n * n2;
        return ChiSquared.upperTailProb(4.0 * d * d * d3 / d2, 2.0);
    }

    private long calculateTestStatistic(SampleDistributionFunction sampleDistributionFunction, SampleDistributionFunction sampleDistributionFunction2) {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = sampleDistributionFunction.getN();
        int n4 = sampleDistributionFunction2.getN();
        while (n < n3 && n2 < n4) {
            double d4;
            double d5;
            double d6 = sampleDistributionFunction.getOrderedX(n);
            if (d6 <= (d5 = sampleDistributionFunction2.getOrderedX(n2))) {
                d = sampleDistributionFunction.getOrderedS(n++);
            }
            if (d5 <= d6) {
                d2 = sampleDistributionFunction2.getOrderedS(n2++);
            }
            if (!((d4 = this.alternative == H1.GREATER_THAN ? d2 - d : (this.alternative == H1.LESS_THAN ? d - d2 : Math.abs(d2 - d))) > d3)) continue;
            d3 = d4;
        }
        return Math.round((double)(n3 * n4) * d3);
    }

    public static double exactSP(int n, int n2, double d, H1 h1) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Invalid sample sizes.");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid D value.");
        }
        return SmirnovTest.gsmirn(n, n2, d, h1, Arrays.fill(n + n2 + 1, 1));
    }

    public Enumerator getEnumerator() {
        int[] nArray = new int[]{this.nA, this.nB};
        return new MultiSetPermutations(nArray);
    }

    public SampleDistributionFunction getSdfA() {
        return this.sdfA;
    }

    public SampleDistributionFunction getSdfB() {
        return this.sdfB;
    }

    public double getSP() {
        return this.SP;
    }

    public double getStatistic() {
        return this.Dstar;
    }

    public double getTestStatistic() {
        return this.D;
    }

    private static double gsmirn(int n, int n2, double d, H1 h1, int[] nArray) {
        double d2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n + n2;
        double[] dArray = new double[n + 3];
        int n8 = 0;
        int n9 = 0;
        do {
            if (nArray[++n9] <= 0) {
                throw new IllegalArgumentException("Invalid number of observations.");
            }
            if ((n8 += nArray[n9]) <= n7) continue;
            throw new IllegalArgumentException("Invalid number of observations.");
        } while (n8 < n7);
        double d3 = 1.0;
        double d4 = d - 1.0E-6;
        if (d4 <= 0.0) {
            return d3;
        }
        dArray[1] = 1.0;
        double d5 = (double)n / (double)n7;
        double d6 = d5 * d4 * (double)n2;
        boolean bl = true;
        n8 = 1;
        int n10 = nArray[1];
        int n11 = 0;
        int n12 = 0;
        int n13 = 1000;
        int n14 = 0;
        double d7 = 1.0;
        n9 = 1;
        while (n9 <= n7 - 1) {
            int n15;
            if (n10 == 1) {
                d2 = (double)n9 * d5;
                n12 = Math.min((int)(d2 + d6), Math.min(n9, n));
                n11 = Math.max((int)(d2 - d6 + 1.0), Math.max(n9 - n2, 0));
                n10 = nArray[++n8];
                bl = true;
            } else {
                --n10;
                if (bl) {
                    bl = false;
                    int n16 = n9 + n10;
                    d2 = (double)n16 * d5;
                    int n17 = Math.min((int)(d2 + d6), Math.min(n16, n));
                    int n18 = Math.max((int)(d2 - d6 + 1.0), Math.max(n16 - n2, 0));
                    n3 = n11;
                    n4 = n17;
                    n6 = n16 - n18;
                    n5 = n9 - n12 - 1;
                }
                n11 = Math.max(n3, n9 - n6);
                n12 = Math.min(n4, n9 - n5);
            }
            if (h1 == H1.GREATER_THAN) {
                n12 = Math.min(n, n9);
            } else if (h1 == H1.LESS_THAN) {
                n11 = Math.max(0, n9 - n2);
            }
            int n19 = Math.max(1, n11);
            int n20 = n15 = Math.min(n9 - 1, n12);
            while (n20 >= n19) {
                dArray[n20 + 1] = dArray[n20 + 1] + dArray[n20];
                --n20;
            }
            if (--n13 <= 0) {
                d2 = 0.0;
                n20 = n19 + 1;
                while (n20 <= n15 + 1) {
                    d2 = Math.max(dArray[n20], d2);
                    ++n20;
                }
                if (d2 == 0.0) {
                    return d3;
                }
                if (d2 > 1.0E64) {
                    n20 = n19 + 1;
                    while (n20 <= n15 + 1) {
                        dArray[n20] = dArray[n20] * Double.MIN_VALUE;
                        ++n20;
                    }
                    n13 = 1000;
                    ++n14;
                    d7 *= Double.MIN_VALUE;
                } else {
                    n13 = (int)((-SMALL_N - Math.log(d2)) / ALN2);
                }
            }
            dArray[n19] = n11 == 0 ? d7 : 0.0;
            dArray[n15 + 2] = n12 == n9 ? d7 : 0.0;
            ++n9;
        }
        d2 = dArray[n + 1] + dArray[n];
        if (d2 == 0.0) {
            return d3;
        }
        d3 = 1.0 - Math.exp(Maths.logFactorial(n) + Maths.logFactorial(n2) + Math.log(d2) - (double)n14 * SMALL_N - Maths.logFactorial(n7));
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Invalid SP " + d3);
        }
        return d3;
    }

    private static double probks(int n, int n2, double d) {
        double d2 = 0.0;
        double d3 = 2.0;
        double d4 = 0.0;
        double d5 = d * Math.sqrt(n * n2 / (n + n2));
        double d6 = -2.0 * d5 * d5;
        int n3 = 1;
        while (n3 <= 1000) {
            double d7 = d3 * Math.exp(d6 * (double)n3 * (double)n3);
            d2 += d7;
            if (Math.abs(d7) <= 0.001 * d4 || Math.abs(d7) < 1.0E-8 * d2) {
                if (d2 > 1.0) {
                    d2 = 1.0;
                } else if (d2 < 0.0) {
                    d2 = 0.0;
                }
                return d2;
            }
            d3 = -d3;
            d4 = Math.abs(d7);
            ++n3;
        }
        throw new RuntimeException("Cannot calculate approximate SP");
    }

    public double resampleStatistic(double[] dArray, double[] dArray2) {
        SampleDistributionFunction sampleDistributionFunction = new SampleDistributionFunction(dArray);
        SampleDistributionFunction sampleDistributionFunction2 = new SampleDistributionFunction(dArray2);
        double d = this.calculateTestStatistic(sampleDistributionFunction, sampleDistributionFunction2);
        return d;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 0.0;
            H1 h1 = H1.NOT_EQUAL;
            int n = 11;
            int n2 = 11;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n2];
            Normal normal = new Normal(0.0, 1.0);
            normal.setSeed(100L);
            Normal normal2 = new Normal(1.0, 1.0);
            normal2.setSeed(200L);
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = normal.random();
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                dArray2[n3] = normal2.random();
                ++n3;
            }
            Tail tail = Tail.TWO;
            n = 25;
            n2 = 25;
            d = 300.0;
            double d2 = d / (double)(n * n2);
            n = 100;
            n2 = 50;
            d2 = 0.36;
            System.out.println("D* = " + d + " D = " + d2);
            long l = System.currentTimeMillis();
            System.out.println("Approx SP = " + SmirnovTest.approxSP(n, n2, d2, h1));
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) + " millisecs");
            l = System.currentTimeMillis();
            System.out.println(" Exact SP = " + SmirnovTest.exactSP(n, n2, d2, h1));
            l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) + " millisecs");
        }
    }
}

