/*
 * Decompiled with CFR 0.152.
 */
package jsc.numerical;

import jsc.distributions.Beta;
import jsc.distributions.ChiSquared;
import jsc.distributions.Normal;
import jsc.distributions.PowerFunction;
import jsc.numerical.ExtendedMidpointNegExpRule;
import jsc.numerical.ExtendedMidpointPosExpRule;
import jsc.numerical.ExtendedMidpointRule;
import jsc.numerical.ExtendedTrapezoidalRule;
import jsc.numerical.Function;
import jsc.numerical.IntegratingFunction;
import jsc.numerical.NumericalException;
import jsc.util.Maths;

public class Integration {
    private static final int JMAX = 14;
    private static final int JMAXP = 15;
    private static final int K = 5;
    private static double dy;
    private static final double RT3;
    private static final double HAFRT3;
    private static final double TWOPI = Math.PI * 2;
    private static final int M_MAX = 8;
    private static double esterr;
    private static int used;
    private static double[] csxfrm;

    private Integration() {
    }

    public static double clenshawCurtis(Function function, double d, double d2, double d3, int n) throws NumericalException {
        int[] nArray = new int[9];
        double d4 = (d + d2) * 0.5;
        double d5 = (d2 - d) * 0.5;
        int n2 = (int)Math.min((double)n, 2.0 * Math.pow(3.0, 9.0));
        int n3 = 1;
        while (n3 <= 8) {
            nArray[n3] = 1;
            ++n3;
        }
        csxfrm = new double[n2 + 1];
        int n4 = 6;
        Integration.csxfrm[1] = function.function(d);
        Integration.csxfrm[7] = function.function(d2);
        double d6 = d5 * RT3 * 0.5;
        Integration.csxfrm[2] = function.function(d4 - d6);
        Integration.csxfrm[6] = function.function(d4 + d6);
        d6 = d5 * 0.5;
        Integration.csxfrm[3] = function.function(d4 - d6);
        Integration.csxfrm[5] = function.function(d4 + d6);
        Integration.csxfrm[4] = function.function(d4);
        double d7 = csxfrm[1] + csxfrm[7];
        double d8 = csxfrm[1] - csxfrm[7];
        double d9 = 2.0 * csxfrm[4];
        double d10 = csxfrm[2] + csxfrm[6];
        double d11 = (csxfrm[2] - csxfrm[6]) * RT3;
        double d12 = csxfrm[3] + csxfrm[5];
        double d13 = csxfrm[3] - csxfrm[5];
        double d14 = d7 + d12 + d12;
        double d15 = d10 + d10 + d9;
        double d16 = d8 + d13;
        double d17 = d7 - d12;
        double d18 = d10 - d9;
        Integration.csxfrm[1] = d14 + d15;
        Integration.csxfrm[2] = d16 + d11;
        Integration.csxfrm[3] = d17 + d18;
        Integration.csxfrm[4] = d8 - d13 - d13;
        Integration.csxfrm[5] = d17 - d18;
        Integration.csxfrm[6] = d16 - d11;
        Integration.csxfrm[7] = d14 - d15;
        used = 7;
        double d19 = (d7 + d9 + d9) / 3.0;
        while (true) {
            double d20;
            int n5;
            int n6;
            int n7 = n4 - 3;
            double d21 = 0.5 * csxfrm[used] / (1.0 - (double)(n4 * n4));
            n3 = 1;
            while (n3 <= n7) {
                n6 = n4 - n3;
                d21 += csxfrm[n6] / (double)(n6 * (2 - n6));
                n3 += 2;
            }
            esterr = Math.abs(d19 * 3.0 - (d21 += 0.5 * csxfrm[1]));
            if (Math.abs(d21) * d3 >= esterr || 3 * n4 + 1 > n2) {
                double d22 = d5 * d21 / (0.5 * (double)n4);
                esterr = d5 * esterr / (0.5 * (double)n4);
                csxfrm = null;
                return d22;
            }
            d19 = d21;
            n3 = 2;
            while (n3 <= 8) {
                nArray[n3 - 1] = nArray[n3];
                ++n3;
            }
            nArray[8] = 3 * nArray[7];
            n3 = used;
            double d23 = Math.PI / (double)(3 * n4);
            int n8 = 1;
            while (n8 <= nArray[1]) {
                n5 = n8;
                while (n5 <= nArray[2]) {
                    int n9 = n5;
                    while (n9 <= nArray[3]) {
                        int n10 = n9;
                        while (n10 <= nArray[4]) {
                            int n11 = n10;
                            while (n11 <= nArray[5]) {
                                int n12 = n11;
                                while (n12 <= nArray[6]) {
                                    int n13 = n12;
                                    while (n13 <= nArray[7]) {
                                        n6 = n13;
                                        while (n6 <= nArray[8]) {
                                            d20 = d23 * (double)(3 * n6 - 2);
                                            d6 = d5 * Math.cos(d20);
                                            d7 = function.function(d4 - d6);
                                            d9 = function.function(d4 + d6);
                                            d6 = d5 * Math.sin(d20);
                                            d8 = function.function(d4 + d6);
                                            d10 = function.function(d4 - d6);
                                            d11 = d7 + d9;
                                            d12 = d8 + d10;
                                            Integration.csxfrm[n3 + 1] = d11 + d12;
                                            Integration.csxfrm[n3 + 2] = d7 - d9;
                                            Integration.csxfrm[n3 + 3] = d11 - d12;
                                            Integration.csxfrm[n3 + 4] = d8 - d10;
                                            n3 += 4;
                                            n6 += nArray[7];
                                        }
                                        n13 += nArray[6];
                                    }
                                    n12 += nArray[5];
                                }
                                n11 += nArray[4];
                            }
                            n10 += nArray[3];
                        }
                        n9 += nArray[2];
                    }
                    n5 += nArray[1];
                }
                ++n8;
            }
            int n14 = n4 + n4;
            int n15 = 4;
            do {
                n8 = used + n15;
                n5 = used + n15 + n15;
                int n16 = n14 - n15 - n15;
                Integration.r3pass(n14, n15, n16, used, n8, n5);
            } while ((n15 *= 3) < n4);
            d7 = csxfrm[1];
            d8 = csxfrm[used + 1];
            Integration.csxfrm[1] = d7 + d8 + d8;
            Integration.csxfrm[Integration.used + 1] = d7 - d8;
            d7 = csxfrm[n4 + 1];
            d8 = csxfrm[n14 + 2];
            Integration.csxfrm[n4 + 1] = d7 + d8;
            Integration.csxfrm[n14 + 2] = d7 - d8 - d8;
            int n17 = 3 * n4;
            int n18 = n4 - 1;
            n3 = 1;
            while (n3 <= n18) {
                n8 = n4 + n3;
                n5 = n17 - n3;
                d20 = d23 * (double)n3;
                double d24 = Math.cos(d20);
                double d25 = Math.sin(d20);
                d7 = d24 * csxfrm[n8 + 2] - d25 * csxfrm[n5 + 2];
                d8 = (d25 * csxfrm[n8 + 2] + d24 * csxfrm[n5 + 2]) * RT3;
                Integration.csxfrm[n8 + 2] = csxfrm[n3 + 1] - d7 - d8;
                Integration.csxfrm[n5 + 2] = csxfrm[n3 + 1] - d7 + d8;
                int n19 = n3 + 1;
                csxfrm[n19] = csxfrm[n19] + (d7 + d7);
                ++n3;
            }
            d7 = csxfrm[n14 + 1];
            d8 = csxfrm[n14 + 2];
            n3 = 1;
            while (n3 <= n18) {
                n8 = used + n3;
                n5 = n14 + n3;
                Integration.csxfrm[n5] = csxfrm[n8];
                Integration.csxfrm[n8] = csxfrm[n5 + 2];
                ++n3;
            }
            Integration.csxfrm[n17] = d7;
            Integration.csxfrm[n17 + 1] = d8;
            n4 = n17;
            used = n4 + 1;
        }
    }

    private static void r3pass(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        double d;
        double d2;
        int n8 = (n2 - 1) / 2;
        int n9 = n2 * 3;
        double d3 = Math.PI * 2 / (double)n9;
        int n10 = 1;
        while (n10 <= n) {
            d2 = csxfrm[n10 + n5] + csxfrm[n10 + n6];
            d = (csxfrm[n10 + n5] - csxfrm[n10 + n6]) * HAFRT3;
            Integration.csxfrm[n10 + n5] = csxfrm[n10 + n4] - d2 * 0.5;
            Integration.csxfrm[n10 + n6] = d;
            int n11 = n10 + n4;
            csxfrm[n11] = csxfrm[n11] + d2;
            n10 += n9;
        }
        n10 = n7 = n2 / 2 + 1;
        while (n10 <= n) {
            d2 = (csxfrm[n10 + n5] + csxfrm[n10 + n6]) * HAFRT3;
            d = csxfrm[n10 + n5] - csxfrm[n10 + n6];
            Integration.csxfrm[n10 + n5] = csxfrm[n10 + n4] - d;
            Integration.csxfrm[n10 + n6] = d2;
            int n12 = n10 + n4;
            csxfrm[n12] = csxfrm[n12] + d * 0.5;
            n10 += n9;
        }
        n7 = 1;
        while (n7 <= n8) {
            int n13 = n7 + 1;
            int n14 = n2 - n7 + 1;
            double d4 = d3 * (double)n7;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            double d7 = d5 * d5 - d6 * d6;
            double d8 = 2.0 * d6 * d5;
            int n15 = n13;
            while (n15 <= n) {
                int n16 = n15 - n13 + n14;
                double d9 = csxfrm[n15 + n4];
                double d10 = csxfrm[n16 + n4];
                double d11 = d5 * csxfrm[n15 + n5] - d6 * csxfrm[n16 + n5];
                double d12 = d6 * csxfrm[n15 + n5] + d5 * csxfrm[n16 + n5];
                double d13 = d7 * csxfrm[n15 + n6] - d8 * csxfrm[n16 + n6];
                double d14 = d8 * csxfrm[n15 + n6] + d7 * csxfrm[n16 + n6];
                d2 = d11 + d13;
                d = (d11 - d13) * HAFRT3;
                double d15 = d9 - 0.5 * d2;
                double d16 = d12 + d14;
                double d17 = (d12 - d14) * HAFRT3;
                double d18 = d10 - 0.5 * d16;
                Integration.csxfrm[n15 + n4] = d9 + d2;
                Integration.csxfrm[n16 + n4] = d15 + d17;
                Integration.csxfrm[n15 + n5] = d15 - d17;
                Integration.csxfrm[n16 + n5] = d + d18;
                Integration.csxfrm[n15 + n6] = d - d18;
                Integration.csxfrm[n16 + n6] = d10 + d16;
                n15 += n9;
            }
            ++n7;
        }
    }

    public static double integrate(Function function, double d, double d2, boolean bl, double d3, int n) throws NumericalException {
        if (Double.isInfinite(d)) {
            if (Double.isInfinite(d2)) {
                return Integration.romberg(function, d, 0.0, d3, new ExtendedMidpointNegExpRule()) + Integration.romberg(function, 0.0, d2, d3, new ExtendedMidpointPosExpRule());
            }
            return Integration.romberg(function, d, d2, d3, new ExtendedMidpointNegExpRule());
        }
        if (Double.isInfinite(d2)) {
            return Integration.romberg(function, d, d2, d3, new ExtendedMidpointPosExpRule());
        }
        if (bl) {
            return Integration.romberg(function, d, d2, d3, new ExtendedMidpointRule());
        }
        return Integration.clenshawCurtis(function, d, d2, d3, n);
    }

    private static double polint(double[] dArray, double[] dArray2, int n, double d) throws NumericalException {
        int n2 = 1;
        double[] dArray3 = new double[n + 1];
        double[] dArray4 = new double[n + 1];
        double d2 = Math.abs(d - dArray[1]);
        int n3 = 1;
        while (n3 <= n) {
            double d3;
            double d4 = Math.abs(d - dArray[n3]);
            if (d3 < d2) {
                n2 = n3;
                d2 = d4;
            }
            dArray3[n3] = dArray2[n3];
            dArray4[n3] = dArray2[n3];
            ++n3;
        }
        double d5 = dArray2[n2--];
        int n4 = 1;
        while (n4 < n) {
            n3 = 1;
            while (n3 <= n - n4) {
                double d6 = dArray[n3] - d;
                double d7 = dArray[n3 + n4] - d;
                double d8 = dArray3[n3 + 1] - dArray4[n3];
                double d9 = d6 - d7;
                if (d9 == 0.0) {
                    throw new NumericalException("Cannot interpolate: identical x values");
                }
                d9 = d8 / d9;
                dArray4[n3] = d7 * d9;
                dArray3[n3] = d6 * d9;
                ++n3;
            }
            dy = 2 * n2 < n - n4 ? dArray3[n2 + 1] : dArray4[n2--];
            d5 += dy;
            ++n4;
        }
        return d5;
    }

    public static double romberg(Function function, double d, double d2, double d3, int n) throws NumericalException {
        int n2 = n + 1;
        double[] dArray = new double[n2 + 1];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        ExtendedTrapezoidalRule extendedTrapezoidalRule = new ExtendedTrapezoidalRule();
        dArray2[1] = 1.0;
        int n3 = 1;
        while (n3 <= n) {
            dArray[n3] = extendedTrapezoidalRule.getIntegral(function, d, d2, n3);
            if (n3 >= 5) {
                System.arraycopy(dArray2, n3 - 5 + 1, dArray4, 1, 5);
                System.arraycopy(dArray, n3 - 5 + 1, dArray3, 1, 5);
                double d4 = Integration.polint(dArray4, dArray3, 5, 0.0);
                if (Math.abs(dy) <= d3 * Math.abs(d4) / 300.0) {
                    return d4;
                }
            }
            dArray2[n3 + 1] = 0.25 * dArray2[n3];
            ++n3;
        }
        throw new NumericalException("Required accuracy not achieved in integration.");
    }

    public static double romberg(Function function, double d, double d2, double d3, IntegratingFunction integratingFunction) throws NumericalException {
        double d4 = 0.0;
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        dArray[1] = 1.0;
        int n = 1;
        while (n <= 14) {
            try {
                dArray2[n] = integratingFunction.getIntegral(function, d, d2, n);
            }
            catch (NumericalException numericalException) {
                return d4;
            }
            if (n >= 5) {
                System.arraycopy(dArray, n - 5 + 1, dArray3, 1, 5);
                System.arraycopy(dArray2, n - 5 + 1, dArray4, 1, 5);
                d4 = Integration.polint(dArray3, dArray4, 5, 0.0);
                if (Math.abs(dy) <= d3 * Math.abs(d4)) {
                    return d4;
                }
            }
            dArray2[n + 1] = dArray2[n];
            dArray[n + 1] = dArray[n] / 9.0;
            ++n;
        }
        throw new NumericalException("Required accuracy not achieved in integration.");
    }

    static {
        RT3 = Math.sqrt(3.0);
        HAFRT3 = 0.5 * RT3;
    }

    static class Test {
        static int count;

        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 1.0E-6;
            int n = 9;
            int n2 = 51;
            while (n2 <= 55) {
                double d2;
                Test50 test50 = new Test50(n2);
                try {
                    d2 = Integration.clenshawCurtis(test50, test50.getA(), test50.getB(), d, 200);
                    System.out.println("F(" + n2 + ") CC = " + Maths.roundSigFigs(d2, n) + " " + count + " ");
                }
                catch (NumericalException numericalException) {
                    System.out.println("F(" + n2 + ") CC " + numericalException.getMessage());
                }
                count = 0;
                try {
                    d2 = Integration.romberg((Function)test50, test50.getA(), test50.getB(), d, 20);
                    System.out.println("F(" + n2 + ") R2 = " + Maths.roundSigFigs(d2, n) + " " + count + " ");
                }
                catch (NumericalException numericalException) {
                    System.out.println("F(" + n2 + ") R2 " + numericalException.getMessage());
                }
                ++n2;
            }
        }

        static class Func4
        implements Function {
            Normal D = new Normal(1.0, 1.0);

            Func4() {
            }

            public double function(double d) {
                return this.D.pdf(d);
            }
        }

        static class Func3
        implements Function {
            ChiSquared D = new ChiSquared(4.0);

            Func3() {
            }

            public double function(double d) {
                return this.D.pdf(d);
            }
        }

        static class Func2
        implements Function {
            Func2() {
            }

            public double function(double d) {
                double d2 = 1.0;
                if (d < 0.0) {
                    throw new IllegalArgumentException("Invalid variate-value.");
                }
                return Math.exp(-d / d2) / d2;
            }
        }

        static class Func1
        implements Function {
            Func1() {
            }

            public double function(double d) {
                return Math.sqrt(1.0 - d * d);
            }
        }

        static class Test50
        implements Function {
            int i;
            double p = 2.0;
            double q = 4.0;
            Beta B = new Beta(this.p, this.q);
            double b = 1.0;
            double c = 2.0;
            PowerFunction PF = new PowerFunction(this.b, this.c);

            public Test50(int n) {
                this.i = n;
                count = 0;
            }

            public double function(double d) {
                ++count;
                switch (this.i) {
                    case 0: {
                        return Math.pow(d, -5.0);
                    }
                    case 1: {
                        return 1.0;
                    }
                    case 2: {
                        return d - 2.0;
                    }
                    case 3: {
                        return d * d - 2.0 * d + 3.0;
                    }
                    case 4: {
                        return d * d * d - 2.0 * d * d + 3.0 * d - 4.0;
                    }
                    case 5: {
                        return d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0;
                    }
                    case 6: {
                        return d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0;
                    }
                    case 7: {
                        return d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0;
                    }
                    case 8: {
                        return d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0;
                    }
                    case 9: {
                        return d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0;
                    }
                    case 10: {
                        return d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0;
                    }
                    case 11: {
                        return d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0;
                    }
                    case 12: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0;
                    }
                    case 13: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0;
                    }
                    case 14: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0) - 14.0;
                    }
                    case 15: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0) - 14.0) + 15.0;
                    }
                    case 16: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0) - 14.0) + 15.0) - 16.0;
                    }
                    case 17: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0) - 14.0) + 15.0) - 16.0) + 17.0;
                    }
                    case 18: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0) - 14.0) + 15.0) - 16.0) + 17.0) - 18.0;
                    }
                    case 19: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0) - 14.0) + 15.0) - 16.0) + 17.0) - 18.0) + 19.0;
                    }
                    case 20: {
                        return d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * (d * d * d - 2.0 * d * d + 3.0 * d - 4.0) + 5.0) - 6.0) + 7.0) - 8.0) + 9.0) - 10.0) + 11.0) - 12.0) + 13.0) - 14.0) + 15.0) - 16.0) + 17.0) - 18.0) + 19.0) - 20.0;
                    }
                    case 21: {
                        return Math.exp(d);
                    }
                    case 22: {
                        return Math.sin(Math.PI * d);
                    }
                    case 23: {
                        return Math.cos(d);
                    }
                    case 24: {
                        return d / (Math.exp(d) - 1.0);
                    }
                    case 25: {
                        return 1.0 / (1.0 + d * d);
                    }
                    case 26: {
                        return 2.0 / (2.0 + Math.sin(Math.PI * 10 * d));
                    }
                    case 27: {
                        return 1.0 / (1.0 + d * d * d * d);
                    }
                    case 28: {
                        return 1.0 / (1.0 + Math.exp(d));
                    }
                    case 29: {
                        return d * Math.sin(30.0 * d) * Math.cos(d);
                    }
                    case 30: {
                        return d * Math.sin(30.0 * d) * Math.cos(50.0 * d);
                    }
                    case 31: {
                        return d * Math.sin(30.0 * d) / Math.sqrt(1.0 - d * d / 39.47841760435743);
                    }
                    case 32: {
                        return 0.46 * (Math.exp(d) + Math.exp(-d)) - Math.cos(d);
                    }
                    case 33: {
                        return 1.0 / (d * d * d * d + d * d + 0.9);
                    }
                    case 34: {
                        return Math.sqrt(98696.04401089359 - d * d) * Math.sin(d);
                    }
                    case 35: {
                        return 1.0 / (1.0 + d);
                    }
                    case 36: {
                        return Math.sqrt(d);
                    }
                    case 37: {
                        return Math.pow(d, 0.25);
                    }
                    case 38: {
                        return Math.pow(d, 0.125);
                    }
                    case 39: {
                        return Math.pow(d, 0.0625);
                    }
                    case 40: {
                        return Math.sqrt(Math.abs(d * d - 0.25));
                    }
                    case 41: {
                        return Math.pow(d, 1.5);
                    }
                    case 42: {
                        return Math.pow(Math.abs(d * d - 0.25), 1.5);
                    }
                    case 43: {
                        return Math.pow(d, 2.5);
                    }
                    case 44: {
                        return Math.pow(Math.abs(d * d - 0.25), 2.5);
                    }
                    case 46: {
                        if (d >= 0.0 && d <= 0.333) {
                            return d;
                        }
                        if (d > 0.333 && d <= 0.667) {
                            return d + 1.0;
                        }
                        if (d > 0.667 && d <= 1.0) {
                            return d + 2.0;
                        }
                    }
                    case 47: {
                        if (d > 0.49 && d < 0.5) {
                            return 0.0;
                        }
                        return -1000.0 * (d * d - d);
                    }
                    case 48: {
                        if (d >= 0.0 && d <= 0.7182818284590451) {
                            return 1.0 / (d + 2.0);
                        }
                        if (d > 0.7182818284590451 && d <= 1.0) {
                            return 0.0;
                        }
                    }
                    case 49: {
                        return 10000.0 * (d - 0.1) * (d - 0.11) * (d - 0.12) * (d - 0.13);
                    }
                    case 50: {
                        return Math.sin(314.1592653589793 * d);
                    }
                    case 51: {
                        return Math.sqrt(1.0 - d * d);
                    }
                    case 52: {
                        return this.B.pdf(d);
                    }
                    case 53: {
                        return d * this.B.pdf(d);
                    }
                    case 54: {
                        return this.PF.pdf(d);
                    }
                    case 55: {
                        return d * this.PF.pdf(d);
                    }
                }
                return 0.0;
            }

            public double getA() {
                if (this.i == 32 || this.i == 33) {
                    return -1.0;
                }
                if (this.i == 0) {
                    return 0.01;
                }
                return 0.0;
            }

            public double getB() {
                if (this.i >= 29 && this.i <= 31) {
                    return Math.PI * 2;
                }
                if (this.i == 34) {
                    return 314.1592653589793;
                }
                if (this.i == 0) {
                    return 1.1;
                }
                if (this.i == 54 || this.i == 55) {
                    return this.b;
                }
                return 1.0;
            }
        }
    }
}

