/*
 * Decompiled with CFR 0.152.
 */
package jsc.numerical;

import jsc.numerical.Function;
import jsc.numerical.NumericalException;

public class Roots {
    private Roots() {
    }

    public static double bisection(Function function, double d, double d2, double d3, int n) throws NumericalException {
        double d4;
        double d5;
        double d6;
        double d7 = function.function(d);
        if (d7 * (d6 = function.function(d2)) >= 0.0) {
            throw new IllegalArgumentException("Root not bracketed in bisection method");
        }
        if (d7 < 0.0) {
            d5 = d2 - d;
            d4 = d;
        } else {
            d5 = d - d2;
            d4 = d2;
        }
        int n2 = 1;
        while (n2 <= n) {
            double d8 = d4 + (d5 *= 0.5);
            d6 = function.function(d8);
            if (d6 <= 0.0) {
                d4 = d8;
            }
            if (Math.abs(d5) < d3 || d6 == 0.0) {
                return d4;
            }
            ++n2;
        }
        throw new NumericalException("Maximum number of iterations exceeded in bisection method");
    }

    public static double secant(Function function, double d, double d2, double d3, int n) throws NumericalException {
        double d4;
        double d5;
        double d6;
        if (d == d2) {
            throw new IllegalArgumentException("Equal starting values.");
        }
        double d7 = function.function(d);
        double d8 = function.function(d2);
        if (Math.abs(d7) < Math.abs(d8)) {
            d6 = d;
            d5 = d2;
            d4 = d7;
            d7 = d8;
            d8 = d4;
        } else {
            d5 = d;
            d6 = d2;
        }
        int n2 = 1;
        while (n2 <= n) {
            d4 = d8 - d7;
            if (d4 == 0.0) {
                throw new NumericalException("Identical function values " + d8 + " in secant method.");
            }
            double d9 = (d5 - d6) * d8 / d4;
            d5 = d6;
            d7 = d8;
            d8 = function.function(d6 += d9);
            if (Math.abs(d9) < d3 || d8 == 0.0) {
                return d6;
            }
            ++n2;
        }
        throw new NumericalException("Maximum number of iterations exceeded in secant method.");
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) throws NumericalException {
            Func1 func1 = new Func1();
            System.out.println("secant root =" + Roots.secant(func1, 2.0, 1.0, 1.0E-7, 1000));
            System.out.println("bisection root =" + Roots.bisection(func1, 0.0, 10.0, 1.0E-7, 1000));
            Func2 func2 = new Func2();
            System.out.println("secant root =" + Roots.secant(func2, 2.0, 1.0, 1.0E-7, 1000));
            Func3 func3 = new Func3();
            System.out.println("secant root =" + Roots.secant(func3, 2.0, 1.0, 1.0E-7, 1000));
            System.out.println("bisection root =" + Roots.bisection(func3, 0.0, 10.0, 1.0E-7, 1000));
        }

        static class Func0
        implements Function {
            Func0() {
            }

            public double function(double d) {
                return d * d + 1.0;
            }
        }

        static class Func3
        implements Function {
            Func3() {
            }

            public double function(double d) {
                return d * d * d - 2.0 * d - 5.0;
            }
        }

        static class Func2
        implements Function {
            Func2() {
            }

            public double function(double d) {
                return Math.exp(-d) - Math.sin(d);
            }
        }

        static class Func1
        implements Function {
            Func1() {
            }

            public double function(double d) {
                return d * d * d * d - d - 10.0;
            }
        }
    }
}

