/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.ci.AbstractConfidenceInterval;
import jsc.datastructures.PairedData;
import jsc.descriptive.MeanVar;
import jsc.distributions.StudentsT;

public class NormalMeanCI
extends AbstractConfidenceInterval {
    private final MeanVar mv;

    public NormalMeanCI(double[] dArray, double d) {
        super(d);
        this.mv = new MeanVar(dArray);
        int n = this.mv.getN();
        StudentsT studentsT = new StudentsT(n - 1);
        double d2 = 1.0 - d;
        double d3 = studentsT.inverseCdf(1.0 - 0.5 * d2);
        double d4 = this.mv.getMean();
        double d5 = d3 * this.mv.getSd() / Math.sqrt(n);
        this.lowerLimit = d4 - d5;
        this.upperLimit = d4 + d5;
    }

    public NormalMeanCI(PairedData pairedData, double d) {
        this(pairedData.differences(), d);
    }

    public double getMean() {
        return this.mv.getMean();
    }

    public double getSd() {
        return this.mv.getSd();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{4.9, 5.1, 4.6, 5.0, 5.1, 4.7, 4.4, 4.7, 4.6};
            NormalMeanCI normalMeanCI = new NormalMeanCI(dArray, 90.0);
            System.out.println("CI = [" + normalMeanCI.getLowerLimit() + ", " + normalMeanCI.getUpperLimit() + "]");
            double[] dArray2 = new double[]{70.0, 80.0, 62.0, 50.0, 70.0, 30.0, 49.0, 60.0};
            double[] dArray3 = new double[]{75.0, 82.0, 65.0, 58.0, 68.0, 41.0, 55.0, 67.0};
            normalMeanCI = new NormalMeanCI(new PairedData(dArray2, dArray3), 0.9);
            System.out.println("CI = [" + normalMeanCI.getLowerLimit() + ", " + normalMeanCI.getUpperLimit() + "]");
        }
    }
}

