/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import java.util.Arrays;
import java.util.Random;
import jsc.ci.DistributionFreeCI;
import jsc.datastructures.PairedData;
import jsc.distributions.Normal;
import jsc.distributions.WilcoxonT;
import jsc.util.Maths;

public class WilcoxonMedianCI
extends DistributionFreeCI {
    protected static final int SMALL_SAMPLE_SIZE = 24;
    double[] x;

    public WilcoxonMedianCI(double[] dArray, double d, boolean bl) {
        super(d);
        double d2;
        int n = dArray.length;
        if (bl) {
            double d3 = Normal.inverseStandardCdf(0.5 + 0.5 * d);
            this.d = (int)Math.round(0.5 * (0.5 * (double)n * ((double)n + 1.0) + 1.0 - d3 * Math.sqrt((double)n * ((double)n + 1.0) * (2.0 * (double)n + 1.0) / 6.0)));
            Normal normal = WilcoxonT.normalApproximation(n);
            d2 = normal.cdf((double)this.d - 1.0);
        } else {
            WilcoxonT wilcoxonT = new WilcoxonT(n);
            d2 = 0.5 * (1.0 - d);
            long l = wilcoxonT.getMinValue();
            double d4 = wilcoxonT.pdf(l);
            while (l < wilcoxonT.getMaxValue() && d4 < d2) {
                d4 += wilcoxonT.pdf(++l);
            }
            this.d = (int)(--l + 1L);
            d2 = d4 - wilcoxonT.pdf(l + 1L);
        }
        this.achievedConfidence = 1.0 - 2.0 * d2;
        this.computeInterval(0, this.d, dArray, null);
        this.x = dArray;
    }

    public WilcoxonMedianCI(double[] dArray, double d) {
        this(dArray, d, dArray.length > 24);
    }

    public WilcoxonMedianCI(PairedData pairedData, double d, boolean bl) {
        this(pairedData.differences(), d, bl);
    }

    public WilcoxonMedianCI(PairedData pairedData, double d) {
        this(pairedData.differences(), d, pairedData.getN() > 24);
    }

    public double hodgesLehmannEstimate() {
        return WilcoxonMedianCI.hodgesLehmannEstimate(this.x);
    }

    public static double hodgesLehmannEstimate(double[] dArray) {
        int n;
        double d;
        double d2;
        int n2 = dArray.length;
        double[] dArray2 = new double[1 + n2];
        System.arraycopy(dArray, 0, dArray2, 1, n2);
        dArray2[0] = Double.NEGATIVE_INFINITY;
        Arrays.sort(dArray2);
        int n3 = 0;
        int[] nArray = new int[1 + n2];
        int[] nArray2 = new int[1 + n2];
        int[] nArray3 = new int[1 + n2];
        if (n2 <= 2) {
            if (n2 == 1) {
                return dArray2[1];
            }
            return (dArray2[1] + dArray2[2]) / 2.0;
        }
        Random random = new Random();
        int n4 = n2 * (n2 + 1) / 2;
        int n5 = (n4 + 1) / 2;
        int n6 = (n4 + 2) / 2;
        int n7 = 1;
        while (n7 <= n2) {
            nArray[n7] = n7;
            nArray2[n7] = n2;
            ++n7;
        }
        int n8 = n4;
        int n9 = 0;
        int n10 = (n2 + 1) / 2;
        int n11 = (n2 + 2) / 2;
        double d3 = dArray2[n10] + dArray2[n11];
        boolean bl = true;
        block1: while (true) {
            if (!bl) {
                d2 = dArray2[1] + dArray2[1];
                d = dArray2[n2] + dArray2[n2];
                n7 = 1;
                while (n7 <= n2) {
                    if (nArray[n7] <= nArray2[n7]) {
                        int n12 = nArray[n7];
                        d = Math.min(d, dArray2[n12] + dArray2[n7]);
                        int n13 = nArray2[n7];
                        d2 = Math.max(d2, dArray2[n13] + dArray2[n7]);
                    }
                    ++n7;
                }
                d3 = (d2 + d) / 2.0;
                if (d3 <= d || d3 > d2) {
                    d3 = d2;
                }
                if (d != d2 && n8 != 2) {
                    bl = true;
                } else {
                    return d3 / 2.0;
                }
            }
            do {
                if (!bl) {
                    int n14 = random.nextInt(n8 - 1);
                    n7 = 1;
                    while (n7 <= n2) {
                        n3 = n7;
                        if (n14 <= nArray2[n7] - nArray[n7]) break;
                        n14 = n14 - nArray2[n7] + nArray[n7] - 1;
                        ++n7;
                    }
                    int n15 = (nArray[n3] + nArray2[n3]) / 2;
                    d3 = dArray2[n3] + dArray2[n15];
                }
                bl = false;
                n3 = n2;
                n = 0;
                n7 = 1;
                while (n7 <= n2) {
                    nArray3[n7] = 0;
                    while (n3 >= n7) {
                        if (!(dArray2[n7] + dArray2[n3] < d3)) {
                            --n3;
                            continue;
                        }
                        nArray3[n7] = n3 - n7 + 1;
                        n += nArray3[n7];
                        break;
                    }
                    ++n7;
                }
                if (n == n9) continue block1;
                if (n == n6 - 1) break block1;
                if (n - n5 < 0) {
                    n7 = 1;
                    while (n7 <= n2) {
                        nArray[n7] = n7 + nArray3[n7];
                        ++n7;
                    }
                } else {
                    if (n - n5 == 0) break block1;
                    n7 = 1;
                    while (n7 <= n2) {
                        nArray2[n7] = n7 + nArray3[n7] - 1;
                        ++n7;
                    }
                }
                n9 = 0;
                n8 = 0;
                n7 = 1;
                while (n7 <= n2) {
                    n9 = n9 + nArray[n7] - n7;
                    n8 = n8 + nArray2[n7] - nArray[n7] + 1;
                    ++n7;
                }
            } while (n8 > 2);
        }
        d = dArray2[n2] + dArray2[n2];
        d2 = dArray2[1] + dArray2[1];
        n7 = 1;
        while (n7 <= n2) {
            int n16 = nArray3[n7];
            int n17 = n7 + n16;
            if (n16 > 0) {
                d2 = Math.max(d2, dArray2[n7] + dArray2[n17 - 1]);
            }
            n17 = n7 + n16;
            if (n16 < n2 - n7 + 1) {
                d = Math.min(d, dArray2[n7] + dArray2[n17]);
            }
            ++n7;
        }
        double d4 = (d + d2) / 4.0;
        if (n5 < n6) {
            return d4;
        }
        if (n == n5) {
            d4 = d2 / 2.0;
        }
        if (n == n5 - 1) {
            d4 = d / 2.0;
        }
        return d4;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 500;
            double[] dArray = new double[n];
            n = dArray.length;
            Normal normal = new Normal(2.0, 1.0);
            normal.setSeed(123L);
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = normal.random();
                ++n2;
            }
            long l = System.currentTimeMillis();
            WilcoxonMedianCI wilcoxonMedianCI = new WilcoxonMedianCI(dArray, 0.95, true);
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("CI = [" + wilcoxonMedianCI.getLowerLimit() + ", " + wilcoxonMedianCI.getUpperLimit() + "]" + " d = " + wilcoxonMedianCI.getD() + " Point estimate = " + wilcoxonMedianCI.hodgesLehmannEstimate() + " Achieved confidence = " + wilcoxonMedianCI.getAchievedConfidence());
            double[] dArray2 = new double[]{51.0, 48.0, 52.0, 62.0, 64.0, 51.0, 55.0, 60.0};
            double[] dArray3 = new double[]{46.0, 45.0, 53.0, 48.0, 57.0, 55.0, 44.0, 50.0};
            PairedData pairedData = new PairedData(dArray2, dArray3);
            double[] dArray4 = new double[]{0.89, 0.9, 0.92, 0.94, 0.95, 0.96, 0.98, 0.99};
            System.out.println("************* Suntan lotions: n = 8 *******************");
            n2 = 0;
            while (n2 < dArray4.length) {
                System.out.println("Nominal confidence coeff. = " + dArray4[n2]);
                wilcoxonMedianCI = new WilcoxonMedianCI(pairedData, dArray4[n2], false);
                System.out.println("Exact CI=[" + wilcoxonMedianCI.getLowerLimit() + "," + wilcoxonMedianCI.getUpperLimit() + "]" + " d=" + wilcoxonMedianCI.getD() + " Achieved conf.=" + Maths.round(wilcoxonMedianCI.getAchievedConfidence(), 3));
                ++n2;
            }
            double[] dArray5 = new double[]{54.5, 70.6, 85.6, 78.2, 69.6, 73.1, 97.5, 85.6, 74.9, 86.8, 53.6, 89.4};
            double[] dArray6 = new double[]{55.5, 72.9, 84.8, 78.3, 71.6, 74.0, 97.2, 88.0, 74.4, 89.3, 52.3, 91.5};
            pairedData = new PairedData(dArray5, dArray6);
            System.out.println("*************** Weight change data: n = 12 ***************");
            n2 = 0;
            while (n2 < dArray4.length) {
                System.out.println("Nominal confidence coeff. = " + dArray4[n2]);
                wilcoxonMedianCI = new WilcoxonMedianCI(pairedData, dArray4[n2], false);
                System.out.println(" Exact CI=[" + wilcoxonMedianCI.getLowerLimit() + "," + wilcoxonMedianCI.getUpperLimit() + "]" + " d=" + wilcoxonMedianCI.getD() + " Achieved conf.=" + Maths.round(wilcoxonMedianCI.getAchievedConfidence(), 3));
                wilcoxonMedianCI = new WilcoxonMedianCI(pairedData, dArray4[n2], true);
                System.out.println("Approx CI=[" + wilcoxonMedianCI.getLowerLimit() + "," + wilcoxonMedianCI.getUpperLimit() + "]" + " d=" + wilcoxonMedianCI.getD() + " Achieved conf.=" + Maths.round(wilcoxonMedianCI.getAchievedConfidence(), 3));
                ++n2;
            }
        }
    }
}

