/*
 * Decompiled with CFR 0.152.
 */
package jsc.relatedsamples;

import jsc.datastructures.MatchedData;
import jsc.distributions.Normal;
import jsc.tests.SignificanceTest;

public class PageTest
implements SignificanceTest {
    int k;
    int n;
    double L = 0.0;
    private double SP;
    private final MatchedData ranks;

    public PageTest(MatchedData matchedData, String[] stringArray, double d) {
        this.n = matchedData.getBlockCount();
        this.k = matchedData.getTreatmentCount();
        if (this.k < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        if (this.n < 2) {
            throw new IllegalArgumentException("Less than two blocks.");
        }
        if (stringArray.length != this.k) {
            throw new IllegalArgumentException("Alternative array wrong length.");
        }
        this.ranks = matchedData.copy();
        this.ranks.rankByBlocks(d);
        double[][] dArray = this.ranks.getData();
        int n = 0;
        while (n < this.k) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.n) {
                d2 += dArray[n2][n];
                ++n2;
            }
            int n3 = matchedData.indexOfTreatment(stringArray[n]);
            if (n3 < 0) {
                throw new IllegalArgumentException("Invalid alternative treatment label.");
            }
            this.L += (double)(1 + n3) * d2;
            ++n;
        }
        this.SP = PageTest.approxSP(this.n, this.k, this.L);
    }

    public PageTest(MatchedData matchedData, String[] stringArray) {
        this(matchedData, stringArray, 0.0);
    }

    public static double approxSP(int n, int n2, double d) {
        if (n2 < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Less than two blocks.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid L value.");
        }
        double d2 = n2;
        double d3 = (d - 0.25 * (double)n * d2 * (d2 + 1.0) * (d2 + 1.0) - 0.5) / Math.sqrt((double)n * d2 * d2 * (d2 + 1.0) * (d2 * d2 - 1.0) / 144.0);
        return Normal.standardTailProb(d3, true);
    }

    public MatchedData getRanks() {
        return this.ranks;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.L;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"1", "2", "3", "4", "5"};
            String[] stringArray3 = new String[]{"A", "B", "C", "D", "E", "F"};
            double[][] dArrayArray = new double[][]{{62.59, 67.11, 73.02, 92.34, 83.48}, {55.75, 63.03, 63.93, 71.61, 93.73}, {65.88, 69.89, 82.53, 77.33, 84.82}, {66.13, 66.79, 85.37, 76.72, 98.88}, {65.73, 57.85, 63.08, 71.75, 87.04}, {78.36, 76.17, 82.97, 91.49, 89.61}};
            String[] stringArray4 = new String[]{"1", "2", "3", "4", "5"};
            MatchedData matchedData = new MatchedData((double[][])dArrayArray, stringArray3, stringArray2);
            int n = matchedData.getTreatmentCount();
            int n2 = matchedData.getBlockCount();
            System.out.println("n = " + n2 + " k = " + n);
            PageTest pageTest = new PageTest(matchedData, stringArray4);
            double d = pageTest.getTestStatistic();
            System.out.print(pageTest.getRanks().toString());
            System.out.println("L = " + d + " Approx SP = " + PageTest.approxSP(n2, n, d));
        }
    }
}

