/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.awt.Color;
import java.awt.Toolkit;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jsc.swt.text.MaxWidthFormat;
import jsc.swt.text.RealFormat;

public class RealField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private RealFormat realFormatter;
    private char decimalSeparator;
    JTextField field;

    public RealField(double d, int n, RealFormat realFormat) {
        super(n);
        this.realFormatter = realFormat;
        this.field = this;
        this.setBackground(Color.white);
        this.decimalSeparator = realFormat.getDecimalSeparator();
        this.setValue(d);
    }

    public RealField(double d, int n) {
        this(d, n, new MaxWidthFormat(7));
    }

    public double getValue() {
        try {
            return this.realFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
            return 0.0;
        }
    }

    public void setRealFormat(RealFormat realFormat) {
        this.realFormatter = realFormat;
    }

    public void setValue(double d) {
        this.setText(this.realFormatter.format(d));
    }

    protected Document createDefaultModel() {
        return new RealNumberDocument();
    }

    protected class RealNumberDocument
    extends PlainDocument {
        protected RealNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length) {
                String string2;
                char c = Character.toUpperCase(cArray[n3]);
                if (Character.isDigit(c)) {
                    cArray2[n2++] = c;
                } else if (c == RealField.this.decimalSeparator) {
                    string2 = RealField.this.field.getText();
                    if (string2.indexOf(RealField.this.decimalSeparator) < 0) {
                        cArray2[n2++] = c;
                    }
                } else if (c == 'E') {
                    string2 = RealField.this.field.getText().toUpperCase();
                    if (string2.indexOf(69) < 0) {
                        cArray2[n2++] = c;
                    }
                } else if (c == '-' && n == 0 && this.getText(0, 1).charAt(0) != '-') {
                    cArray2[n2++] = c;
                } else if (c == '-' && this.getText(n - 1, 1).toUpperCase().charAt(0) == 'E' && this.getText(n, 1).charAt(0) != '-') {
                    cArray2[n2++] = c;
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

