/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.datatable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsc.swt.datatable.DataWindow;
import jsc.swt.datatable.Table;
import jsc.swt.menu.DigitsMenu;

public class TableWindow
extends JInternalFrame {
    public JMenuBar menuBar;
    public Table table;
    CopyAction copyAction;
    JInternalFrame parent = this;
    DataWindow dataWindow;

    public TableWindow(String string, Table table, DataWindow dataWindow) {
        super(string, true, true, true, true);
        this.dataWindow = dataWindow;
        this.table = table;
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(true);
        ImageIcon imageIcon = null;
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource("images/table.gif");
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        this.setFrameIcon(imageIcon);
        this.setDefaultCloseOperation(2);
        this.addInternalFrameListener(new TableWindowListener());
        this.menuBar = new JMenuBar();
        this.menuBar.setBorder(new BevelBorder(0));
        JMenu jMenu = new JMenu("Edit");
        this.menuBar.add(jMenu);
        this.copyAction = new CopyAction("Copy", new ImageIcon("images/copy.gif"));
        SelectAllAction selectAllAction = new SelectAllAction("Select all");
        SelectNoneAction selectNoneAction = new SelectNoneAction("Select none");
        ResetColumnAction resetColumnAction = new ResetColumnAction("Reset column order");
        JMenuItem jMenuItem = jMenu.add(this.copyAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        jMenu.addSeparator();
        jMenuItem = jMenu.add(selectAllAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        jMenu.add(selectNoneAction);
        jMenu.addSeparator();
        jMenu.add(resetColumnAction);
        JMenu jMenu2 = new JMenu("Options");
        this.menuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Selection");
        jMenu2.add(jMenu3);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Columns");
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Rows");
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Any cells", true);
        jRadioButtonMenuItem.addActionListener(new SelectionColumnsListener());
        jRadioButtonMenuItem2.addActionListener(new SelectionRowsListener());
        jRadioButtonMenuItem3.addActionListener(new SelectionCellsListener());
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        jMenu3.add(jRadioButtonMenuItem);
        jMenu3.add(jRadioButtonMenuItem2);
        jMenu3.add(jRadioButtonMenuItem3);
        DigitsMenu digitsMenu = new DigitsMenu("Significant figures", 16, table.getSignificantDigits(), new DigitsListener());
        jMenu2.add(digitsMenu);
        this.copyAction.setEnabled(false);
        this.setJMenuBar(this.menuBar);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(1, 1));
        ListSelectionModel listSelectionModel = table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectionDebugger(listSelectionModel));
        JScrollPane jScrollPane = new JScrollPane(table);
        container.add((Component)jScrollPane, "Center");
    }

    class TableWindowListener
    extends InternalFrameAdapter {
        TableWindowListener() {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }
    }

    class SelectNoneAction
    extends AbstractAction {
        public SelectNoneAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableWindow.this.table.clearSelection();
        }
    }

    class SelectionRowsListener
    implements ActionListener {
        SelectionRowsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableWindow.this.table.setColumnSelectionAllowed(false);
            TableWindow.this.table.setRowSelectionAllowed(true);
            TableWindow.this.table.clearSelection();
        }
    }

    class SelectionDebugger
    implements ListSelectionListener {
        ListSelectionModel model;

        public SelectionDebugger(ListSelectionModel listSelectionModel) {
            this.model = listSelectionModel;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = !this.model.isSelectionEmpty();
            TableWindow.this.copyAction.setEnabled(bl);
        }
    }

    class SelectionColumnsListener
    implements ActionListener {
        SelectionColumnsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableWindow.this.table.setColumnSelectionAllowed(true);
            TableWindow.this.table.setRowSelectionAllowed(false);
            TableWindow.this.table.clearSelection();
        }
    }

    class SelectionCellsListener
    implements ActionListener {
        SelectionCellsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableWindow.this.table.setColumnSelectionAllowed(false);
            TableWindow.this.table.setRowSelectionAllowed(false);
            TableWindow.this.table.setCellSelectionEnabled(true);
            TableWindow.this.table.clearSelection();
        }
    }

    class SelectAllAction
    extends AbstractAction {
        public SelectAllAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableWindow.this.table.selectAll();
        }
    }

    class ResetColumnAction
    extends AbstractAction {
        public ResetColumnAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableWindow.this.table.resetColumnOrder();
        }
    }

    class DigitsListener
    implements ActionListener {
        DigitsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            TableWindow.this.table.setSignificantDigits(n);
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableWindow.this.table.copy();
            TableWindow.this.dataWindow.pasteAction.setEnabled(true);
            TableWindow.this.dataWindow.pasteClipboardAction.setEnabled(true);
        }
    }
}

