/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JFrame;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot.LinearAxisModel;
import jsc.swt.plot2d.Axis;
import jsc.swt.plot2d.HorizontalAxis;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotPanel;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.plot2d.PlotText;
import jsc.swt.plot2d.VerticalAxis;
import jsc.swt.virtualgraphics.VLine;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VRectangle;
import jsc.swt.virtualgraphics.VirtualTransform;
import jsc.util.Scale;

public class AxesPlot
extends PlotPanel
implements Cloneable {
    protected PlotText title;
    protected HorizontalAxis horizontalAxis;
    protected VerticalAxis verticalAxis;
    static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 0, 14);
    static final Color DEFAULT_TITLE_COLOUR = Color.black;
    private VRectangle plottingArea;
    private boolean paintXaxis = true;
    private boolean paintYaxis = true;
    private boolean clipping = false;

    public AxesPlot(AxisModel axisModel, AxisModel axisModel2, String string) {
        this(axisModel, axisModel2, Axis.DEFAULT_COLOUR, Axis.DEFAULT_STROKE, 5, Axis.DEFAULT_STROKE, Axis.DEFAULT_COLOUR, Axis.DEFAULT_AXIS_LABEL_FONT, Axis.DEFAULT_COLOUR, Axis.DEFAULT_TICK_LABEL_FONT, string, DEFAULT_TITLE_COLOUR, DEFAULT_TITLE_FONT);
    }

    public AxesPlot(AxisModel axisModel, AxisModel axisModel2, double d, double d2, String string) {
        this(axisModel, axisModel2, d, d2, Axis.DEFAULT_COLOUR, Axis.DEFAULT_STROKE, 5, Axis.DEFAULT_STROKE, Axis.DEFAULT_COLOUR, Axis.DEFAULT_AXIS_LABEL_FONT, Axis.DEFAULT_COLOUR, Axis.DEFAULT_TICK_LABEL_FONT, string, DEFAULT_TITLE_COLOUR, DEFAULT_TITLE_FONT);
    }

    public AxesPlot(HorizontalAxis horizontalAxis, VerticalAxis verticalAxis, String string) {
        this(horizontalAxis, verticalAxis, string, DEFAULT_TITLE_COLOUR, DEFAULT_TITLE_FONT);
    }

    public AxesPlot(HorizontalAxis horizontalAxis, VerticalAxis verticalAxis, String string, Color color, Font font) {
        super(new Dimension(300, 300));
        this.horizontalAxis = horizontalAxis;
        this.verticalAxis = verticalAxis;
        this.setMargins();
        this.setTitle(string, color, font);
    }

    public AxesPlot(AxisModel axisModel, AxisModel axisModel2, Color color, Stroke stroke, int n, Stroke stroke2, Color color2, Font font, Color color3, Font font2, String string, Color color4, Font font3) {
        this(axisModel, axisModel2, axisModel.getMin(), axisModel2.getMin(), color, stroke, n, stroke2, color2, font, color3, font2, string, color4, font3);
    }

    public AxesPlot(AxisModel axisModel, AxisModel axisModel2, double d, double d2, Color color, Stroke stroke, int n, Stroke stroke2, Color color2, Font font, Color color3, Font font2, String string, Color color4, Font font3) {
        this(new HorizontalAxis(axisModel, d2, color, stroke, n, stroke2, color2, font, color3, font2), new VerticalAxis(axisModel2, d, color, stroke, n, stroke2, color2, font, color3, font2), string, color4, font3);
    }

    public AxesPlot(String string) {
        this(new HorizontalAxis(), new VerticalAxis(), string);
    }

    public PlotObject addVerticalLine(double d, double d2, double d3, Color color, Stroke stroke) {
        PlotShape plotShape = new PlotShape(new VLine(d, d2, d, d3), color, stroke);
        this.addObject(plotShape);
        return plotShape;
    }

    public PlotObject addVerticalLine(double d, Color color, Stroke stroke) {
        return this.addVerticalLine(d, this.verticalAxis.getMin(), this.verticalAxis.getMax(), color, stroke);
    }

    public Object clone() {
        return this.copy();
    }

    public AxesPlot copy() {
        AxesPlot axesPlot = new AxesPlot(this.horizontalAxis, this.verticalAxis, this.title.getString(), this.title.getColour(), this.title.getFont());
        this.copyContents(axesPlot);
        axesPlot.paintXaxis = this.paintXaxis;
        axesPlot.paintYaxis = this.paintYaxis;
        axesPlot.clipping = this.clipping;
        axesPlot.hints = (RenderingHints)this.hints.clone();
        return axesPlot;
    }

    public PlotText getTitle() {
        return this.title;
    }

    public void setTitle(String string, Color color, Font font) {
        this.title = new PlotText(string, new VPoint(this.virtualSpace.x + 0.5 * this.virtualSpace.width, this.virtualSpace.y + this.virtualSpace.height), 2, 3, color, font);
    }

    public HorizontalAxis getHorizontalAxis() {
        return this.horizontalAxis;
    }

    public VerticalAxis getVerticalAxis() {
        return this.verticalAxis;
    }

    public boolean outsideAxes(VPoint vPoint) {
        return vPoint.x < this.horizontalAxis.getMin() || vPoint.x > this.horizontalAxis.getMax() || vPoint.y < this.verticalAxis.getMin() || vPoint.y > this.verticalAxis.getMax();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.clipping) {
            this.paintBackground(graphics);
            this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
            graphics2D.setClip(this.vt.createTransformedShape(this.plottingArea));
        }
        super.paintComponent(graphics);
        graphics2D.setClip(null);
        this.horizontalAxis.draw(graphics2D, this.vt);
        this.verticalAxis.draw(graphics2D, this.vt);
        this.title.draw(graphics2D, this.vt);
    }

    public void rescaleHorizontal(AxisModel axisModel) {
        this.horizontalAxis = this.horizontalAxis.setModel(axisModel);
        this.setMargins();
        this.repaint();
    }

    public void rescaleVertical(AxisModel axisModel) {
        this.verticalAxis = this.verticalAxis.setModel(axisModel);
        this.setMargins();
        this.repaint();
    }

    public void setClipping(boolean bl) {
        this.clipping = bl;
    }

    private void setMargins() {
        AxisModel axisModel = this.horizontalAxis.getModel();
        AxisModel axisModel2 = this.verticalAxis.getModel();
        this.plottingArea = new VRectangle(axisModel.getMin(), axisModel2.getMin(), axisModel.getLength(), axisModel2.getLength());
        this.virtualSpace = new VRectangle(axisModel.getMin() - 0.15 * axisModel.getLength(), axisModel2.getMin() - 0.15 * axisModel2.getLength(), axisModel.getLength() + 0.2 * axisModel.getLength(), axisModel2.getLength() + 0.25 * axisModel2.getLength());
        this.virtualSpace = new VRectangle(axisModel.getMin() - 0.15 * axisModel.getLength(), axisModel2.getMin() - 0.15 * axisModel2.getLength(), axisModel.getLength() + 0.2 * axisModel.getLength(), axisModel2.getLength() + 0.25 * axisModel2.getLength());
    }

    public void setPaintXaxis(boolean bl) {
        this.paintXaxis = bl;
    }

    public void setPaintYaxis(boolean bl) {
        this.paintYaxis = bl;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            JFrame jFrame = new JFrame("AxesPlot Test");
            LinearAxisModel linearAxisModel = new LinearAxisModel("X axis label", new Scale(-10.0, 10.0, 11, true), "##.#");
            LinearAxisModel linearAxisModel2 = new LinearAxisModel("Y axis label", new Scale(-30.0, 30.0, 11, true), "##.#");
            AxesPlot axesPlot = new AxesPlot(linearAxisModel, linearAxisModel2, "Title of plot");
            axesPlot.setZoomable(true);
            axesPlot.setFocusable(true);
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)axesPlot, "Center");
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.pack();
        }
    }
}

