/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Stroke;
import javax.swing.JFrame;
import jsc.ci.ConfidenceBand;
import jsc.distributions.Beta;
import jsc.distributions.Distribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.goodnessfit.SampleDistributionFunction;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot.LinearAxisModel;
import jsc.swt.plot.PlotFunction;
import jsc.swt.plot2d.DashStroke;
import jsc.swt.plot2d.FunctionPlot2D;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.virtualgraphics.Polyline;
import jsc.swt.virtualgraphics.VPoint;
import jsc.tests.H1;
import jsc.util.Scale;

public class CdfPlot
extends FunctionPlot2D
implements PlotFunction,
Cloneable {
    private Distribution F;

    public CdfPlot(String string, AxisModel axisModel) {
        super(axisModel, new LinearAxisModel("CDF", new Scale(0.0, 1.0, 11, false), "#.#"), string);
    }

    public CdfPlot(String string, AxisModel axisModel, AxisModel axisModel2) {
        super(axisModel, axisModel2, string);
    }

    public PlotObject addCdf(Distribution distribution, double d, double d2, int n, Color color, Stroke stroke) {
        this.F = distribution;
        return this.addFunction((PlotFunction)this, d, d2, n, color, stroke);
    }

    public PlotObject addCdf(Distribution distribution, int n, int n2, Color color, Stroke stroke) {
        int n3 = 1 + n2 - n;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int n4 = 0;
        while (n4 < n3) {
            dArray[n4] = n + n4;
            dArray2[n4] = distribution.cdf(dArray[n4]);
            ++n4;
        }
        return this.addStepFunction(dArray, dArray2, true, color, stroke);
    }

    public PlotObject[] addConfidenceBand(ConfidenceBand confidenceBand, Color color, Stroke stroke) {
        int n = confidenceBand.getN();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        PlotObject[] plotObjectArray = new PlotObject[2];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = confidenceBand.getX(n2);
            dArray2[n2] = confidenceBand.getLowerLimit(n2);
            dArray3[n2] = confidenceBand.getUpperLimit(n2);
            ++n2;
        }
        plotObjectArray[0] = this.addStepFunction(dArray, dArray2, false, color, stroke);
        plotObjectArray[1] = this.addStepFunction(dArray, dArray3, false, color, stroke);
        return plotObjectArray;
    }

    public PlotObject addSampleDistributionFunction(SampleDistributionFunction sampleDistributionFunction, Color color, Stroke stroke) {
        return this.addStepFunction(sampleDistributionFunction.getOrderedX(), sampleDistributionFunction.getOrderedS(), true, color, stroke);
    }

    public PlotObject addStepFunction(double[] dArray, double[] dArray2, boolean bl, Color color, Stroke stroke) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = n2 = bl ? 2 * n3 + 1 : 2 * n3 - 1;
        if (dArray2.length != n3) {
            throw new IllegalArgumentException("Arrays not equal length.");
        }
        VPoint[] vPointArray = new VPoint[n2];
        if (bl) {
            vPointArray[0] = new VPoint(dArray[0], 0.0);
            n = 0;
        } else {
            n = -1;
        }
        int n5 = 0;
        while (n5 < n3 - 1) {
            double d = dArray2[n5];
            vPointArray[++n] = new VPoint(dArray[n5], d);
            vPointArray[++n] = new VPoint(dArray[n5 + 1], d);
            ++n5;
        }
        vPointArray[++n] = new VPoint(dArray[n3 - 1], dArray2[n3 - 1]);
        if (bl) {
            vPointArray[++n] = new VPoint(this.horizontalAxis.getMax(), dArray2[n3 - 1]);
        }
        PlotShape plotShape = new PlotShape(new Polyline(vPointArray), color, stroke);
        this.addObject(plotShape);
        this.repaint();
        return plotShape;
    }

    public Object clone() {
        return super.clone();
    }

    public double getOrdinate(double d) {
        try {
            return this.F.cdf(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Double.NaN;
        }
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 5000;
            Beta beta = new Beta(0.5, 0.1);
            double d = 0.0;
            double d2 = 1.0;
            Scale scale = new Scale(0.0, 1.0, 11, false);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = beta.random();
                ++n2;
            }
            JFrame jFrame = new JFrame("CDF plot");
            LinearAxisModel linearAxisModel = new LinearAxisModel("x", scale, "##.#");
            CdfPlot cdfPlot = new CdfPlot("Cdf plot", linearAxisModel);
            cdfPlot.setPreferredSize(new Dimension(500, 400));
            cdfPlot.addSampleDistributionFunction(new SampleDistributionFunction(dArray), Color.black, new BasicStroke(1.0f));
            cdfPlot.addCdf(beta, d, d2, n, Color.red, new DashStroke(1.0f));
            cdfPlot.setZoomable(true);
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, beta, H1.NOT_EQUAL, false);
            double d3 = kolmogorovTest.xOfD();
            System.out.println("D = " + kolmogorovTest.getTestStatistic() + " x = " + d3 + " SP = " + kolmogorovTest.getSP());
            cdfPlot.addVerticalLine(d3, Color.blue, new DashStroke(1.0f));
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)cdfPlot, "Center");
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.pack();
        }
    }
}

