/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import jsc.descriptive.CategoricalTally;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot2d.LabelledXaxisPlot;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.virtualgraphics.LineBars;
import jsc.swt.virtualgraphics.RectangularBars;
import jsc.swt.virtualgraphics.VPoint;

public class VerticalBarChart
extends LabelledXaxisPlot {
    public static final int FREQUENCY = 0;
    public static final int PROPORTION = 1;
    public static final int PERCENTAGE = 2;
    int type = 0;

    public VerticalBarChart(String string, String string2, String[] stringArray, Color color, Font font, AxisModel axisModel) {
        super(string, string2, stringArray, color, font, axisModel);
        this.setAntialiasing(false);
    }

    public PlotObject addBars(CategoricalTally categoricalTally, float f, Color color, Paint paint, boolean bl) {
        int n = categoricalTally.getNumberOfBins();
        if (n != this.labelCount) {
            throw new IllegalArgumentException("Number of frequencies not equal to number of labels.");
        }
        VPoint[] vPointArray = new VPoint[n];
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            switch (this.type) {
                case 0: {
                    d = categoricalTally.getFrequency(n2);
                    break;
                }
                case 1: {
                    d = categoricalTally.getProportion(n2);
                    break;
                }
                case 2: {
                    d = categoricalTally.getPercentage(n2);
                }
            }
            vPointArray[n2] = new VPoint(n2 + 1, d);
            ++n2;
        }
        PlotShape plotShape = bl ? new PlotShape(new LineBars(vPointArray), color, new BasicStroke(f, 0, 1)) : new PlotShape((Shape)new RectangularBars(vPointArray, f), paint);
        this.addObject(plotShape);
        this.repaint();
        return plotShape;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid bar chart type.");
        }
        this.type = n;
    }
}

