/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.text;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;
import jsc.swt.text.RealFormat;

public class SigFigFormat
extends RealFormat {
    private static final double TOLERANCE = 8.0E-15;
    int n;
    double minDecimal;
    double maxDecimal;

    public SigFigFormat(int n) {
        this(n, Locale.getDefault());
    }

    public SigFigFormat(int n, Locale locale) {
        super(locale);
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.setSignificantDigits(n);
    }

    public String format(double d) {
        double d2;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        double d3 = Math.abs(d);
        if (d3 == 0.0) {
            return "0";
        }
        String string = this.scientificFormat.format(d);
        if (d3 < this.minDecimal || d3 >= this.maxDecimal) {
            return string;
        }
        if (d3 < 1.0 && d3 >= 0.1) {
            this.decimalFormat.setMaximumFractionDigits(this.n);
            return this.decimalFormat.format(d);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "E");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string3);
        try {
            Number number = this.localFormat.parse(string2);
            d2 = number.doubleValue();
        }
        catch (ParseException parseException) {
            d2 = Double.NaN;
        }
        int n2 = string2.length() - 1 - n;
        if (d < 0.0) {
            --n2;
        }
        this.decimalFormat.setMaximumFractionDigits(n2);
        return this.decimalFormat.format(d2 * Math.pow(10.0, n));
    }

    public int getSignificantDigits() {
        return this.n;
    }

    public Number parse(String string) throws ParseException {
        try {
            return this.decimalFormat.parse(string);
        }
        catch (ParseException parseException) {
            return this.scientificFormat.parse(string);
        }
    }

    public double round(double d) {
        String string = this.format(d);
        try {
            Number number = this.parse(string);
            return number.doubleValue();
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public void setSignificantDigits(int n) {
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Invalid number of significant figures.");
        }
        this.n = n;
        StringBuffer stringBuffer = new StringBuffer("0.");
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append('#');
            ++n2;
        }
        stringBuffer.append("E0");
        this.scientificFormat.applyPattern(stringBuffer.toString());
        this.minDecimal = Math.pow(10.0, -n);
        this.maxDecimal = Math.pow(10.0, n);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{1.0E-5, 1.2E-4, 0.00123, 0.01234, 0.12345, 0.123456, 1.23456, 12.3456, 12345.0, 123456.0, 100000.0, 0.0, 1.23456789E8, 0.123, 5.0E-4, 6.0E-4, 6.789E-4, 5.67E-4, 0.003454, 0.0034501, 0.00345005, 0.00345004, 0.0025000000000000005, 0.003000000000000001, 1.234567E-14};
            int n = 5;
            DecimalFormat decimalFormat = new DecimalFormat("##########.####################");
            SigFigFormat sigFigFormat = new SigFigFormat(n);
            Object var5_5 = null;
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = 0;
                while (n3 < 2) {
                    double d = n3 == 0 ? dArray[n2] : -dArray[n2];
                    String string = sigFigFormat.format(d);
                    System.out.println(decimalFormat.format(d) + " formatted to " + n + " sig.figs. is " + string);
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

