/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.text;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jsc.swt.text.IntegerFormat;
import jsc.swt.text.RealFormat;
import jsc.swt.text.SigFigFormat;

public class StatisticalDocument
extends DefaultStyledDocument {
    private IntegerFormat integerFormatter = new IntegerFormat();
    private RealFormat realFormatter = new SigFigFormat(5);
    public SimpleAttributeSet attributes = new SimpleAttributeSet();

    public void add(String string) {
        this.insertString(this.getLength(), string);
    }

    public void add(int n) {
        this.add(this.integerFormatter.format(n));
    }

    public void add(double d) {
        this.add(this.realFormatter.format(d));
    }

    public void add(Component component) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setComponent(simpleAttributeSet, component);
        this.insertString(this.getLength(), " ", simpleAttributeSet);
    }

    public void add(DefaultStyledDocument defaultStyledDocument) {
        int n = 0;
        while (n < defaultStyledDocument.getLength()) {
            try {
                String string = defaultStyledDocument.getText(n, 1);
                AttributeSet attributeSet = defaultStyledDocument.getCharacterElement(n).getAttributes();
                this.insertString(this.getLength(), string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void addBreak(int n) {
        this.add("\n");
        if (n > 0) {
            int n2 = this.getFontSize();
            this.setFontSize(n);
            this.add("\n");
            this.setFontSize(n2);
        }
    }

    public void addBullet() {
        this.bold("\u2022");
    }

    public void addDash() {
        this.bold("\u2013");
    }

    public void addDegrees() {
        String string = this.getFontFamily();
        int n = this.getFontSize();
        this.setFontFamily("Times");
        this.add("\u00b0");
        this.setFontFamily(string);
        this.setFontSize(n);
    }

    public void addDiv() {
        String string = this.getFontFamily();
        int n = this.getFontSize();
        this.setFontFamily("Times");
        this.add("\u00f7");
        this.setFontFamily(string);
        this.setFontSize(n);
    }

    public void addDivider() {
        this.add("\n");
        this.add(new Divider());
        this.add("\n");
    }

    public void addMinus() {
        String string = this.getFontFamily();
        int n = this.getFontSize();
        this.setFontFamily("Symbol");
        this.add("\u2212");
        this.setFontFamily(string);
        this.setFontSize(n);
    }

    public void addMult() {
        String string = this.getFontFamily();
        int n = this.getFontSize();
        this.setFontFamily("Times");
        this.add("\u00d7");
        this.setFontFamily(string);
        this.setFontSize(n);
    }

    public void addPM() {
        String string = this.getFontFamily();
        int n = this.getFontSize();
        this.setFontFamily("Times");
        this.add("\u00b1");
        this.setFontFamily(string);
        this.setFontSize(n);
    }

    public void addSqrt() {
        String string = this.getFontFamily();
        int n = this.getFontSize();
        this.setFontFamily("Symbol");
        this.add("\u221a");
        this.setFontFamily(string);
        this.setFontSize(n);
    }

    public void addSymbol(int n) {
        String string = this.getFontFamily();
        int n2 = this.getFontSize();
        this.setFontFamily("Symbol");
        this.add("" + (char)n);
        this.setFontFamily(string);
        this.setFontSize(n2);
    }

    public String getMatchString() {
        return this.getMatchString(true);
    }

    public String getMatchString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = 0;
        while (n < this.getLength()) {
            try {
                String string = this.getText(n, 1);
                if (!bl || !string.equals(" ")) {
                    AttributeSet attributeSet = this.getCharacterElement(n).getAttributes();
                    char c2 = '\u0000';
                    if (StyleConstants.isSuperscript(attributeSet)) {
                        c2 = '^';
                    } else if (StyleConstants.isSubscript(attributeSet)) {
                        c2 = '\u00ac';
                    }
                    if (c2 != '\u0000') {
                        if (c != c2) {
                            stringBuffer.append(c2);
                        }
                        c = c2;
                    } else if (c != '\u0000') {
                        c = '\u0000';
                        stringBuffer.append(':');
                    }
                    if (string.equals("^")) {
                        stringBuffer.append('^');
                    } else if (string.equals("\u00ac")) {
                        stringBuffer.append('\u00ac');
                    } else if (string.equals(":")) {
                        stringBuffer.append(':');
                    }
                    stringBuffer.append(string);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String greek(char c) {
        return "" + (char)(c - 65 + 913);
    }

    public void insertString(int n, String string, AttributeSet attributeSet) {
        try {
            super.insertString(n, string, attributeSet);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void insertString(int n, String string) {
        this.insertString(n, string, this.attributes);
    }

    public void reset() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {}
    }

    public void bold(String string) {
        this.bold();
        this.add(string);
        this.unbold();
    }

    public void bold() {
        StyleConstants.setBold(this.attributes, true);
    }

    public void unbold() {
        StyleConstants.setBold(this.attributes, false);
    }

    public void italic(String string) {
        this.italic();
        this.add(string);
        this.unitalic();
    }

    public void italic() {
        StyleConstants.setItalic(this.attributes, true);
    }

    public void unitalic() {
        StyleConstants.setItalic(this.attributes, false);
    }

    public void underline(String string) {
        this.underline();
        this.add(string);
        this.ununderline();
    }

    public void underline() {
        StyleConstants.setUnderline(this.attributes, true);
    }

    public void ununderline() {
        StyleConstants.setUnderline(this.attributes, false);
    }

    public void subscript(String string) {
        this.subscript();
        this.add(string);
        this.unsubscript();
    }

    public void subscript() {
        StyleConstants.setSubscript(this.attributes, true);
    }

    public void unsubscript() {
        StyleConstants.setSubscript(this.attributes, false);
    }

    public void superscript(String string) {
        this.superscript();
        this.add(string);
        this.unsuperscript();
    }

    public void superscript() {
        StyleConstants.setSuperscript(this.attributes, true);
    }

    public void unsuperscript() {
        StyleConstants.setSuperscript(this.attributes, false);
    }

    public void setAlignmentLeft() {
        this.setAlignment(0);
    }

    public void setAlignmentCentre() {
        this.setAlignment(1);
    }

    public void setAlignmentRight() {
        this.setAlignment(2);
    }

    public void setAlignment(int n) {
        this.setAlignment(n, 0, this.getLength());
    }

    public void setAlignment(int n, int n2, int n3) {
        StyleConstants.setAlignment(this.attributes, n);
        this.setParagraphAttributes(n2, n3, this.attributes, false);
    }

    public void setFontSize(int n) {
        StyleConstants.setFontSize(this.attributes, n);
    }

    public int getFontSize() {
        return StyleConstants.getFontSize(this.attributes);
    }

    public void setFontFamily(String string) {
        StyleConstants.setFontFamily(this.attributes, string);
    }

    public String getFontFamily() {
        return StyleConstants.getFontFamily(this.attributes);
    }

    public Font getFont() {
        return this.getFont(this.attributes);
    }

    public void setRealFormat(RealFormat realFormat) {
        this.realFormatter = realFormat;
    }

    class Divider
    extends Component {
        Divider() {
        }

        public void paint(Graphics graphics) {
            graphics.drawLine(0, 0, this.getWidth(), 0);
        }

        public Dimension getMaximumSize() {
            Dimension dimension = new Dimension(this.getSize());
            dimension.width = Short.MAX_VALUE;
            return dimension;
        }

        public Dimension getSize() {
            Dimension dimension = new Dimension(1, 1);
            this.setSize(dimension);
            return dimension;
        }

        public Dimension getMinimumSize() {
            return this.getSize();
        }

        public Dimension getPreferredSize() {
            return this.getSize();
        }
    }
}

