/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.PBN;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import simulator.RandomNumberGenerator;

public class ContextPBN
extends PBN {
    private int nb;
    private List<BitVector> BNindex;
    private List<int[]> BN;
    private double[] swi;
    private double p_swi;
    private boolean switchFirst = false;

    public ContextPBN(int n) {
        this.n = n;
        this.nf = new int[n];
        this.nv = new ArrayList();
        this.F = new ArrayList();
        this.varF = new ArrayList();
        this.BNindex = new ArrayList<BitVector>();
        this.BN = new ArrayList<int[]>();
        this.p_swi = 1.0E-4;
        this.perturbation = 0.0;
        this.npNode = new ArrayList();
        this.npNode.add(n);
    }

    public void generateRandomContextPBN(int[] nf, List<Integer> nv) throws Exception {
        int j;
        this.setNf(nf);
        this.setNv(nv);
        int cumulativeNf = nv.size();
        RandomNumberGenerator rng = new RandomNumberGenerator();
        double ran = rng.randomUnifDouble();
        int i = 0;
        while (i < cumulativeNf) {
            BitSet elementVarF = new BitSet();
            Integer[] varIndex = rng.randomInt(nv.get(i), 0, this.n - 1);
            int j2 = 0;
            while (j2 < varIndex.length) {
                elementVarF.set(varIndex[j2]);
                ++j2;
            }
            this.varF.add(elementVarF);
            int nv_tmp = (int)Math.pow(2.0, nv.get(i).intValue());
            boolean[] elementF = new boolean[nv_tmp];
            j2 = 0;
            while (j2 < nv_tmp) {
                elementF[j2] = rng.randomUnifDouble() > ran;
                ++j2;
            }
            this.F.add(elementF);
            ++i;
        }
        i = 0;
        int max = 0;
        i = 0;
        while (i < nf.length) {
            if (max < nf[i]) {
                max = nf[i];
            }
            ++i;
        }
        this.nb = rng.randomUnifInt(10) + 1;
        if (this.nb < max) {
            this.nb = max;
        } else {
            i = 0;
            int multi = 1;
            while (i < nf.length && multi < this.nb) {
                multi *= nf[i];
                ++i;
            }
            if (this.nb > multi) {
                this.nb = multi;
            }
        }
        int[][] elementBN = new int[this.nb][this.n];
        i = 0;
        while (i < this.n) {
            Integer[] bridge = rng.randomInt(nf[i], 0, nf[i] - 1);
            j = 0;
            while (j < nf[i]) {
                elementBN[j][i] = bridge[j];
                ++j;
            }
            j = nf[i];
            while (j < this.nb) {
                elementBN[j][i] = rng.randomUnifInt(nf[i]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nb) {
            j = 0;
            while (j < i) {
                if (Arrays.equals(elementBN[i], elementBN[j])) {
                    int k = rng.randomUnifInt(this.n);
                    Integer[] bridge = rng.randomInt(nf[k], 0, nf[k] - 1);
                    j = 0;
                    while (j < nf[k]) {
                        elementBN[j][k] = bridge[j];
                        ++j;
                    }
                    j = nf[k];
                    while (j < this.nb) {
                        elementBN[j][k] = rng.randomUnifInt(nf[k]);
                        ++j;
                    }
                    i = 0;
                    j = 0;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nb) {
            this.BN.add(elementBN[i]);
            ++i;
        }
        i = 0;
        while (i < this.nb) {
            BitVector elementBNindex = new BitVector(this.n);
            elementBNindex.not();
            this.BNindex.add(elementBNindex);
            ++i;
        }
        double[] swi = new double[this.nb];
        double tmp = 0.0;
        i = 0;
        while (i < this.nb) {
            swi[i] = rng.randomUnifDouble();
            tmp += swi[i];
            ++i;
        }
        i = 0;
        while (i < this.nb) {
            swi[i] = swi[i] / tmp;
            ++i;
        }
        this.p_swi = rng.randomUnifDouble() / 10.0;
        this.setSwi(swi);
        System.out.println("One " + this.n + " nodes PBN is generated. Its density is " + this.density() + ".");
    }

    public double density() throws Exception {
        this.buildCumNf();
        double total = 0.0;
        int i = 0;
        while (i < this.cumNf[this.n]) {
            total += (double)((Integer)this.nv.get(i)).intValue();
            ++i;
        }
        return total / (double)this.n;
    }

    public void setBNindex(List<BitVector> BNindex) {
        this.BNindex = BNindex;
    }

    public void setBN(List<int[]> BN) {
        this.BN = BN;
    }

    public void setSwi(double[] swi) {
        System.out.println("Please make sure the switch probability value is set before the distribution is set.");
        this.nb = swi.length;
        this.swi = new double[this.nb + 1];
        this.swi[0] = 1.0 - this.p_swi;
        int i = 0;
        while (i < swi.length) {
            this.swi[i + 1] = this.p_swi * swi[i];
            ++i;
        }
    }

    public void setP_swi(double p_swi) {
        this.p_swi = p_swi;
    }

    public List<BitVector> getBNindex() {
        return this.BNindex;
    }

    public List<int[]> getBN() {
        return this.BN;
    }

    public double[] getSwi() {
        return this.swi;
    }

    public double getP_swi() {
        return this.p_swi;
    }

    public void setSwitchFirst(boolean switchFirst) {
        this.switchFirst = switchFirst;
    }

    public boolean getSwitchFirst() {
        return this.switchFirst;
    }

    @Override
    public boolean getNextNodeValue(int indexVarF, StateBit currentState) {
        BitSet elementVarF = (BitSet)this.varF.get(indexVarF);
        boolean[] elementF = (boolean[])this.F.get(indexVarF);
        StateBit copyCurrentState = (StateBit)currentState.clone();
        copyCurrentState.and(elementVarF);
        BitVector bitVector = new BitVector(elementVarF.cardinality());
        int index = -1;
        int count = 0;
        while ((index = elementVarF.nextSetBit(index + 1)) != -1) {
            bitVector.put(count, copyCurrentState.get(index));
            ++count;
        }
        return elementF[(int)bitVector.getLongFromTo(0, bitVector.size() - 1)];
    }

    public void setNb(int nb) {
        this.nb = nb;
    }

    public int getNb() {
        return this.nb;
    }

    @Override
    public int getStateLength() {
        return this.getN() + (int)Math.ceil(Math.log(this.nb) / Math.log(2.0));
    }
}

