/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.StateBit;
import java.util.BitSet;
import java.util.List;

public abstract class PBN {
    protected int n;
    protected int[] nf;
    protected List<Integer> nv;
    protected List<boolean[]> F;
    protected List<BitSet> varF;
    protected double perturbation;
    protected int[] cumNf;
    protected List<Integer> npNode;

    public int[] buildCumNf() throws Exception {
        if (this.nf == null) {
            throw new Exception("Cannot build cumNf before nf is initilised.");
        }
        if (this.cumNf != null) {
            return this.cumNf;
        }
        this.cumNf = new int[this.n + 1];
        this.cumNf[0] = 0;
        int i = 0;
        while (i < this.nf.length) {
            this.cumNf[i + 1] = this.cumNf[i] + this.nf[i];
            ++i;
        }
        return this.cumNf;
    }

    public void setNf(int[] nf) {
        this.nf = nf;
    }

    public void setNv(List<Integer> nv) {
        this.nv = nv;
    }

    public void setF(List<boolean[]> F) {
        this.F = F;
    }

    public void setvarF(List<BitSet> varF) {
        this.varF = varF;
    }

    public void setPerturbation(double perturbation) {
        this.perturbation = perturbation;
    }

    public int getN() {
        return this.n;
    }

    public int[] getNf() {
        return this.nf;
    }

    public List<Integer> getNv() {
        return this.nv;
    }

    public List<boolean[]> getF() {
        return this.F;
    }

    public List<BitSet> getVarF() {
        return this.varF;
    }

    public double getPerturbation() {
        return this.perturbation;
    }

    public void setNpNode(List<Integer> npNode) {
        if (this.npNode == npNode) {
            System.out.println("The given npNode is the same as the one in the PBN.");
        } else {
            this.npNode.clear();
            this.npNode.addAll(npNode);
            this.npNode.add(this.n);
        }
    }

    public List<Integer> npNode() {
        return this.npNode;
    }

    public abstract boolean getNextNodeValue(int var1, StateBit var2);

    public abstract int getStateLength();
}

