/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.StateBit;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationMethod;

public class Gelman
extends SimulationMethod {
    private BitSet trajectory;
    private List<BitSet> trajectories;
    private BitSetPBN pbn;
    private String outputName;
    private int m;
    private int n;
    private int twon;
    private int count;
    private int traIndex;
    private int previousIndex;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private double precision = 0.01;
    private double confidence = 0.95;

    public Gelman(BitSetPBN pbn) {
        this.pbn = pbn;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
    }

    private void initialise() {
        this.m = 100;
        this.n = 10;
        this.twon = 2 * this.n;
    }

    public void setParameters(double precision, double confidence) {
        this.precision = precision;
        this.confidence = confidence;
    }

    public double[] run() throws Exception {
        int index2;
        int bridge;
        int index1;
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        long time = System.currentTimeMillis();
        this.initialise();
        StateBit[] initialState = new StateBit[this.m];
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        double[] meansquare = new double[this.m];
        int statesize = this.pbn.getN();
        double mean_meansquare = 0.0;
        boolean done = false;
        double[] result = new double[3];
        Covariance covariance = new Covariance();
        BitSetPBNSimulationEngine engine = new BitSetPBNSimulationEngine(this.pbn, this);
        int i = 0;
        while (i < this.m) {
            initialState[i] = new StateBit(statesize);
            initialState[i].putLongFromTo(i, 0, statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<BitSet>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new BitSet(this.twon);
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = this.n;
        this.previousIndex = 0;
        while (!done) {
            i = 0;
            while (i < this.m) {
                this.count = i;
                this.traIndex = this.previousIndex;
                initialState[i] = (StateBit)engine.simulate(extension * 2, (Object)initialState[i]);
                ++i;
            }
            this.previousIndex = this.traIndex;
            double within = 0.0;
            double grandmean = 0.0;
            mean_meansquare = 0.0;
            double[] values = new double[this.n];
            i = 0;
            while (i < this.m) {
                this.trajectories.get(i).clear(0, this.twon - this.n);
                mean[i] = (double)this.trajectories.get(i).cardinality() / (double)this.n;
                meansquare[i] = Math.pow(mean[i], 2.0);
                int j = this.n;
                while (j < this.twon) {
                    values[j - this.n] = this.trajectories.get(i).get(j) ? 1.0 : 0.0;
                    ++j;
                }
                sj[i] = StatUtils.variance((double[])values);
                ++i;
            }
            within = StatUtils.mean((double[])sj);
            grandmean = StatUtils.mean((double[])mean);
            mean_meansquare = StatUtils.mean((double[])meansquare);
            double between = (double)this.n * StatUtils.variance((double[])mean);
            double varianceW = StatUtils.variance((double[])sj);
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = covariance.covariance(sj, meansquare);
            double covwx = covariance.covariance(sj, mean);
            double covwb = (double)(this.n / this.m) * (covwxsquare - 2.0 * grandmean * covwx);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double varianceV = (Math.pow(this.n - 1, 2.0) * (varianceW /= (double)this.m) + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            if (Math.abs(1.0 - psrf) > 0.001 || varianceV == 0.0) {
                done = false;
                extension = this.n;
                this.n += extension;
                this.twon = this.n * 2;
                continue;
            }
            done = true;
        }
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        int[][] transitionsLast = new int[2][2];
        int meta1 = 0;
        int meta2 = 0;
        int i2 = 0;
        while (i2 < this.m) {
            if (this.trajectories.get(i2).get(this.n)) {
                ++meta1;
                index1 = 1;
            } else {
                ++meta2;
                index1 = 0;
            }
            int j = 1;
            while (j < this.n) {
                bridge = index1;
                if (this.trajectories.get(i2).get(this.n + j)) {
                    ++meta1;
                    index1 = 1;
                    index2 = 1;
                    if (this.traIndex != 0) {
                        int[] nArray = transitionsLast[bridge];
                        int n = index2;
                        nArray[n] = nArray[n] + 1;
                    }
                } else {
                    ++meta2;
                    index1 = 0;
                    index2 = 0;
                    if (this.traIndex != 0) {
                        int[] nArray = transitionsLast[bridge];
                        int n = index2;
                        nArray[n] = nArray[n] + 1;
                    }
                }
                ++j;
            }
            ++i2;
        }
        double beta = transitionsLast[0][0] + transitionsLast[0][1] == 0 ? 0.0 : (double)transitionsLast[0][1] / (double)(transitionsLast[0][0] + transitionsLast[0][1]);
        double alpha = transitionsLast[1][0] + transitionsLast[1][1] == 0 ? 0.0 : (double)transitionsLast[1][0] / (double)(transitionsLast[1][0] + transitionsLast[1][1]);
        int N = (int)Math.ceil(alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
        int current = 0;
        current = this.twon - 1;
        this.count = 0;
        boolean round = false;
        while (N > meta1 + meta2) {
            initialState[0] = (StateBit)engine.simulate(N - meta1 - meta2, (Object)initialState[0]);
            if (this.trajectories.get(0).get(current)) {
                ++meta1;
                index1 = 1;
            } else {
                ++meta2;
                index1 = 0;
            }
            int j = 1;
            while (j < N - meta1 - meta2) {
                bridge = index1;
                if (this.trajectories.get(0).get(current + j)) {
                    ++meta1;
                    index1 = 1;
                    index2 = 1;
                    if (this.traIndex != 0) {
                        int[] nArray = transitionsLast[bridge];
                        int n = index2;
                        nArray[n] = nArray[n] + 1;
                    }
                } else {
                    ++meta2;
                    index1 = 0;
                    index2 = 0;
                    if (this.traIndex != 0) {
                        int[] nArray = transitionsLast[bridge];
                        int n = index2;
                        nArray[n] = nArray[n] + 1;
                    }
                }
                ++j;
            }
            current = current + N - meta1 - meta2;
            beta = transitionsLast[0][0] + transitionsLast[0][1] == 0 ? 0.0 : (double)transitionsLast[0][1] / (double)(transitionsLast[0][0] + transitionsLast[0][1]);
            alpha = transitionsLast[1][0] + transitionsLast[1][1] == 0 ? 0.0 : (double)transitionsLast[1][0] / (double)(transitionsLast[1][0] + transitionsLast[1][1]);
            N = (int)Math.ceil(alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
        }
        result[0] = (double)meta1 / (double)(meta1 + meta2);
        result[1] = meta1 + meta2 + this.m * this.n;
        result[2] = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        return result;
    }

    public void runPlot() throws Exception {
        this.initialise();
        StateBit[] initialState = new StateBit[this.m];
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        int statesize = this.pbn.getN();
        double mean_meansquare = 0.0;
        boolean done = false;
        BitSetPBNSimulationEngine engine = new BitSetPBNSimulationEngine(this.pbn, this);
        Random ran = RandomProvider.getInstance().getRandom();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            initialState[i] = new StateBit(statesize);
            initialState[i].putLongFromTo(statespace * (long)i, 0, statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<BitSet>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new BitSet(this.twon);
            this.trajectories.add(this.trajectory);
            ++i;
        }
        this.previousIndex = 0;
        int extension = this.n;
        int k = 1;
        while (k < 501) {
            int i2 = 0;
            while (i2 < this.m) {
                this.count = i2;
                this.traIndex = this.previousIndex;
                initialState[i2] = (StateBit)engine.simulate(extension * 2, (Object)initialState[i2]);
                ++i2;
            }
            this.previousIndex = this.traIndex;
            double within = 0.0;
            double grandmean = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                mean[i2] = (double)this.trajectories.get(i2).cardinality() / (double)this.n;
                mean_meansquare += mean[i2] * mean[i2];
                grandmean += mean[i2];
                sj[i2] = 0.0;
                int j = this.n;
                while (j < this.twon) {
                    boolean value = this.trajectories.get(i2).get(j);
                    int n = i2;
                    sj[n] = sj[n] + Math.pow((double)value - mean[i2], 2.0);
                    ++j;
                }
                sj[i2] = sj[i2] / (double)(this.n - 1);
                within += sj[i2];
                ++i2;
            }
            within /= (double)this.m;
            grandmean /= (double)this.m;
            mean_meansquare /= (double)this.m;
            double between = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                between += Math.pow(grandmean - mean[i2], 2.0);
                ++i2;
            }
            between = between * (double)this.n / (double)(this.m - 1);
            double varianceW = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                varianceW += Math.pow(sj[i2] - within, 2.0);
                ++i2;
            }
            varianceW /= (double)(this.m - 1);
            varianceW /= (double)this.m;
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = 0.0;
            double covwx = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                covwxsquare += (sj[i2] - within) * (mean[i2] * mean[i2] - mean_meansquare);
                covwx += (sj[i2] - within) * (mean[i2] - grandmean);
                ++i2;
            }
            double covwb = (double)(this.n / this.m) * ((covwxsquare /= (double)(this.m - 1)) - 2.0 * grandmean * (covwx /= (double)(this.m - 1)));
            double varianceV = (Math.pow(this.n - 1, 2.0) * varianceW + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            System.out.println("m=" + this.m + ", n=" + this.n + ", psrf=" + psrf);
            extension = 5;
            this.n += extension;
            this.twon = this.n * 2;
            ++k;
        }
    }

    @Override
    public void updateTransition(StateBit st, int para) {
        this.trajectories.get(this.count).set(this.traIndex, this.evaluateState(st));
        ++this.traIndex;
    }

    public boolean evaluateState(StateBit st) {
        int i;
        if (this.positiveIndex != null) {
            i = 0;
            while (i < this.positiveIndex.size()) {
                if (!st.get(this.positiveIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.negativeIndex != null) {
            i = 0;
            while (i < this.negativeIndex.size()) {
                if (st.get(this.negativeIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    public void setExpressions(String property) throws IOException {
        int value;
        String line = "";
        InputStreamReader reader = new InputStreamReader(new FileInputStream(property));
        BufferedReader br = new BufferedReader(reader);
        line = br.readLine();
        StringTokenizer token = new StringTokenizer(line, " ");
        this.positiveIndex = new ArrayList<Integer>();
        this.negativeIndex = new ArrayList<Integer>();
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.positiveIndex.add(value);
        }
        line = br.readLine();
        token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.negativeIndex.add(value);
        }
        br.close();
        reader.close();
    }

    public static void main(String[] args) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN("PBN_8.txt");
        String property = "model/property_2.txt";
        double precision = 1.0E-5;
        boolean in = false;
        Gelman gelman = new Gelman(pbn);
        gelman.setExpressions("model/property_2.txt");
        System.out.println(gelman.run()[0]);
    }
}

