/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.PBN;
import cern.colt.bitvector.BitVector;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class IterationMethod {
    protected PBN pbn;
    protected double[] pai;
    protected double precision = 1.0E-5;
    protected boolean done = false;
    protected long maxIteration = 10000L;
    protected List<Integer> stateSet;

    public IterationMethod(PBN pbn) {
        this.pbn = pbn;
        this.pai = new double[(int)Math.pow(2.0, pbn.getN())];
    }

    public void initialize() {
        double value = 1.0 / (double)this.pai.length;
        int i = 0;
        while (i < this.pai.length) {
            this.pai[i] = value;
            ++i;
        }
    }

    protected void testDone(double[] paiCopy) {
        int i = 0;
        while (i < this.pai.length) {
            if (Math.abs(this.pai[i] - paiCopy[i]) / paiCopy[i] > this.precision) {
                return;
            }
            ++i;
        }
        this.done = true;
    }

    protected void normalize() {
        double sum = 0.0;
        int i = 0;
        while (i < this.pai.length) {
            sum += this.pai[i];
            ++i;
        }
        i = 0;
        while (i < this.pai.length) {
            this.pai[i] = this.pai[i] / sum;
            ++i;
        }
    }

    public void setProperty(String property) throws IOException {
        int value;
        if (property == null) {
            return;
        }
        String line = "";
        BitVector interest = new BitVector(this.pbn.getN());
        BitVector valueSet = new BitVector(this.pbn.getN());
        InputStreamReader reader = new InputStreamReader(new FileInputStream(property));
        BufferedReader br = new BufferedReader(reader);
        line = br.readLine();
        StringTokenizer token = new StringTokenizer(line, " ");
        ArrayList<Integer> positiveIndex = new ArrayList<Integer>();
        ArrayList<Integer> negativeIndex = new ArrayList<Integer>();
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            positiveIndex.add(value);
            interest.set(value);
            valueSet.set(value);
        }
        line = br.readLine();
        token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            negativeIndex.add(value);
            interest.set(value);
        }
        br.close();
        reader.close();
        this.stateSet = new ArrayList<Integer>();
        this.addState(interest, valueSet, 0);
    }

    private void addState(BitVector interest, BitVector valueSet, int n) {
        if (n == this.pbn.getN() - 1) {
            this.stateSet.add((int)valueSet.getLongFromTo(0, this.pbn.getN() - 1));
            if (!interest.get(n)) {
                valueSet.set(n);
                this.stateSet.add((int)valueSet.getLongFromTo(0, this.pbn.getN() - 1));
                valueSet.put(n, false);
            }
        } else if (n < this.pbn.getN() - 1) {
            while (n < this.pbn.getN() - 1 && interest.get(n)) {
                ++n;
            }
            if (n < this.pbn.getN() - 1) {
                this.addState(interest, valueSet, n + 1);
                valueSet.set(n);
                this.addState(interest, valueSet, n + 1);
                valueSet.put(n, false);
            } else {
                this.stateSet.add((int)valueSet.getLongFromTo(0, this.pbn.getN() - 1));
                if (!interest.get(n)) {
                    valueSet.set(n);
                    this.stateSet.add((int)valueSet.getLongFromTo(0, this.pbn.getN() - 1));
                    valueSet.put(n, false);
                }
            }
        }
    }

    public void setPrecsion(double precision) {
        this.precision = precision;
    }

    public void setMaxIteration(long maxIteration) {
        this.maxIteration = maxIteration;
    }

    public abstract double[] run() throws Exception;

    public abstract void updatePai() throws Exception;
}

