/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.StateBit;
import functionLib.RandomProvider;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import simulator.AliasMethod;

public class PerfectSimulationWalkerBitSet {
    private List<StateBit> stateList;
    private BitSetPBN pbn;
    PrintWriter pw;
    private int sampleSize;
    private long stateA;
    private long stateB;
    private List<Property> exps;
    private int dimension;
    private List<Integer> non_zero_num_row;
    private List<AliasMethod> aliasMethodList;
    private StateBit[] state;
    private StateBit[] stateCopy;
    private boolean aliasGenerated;
    private boolean initialized;
    protected List<StateBit> metaA;
    protected List<StateBit> metaB;
    private Random rng;

    public static final PerfectSimulationWalkerBitSet getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private PerfectSimulationWalkerBitSet() {
        this.stateA = 0L;
        this.stateB = 0L;
        this.metaA = new ArrayList<StateBit>();
        this.metaB = new ArrayList<StateBit>();
        this.exps = new ArrayList<Property>();
        this.non_zero_num_row = new ArrayList<Integer>();
        this.aliasMethodList = new ArrayList<AliasMethod>();
        this.aliasGenerated = false;
        this.initialized = false;
        this.rng = RandomProvider.getInstance().getRandom();
    }

    private PerfectSimulationWalkerBitSet(BitSetPBN pbn, String outputSimulation) throws FileNotFoundException {
        this.pbn = pbn;
        this.stateA = 0L;
        this.stateB = 0L;
        this.metaA = new ArrayList<StateBit>();
        this.metaB = new ArrayList<StateBit>();
        this.exps = new ArrayList<Property>();
        this.pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputSimulation)), true);
        this.non_zero_num_row = new ArrayList<Integer>();
        this.aliasMethodList = new ArrayList<AliasMethod>();
        this.aliasGenerated = false;
        this.initialized = false;
        this.rng = RandomProvider.getInstance().getRandom();
    }

    public void setIO(BitSetPBN pbn, String outputSimulation) throws FileNotFoundException {
        this.pbn = pbn;
        this.pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputSimulation)), true);
    }

    public void reInitialise() {
        this.initialized = false;
        this.aliasGenerated = false;
        this.exps.clear();
        this.metaA.clear();
        this.metaB.clear();
        this.state = null;
        this.stateCopy = null;
        System.gc();
    }

    public void initialise() throws Exception {
        if (this.initialized) {
            return;
        }
        this.pw.println("Start initialising states...");
        long time = System.currentTimeMillis();
        int n = this.pbn.getN();
        if (n > 31) {
            throw new Exception("States number exceed the max value: 2147483647");
        }
        this.stateList = new ArrayList<StateBit>();
        this.dimension = (int)Math.pow(2.0, n);
        int i = 0;
        while (i < this.dimension) {
            StateBit stateListElement = new StateBit(n);
            stateListElement.putLongFromTo(i, 0, n - 1);
            this.stateList.add(stateListElement);
            ++i;
        }
        this.pw.println("Total states generated: " + this.stateList.size() + ". Time cost: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
        this.initialized = true;
    }

    private void generateAlias() throws Exception {
        if (this.aliasGenerated) {
            return;
        }
        this.pw.println("\nStart generating alias table...");
        long time = System.currentTimeMillis();
        this.non_zero_num_row.add(0);
        int nonZeroRow = 0;
        int[] y = new int[this.dimension];
        int i = 0;
        while (i < this.dimension) {
            y[i] = i;
            ++i;
        }
        BitSetPBNIO io = new BitSetPBNIO(this.pbn);
        i = 0;
        while (i < this.stateList.size()) {
            double[] prob = io.getTransitionProbability(this.stateList.get(i));
            AliasMethod aliasmethod = new AliasMethod(prob, y);
            this.aliasMethodList.add(aliasmethod);
            ++i;
        }
        this.non_zero_num_row.add(nonZeroRow);
        this.aliasGenerated = true;
        this.pw.println("Finish generating alias table, time cost: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
    }

    public void setSampleSize(double delta, double epsilon) {
        delta = 1.0 - delta;
        this.sampleSize = (int)(Math.log(2.0 / delta) / (2.0 * epsilon * epsilon));
    }

    public void updateTransitionWalker(String re) {
        String[] tmp = re.split(" ");
        String stateString = tmp[1];
        StateBit st = this.stateList.get(Integer.parseInt(stateString));
        if (this.evaluateState(st)) {
            ++this.stateA;
        } else {
            ++this.stateB;
        }
    }

    public boolean evaluateState(StateBit st) {
        StateBit copySt = (StateBit)st.clone();
        for (StateBit state : this.metaA) {
            copySt.xor(state);
            if (copySt.cardinality() == 0) {
                return true;
            }
            copySt.xor(state);
        }
        for (StateBit state : this.metaB) {
            copySt.xor(state);
            if (copySt.cardinality() == 0) {
                return false;
            }
            copySt.xor(state);
        }
        for (Property exp : this.exps) {
            try {
                if (copySt.get(exp.nodeIndex) == exp.nodeValue) continue;
                this.metaB.add(copySt);
                return false;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        this.metaA.add(copySt);
        return true;
    }

    public void setProperty(String property) throws IOException {
        Property pro;
        int index;
        String line = "";
        InputStreamReader reader = new InputStreamReader(new FileInputStream(property));
        BufferedReader br = new BufferedReader(reader);
        line = br.readLine();
        StringTokenizer token = new StringTokenizer(line, " ");
        boolean value = true;
        while (token.hasMoreTokens()) {
            index = Integer.parseInt(token.nextToken());
            if (index < 0) continue;
            pro = new Property(index, value);
            this.exps.add(pro);
        }
        line = br.readLine();
        token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            index = Integer.parseInt(token.nextToken());
            if (index < 0) continue;
            pro = new Property(index, value);
            this.exps.add(pro);
        }
        br.close();
        reader.close();
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public double[] runWalker(String fileProperty) throws Exception {
        return this.runWalker(fileProperty, this.sampleSize, false);
    }

    public double[] runWalker(String fileProperty, boolean reInitialise) throws Exception {
        return this.runWalker(fileProperty, this.sampleSize, reInitialise);
    }

    public double[] runWalker(String fileProperty, int sampleSize) throws Exception {
        return this.runWalker(fileProperty, sampleSize, false);
    }

    public double[] runWalker(String fileProperty, int sampleSize, boolean reInitialise) throws Exception {
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        int coupling = 0;
        if (reInitialise) {
            this.reInitialise();
        }
        this.setProperty(fileProperty);
        this.pw.println();
        this.pw.print("Properties to check: S=?[ ");
        int i = 0;
        while (i < this.exps.size()) {
            this.pw.print("Node " + this.exps.get((int)i).nodeIndex + "=" + this.exps.get((int)i).nodeValue + " ");
            ++i;
        }
        this.pw.println("]");
        long time = System.currentTimeMillis();
        this.initialise();
        this.generateAlias();
        this.stateA = 0L;
        this.stateB = 0L;
        i = 0;
        while (i < sampleSize) {
            String re = this.generateCouplingPath();
            this.updateTransitionWalker(re);
            String[] split = re.split(" ");
            coupling += Integer.parseInt(split[0]);
            ++i;
        }
        System.out.println();
        this.pw.println("Average coupling steps: " + (double)coupling / (double)sampleSize);
        time = System.currentTimeMillis() - time;
        this.pw.println("generating " + sampleSize + " samples cost " + (double)time / 1000.0 + "s");
        double distribution = this.calculateDistribution();
        this.pw.println("Distribution is: " + distribution);
        double[] result = new double[]{distribution, (double)coupling / (double)sampleSize, (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9, (double)time / 1000.0};
        return result;
    }

    private String generateCouplingPath() throws Exception {
        this.initiliseWalkerStates();
        int loop = 0;
        while (!this.testDone()) {
            double first_random = this.rng.nextDouble();
            double second_random = this.rng.nextDouble();
            ++loop;
            int i = 0;
            while (i < this.dimension) {
                this.state[i].xor(this.state[i]);
                this.state[i].xor(this.stateCopy[this.aliasMethodList.get(i).next(first_random, second_random)]);
                ++i;
            }
            i = 0;
            while (i < this.stateCopy.length) {
                this.stateCopy[i].xor(this.stateCopy[i]);
                this.stateCopy[i].xor(this.state[i]);
                ++i;
            }
        }
        return String.valueOf(loop) + " " + this.state[0].getLongFromTo(0, this.pbn.getN() - 1);
    }

    private boolean testDone() {
        int i = 1;
        while (i < this.state.length) {
            this.state[0].xor(this.state[i]);
            if (this.state[0].cardinality() != 0) {
                this.state[0].xor(this.state[i]);
                return false;
            }
            this.state[0].xor(this.state[i]);
            ++i;
        }
        return true;
    }

    private void initiliseWalkerStates() throws IOException {
        int i;
        if (this.state == null) {
            this.state = new StateBit[this.dimension];
            this.stateCopy = new StateBit[this.dimension];
            i = 0;
            while (i < this.dimension) {
                this.state[i] = new StateBit(this.pbn.getN());
                this.stateCopy[i] = new StateBit(this.pbn.getN());
                ++i;
            }
        }
        i = 0;
        while (i < this.dimension) {
            this.state[i].xor(this.state[i]);
            this.state[i].xor(this.stateList.get(i));
            this.stateCopy[i].xor(this.stateCopy[i]);
            this.stateCopy[i].xor(this.state[i]);
            ++i;
        }
    }

    public double calculateDistribution() {
        return (double)this.stateA / (double)(this.stateA + this.stateB);
    }

    public double[] doSteadyState(int steadySize) throws Exception {
        this.initialise();
        this.generateAlias();
        int[] stateNum = new int[this.stateList.size()];
        int i = 0;
        while (i < steadySize) {
            String re = this.generateCouplingPath();
            String[] tmp = re.split(" ");
            int n = Integer.parseInt(tmp[1]);
            stateNum[n] = stateNum[n] + 1;
            ++i;
        }
        return this.calculateSteady(stateNum, steadySize);
    }

    private double[] calculateSteady(int[] stateNum, int steadySize) {
        double[] distribution = new double[stateNum.length];
        int i = 0;
        while (i < stateNum.length) {
            distribution[i] = (double)stateNum[i] / (double)steadySize;
            ++i;
        }
        return distribution;
    }

    public double[] doSteadyState(long steadySize) throws Exception {
        this.initialise();
        this.generateAlias();
        long[] stateNum = new long[this.stateList.size()];
        long i = 0L;
        while (i < steadySize) {
            String re = this.generateCouplingPath();
            String[] tmp = re.split(" ");
            int n = Integer.parseInt(tmp[1]);
            stateNum[n] = stateNum[n] + 1L;
            ++i;
        }
        return this.calculateSteady(stateNum, steadySize);
    }

    private double[] calculateSteady(long[] stateNum, long steadySize) {
        double[] distribution = new double[stateNum.length];
        int i = 0;
        while (i < stateNum.length) {
            distribution[i] = (double)stateNum[i] / (double)steadySize;
            ++i;
        }
        return distribution;
    }

    /* synthetic */ PerfectSimulationWalkerBitSet(PerfectSimulationWalkerBitSet perfectSimulationWalkerBitSet) {
        this();
    }

    private class Property {
        int nodeIndex;
        boolean nodeValue;

        public Property(int nodeIndex, boolean nodeValue) {
            this.nodeIndex = nodeIndex;
            this.nodeValue = nodeValue;
        }
    }

    private static class SingletonHolder {
        private static final PerfectSimulationWalkerBitSet INSTANCE = new PerfectSimulationWalkerBitSet(null);

        private SingletonHolder() {
        }
    }
}

