/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import simulationMethod.SimulationMethod;

public abstract class TwoState
extends SimulationMethod {
    protected double alpha;
    protected double beta;
    protected double approximation;
    protected double confidence;
    protected double epsilon;
    protected List<Object> metaA;
    protected List<Object> metaB;
    protected int initialBurnIn;
    protected double qMinN;
    protected int kstep;

    public TwoState() {
        this.approximation = 0.005;
        this.confidence = 0.95;
        this.epsilon = 0.001;
        this.metaA = new ArrayList<Object>();
        this.metaB = new ArrayList<Object>();
        this.initialBurnIn = 5;
        this.qMinN = 5.0E-4;
        this.kstep = 1;
    }

    public TwoState(double approximation, double confidence, double epsilon) {
        this.approximation = approximation;
        this.confidence = confidence;
        this.epsilon = epsilon;
        this.metaA = new ArrayList<Object>();
        this.metaB = new ArrayList<Object>();
        this.initialBurnIn = 5;
        this.qMinN = 5.0E-4;
        this.kstep = 1;
    }

    public TwoState(double approximation, double confidence, double epsilon, int kstep) {
        this.approximation = approximation;
        this.confidence = confidence;
        this.epsilon = epsilon;
        this.metaA = new ArrayList<Object>();
        this.metaB = new ArrayList<Object>();
        this.initialBurnIn = 5;
        this.qMinN = 5.0E-4;
        this.kstep = kstep;
    }

    public void setQMinN(double qMinN) {
        this.qMinN = qMinN;
    }

    public void addMetaA(Object st) {
        this.metaA.add(st);
    }

    public List<Object> getMetaA() {
        return this.metaA;
    }

    public void addMetaB(Object st) {
        this.metaB.add(st);
    }

    public List<Object> getMetaB() {
        return this.metaB;
    }

    public abstract void calAlphaBeta();

    public boolean evaluateState(Object st, Object[] exp) {
        return false;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    private String getTimeCost(Date start, Date end, String work) {
        long l = end.getTime() - start.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return "Total time for " + work + " is " + day + " days " + hour + " hours " + min + " mins " + s + " seconds";
    }
}

