/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.StateBit;
import functionLib.StatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationEngine;
import simulationMethod.TwoState;

public class TwoStateBitSetKstep
extends TwoState {
    private BitSet trajectory;
    private int traIndex;
    private int updateIndex;
    private short[] transitions;
    private boolean[] state;
    private int count = 0;
    private long countSteps;
    private long transitionAlpha = 0L;
    private long transitionBeta = 0L;
    private long transitionMinusAlpha = 0L;
    private long transitionMinusBeta = 0L;
    private int[][] transitionsLast = new int[2][2];
    private long stateA = 0L;
    private long stateB = 0L;
    private String outputName;
    private Object previous;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private int storedNum = 100;
    PrintWriter pwtmp;

    public TwoStateBitSetKstep() throws FileNotFoundException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostate" + df.format(new Date()) + ".txt";
        this.pwtmp = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream("exportState0910.txt")), true);
    }

    public TwoStateBitSetKstep(double approximation, double confidence, double epsilon) throws FileNotFoundException {
        super(approximation, confidence, epsilon);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostate" + df.format(new Date()) + ".txt";
        this.pwtmp = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream("exportState0910.txt")), true);
    }

    public TwoStateBitSetKstep(double approximation, double confidence, double epsilon, int kstep) throws FileNotFoundException {
        super(approximation, confidence, epsilon, kstep);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostate" + df.format(new Date()) + ".txt";
        this.pwtmp = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream("exportState0910.txt")), true);
    }

    public void initialise() {
        this.transitions = new short[this.storedNum - 1];
        this.state = new boolean[this.storedNum];
        this.count = 0;
        this.countSteps = 0L;
        this.transitionAlpha = 0L;
        this.transitionBeta = 0L;
        this.transitionMinusAlpha = 0L;
        this.transitionMinusBeta = 0L;
        this.stateA = 0L;
        this.stateB = 0L;
        this.previous = null;
        this.traIndex = 0;
        this.updateIndex = 0;
    }

    public void setExpressions(String property) throws IOException {
        int value;
        String line = "";
        InputStreamReader reader = new InputStreamReader(new FileInputStream(property));
        BufferedReader br = new BufferedReader(reader);
        line = br.readLine();
        StringTokenizer token = new StringTokenizer(line, " ");
        this.positiveIndex = new ArrayList<Integer>();
        this.negativeIndex = new ArrayList<Integer>();
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.positiveIndex.add(value);
        }
        line = br.readLine();
        token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.negativeIndex.add(value);
        }
        br.close();
        reader.close();
    }

    private void determinK(SimulationEngine simulationEngine, StateBit initialState) throws Exception {
        this.traIndex = 0;
        this.trajectory = new BitSet();
        this.updateIndex = 0;
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long time = System.nanoTime();
        long cpu = thread.getCurrentThreadCpuTime();
        int index_i = 0;
        int index_j = 0;
        int index_k = 0;
        boolean mul = false;
        int loopCount = 1;
        boolean done = false;
        int kstep = 1;
        kstep = 1;
        this.storedNum = 10000;
        this.initialise();
        int burnIn = 10000;
        initialState = (StateBit)simulationEngine.simulate(burnIn, (Object)initialState);
        this.traIndex = 0;
        this.trajectory.clear();
        int[][][] twoStepTransition = new int[2][2][2];
        boolean[] pre = new boolean[2];
        int simulationSteps = 0;
        while (!done) {
            int k;
            int j;
            int i;
            simulationSteps = this.storedNum * kstep - simulationSteps;
            mul = false;
            loopCount = 1;
            this.updateIndex = 0;
            while (!mul) {
                System.out.println("Kstep " + kstep + ", loop" + loopCount);
                initialState = (StateBit)simulationEngine.simulate(simulationSteps, (Object)initialState);
                if (loopCount == 1) {
                    index_i = this.trajectory.get(this.updateIndex) ? 0 : 1;
                    this.updateIndex += kstep;
                    index_j = this.trajectory.get(this.updateIndex) ? 0 : 1;
                    this.updateIndex += kstep;
                }
                while (this.updateIndex < this.traIndex) {
                    int bridge1 = index_i;
                    int bridge2 = index_j;
                    index_k = this.trajectory.get(this.updateIndex) ? 0 : 1;
                    this.updateIndex += kstep;
                    index_i = index_j;
                    index_j = index_k;
                    int[] nArray = twoStepTransition[bridge1][bridge2];
                    int n = index_k;
                    nArray[n] = nArray[n] + 1;
                }
                mul = true;
                i = 0;
                while (i < 2) {
                    j = 0;
                    while (j < 2) {
                        k = 0;
                        while (k < 2) {
                            if (twoStepTransition[i][j][k] == 0) {
                                mul = false;
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                ++loopCount;
                this.count = 0;
            }
            int[][] ijplus = new int[2][2];
            i = 0;
            while (i < 2) {
                j = 0;
                while (j < 2) {
                    ijplus[i][j] = twoStepTransition[i][j][0] + twoStepTransition[i][j][1];
                    ++j;
                }
                ++i;
            }
            int[][] plusjk = new int[2][2];
            int j2 = 0;
            while (j2 < 2) {
                int k2 = 0;
                while (k2 < 2) {
                    plusjk[j2][k2] = twoStepTransition[0][j2][k2] + twoStepTransition[1][j2][k2];
                    ++k2;
                }
                ++j2;
            }
            int[] plusjplus = new int[2];
            j2 = 0;
            while (j2 < 2) {
                plusjplus[j2] = ijplus[1][j2] + ijplus[0][j2];
                ++j2;
            }
            double G2 = 0.0;
            i = 0;
            while (i < 2) {
                j = 0;
                while (j < 2) {
                    k = 0;
                    while (k < 2) {
                        G2 += (double)twoStepTransition[i][j][k] * Math.log((double)twoStepTransition[i][j][k] / (double)ijplus[i][j] * (double)plusjplus[j] / (double)plusjk[j][k]);
                        twoStepTransition[i][j][k] = 0;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            System.out.println(G2 *= 2.0);
            double bic = G2 - 2.0 * Math.log(this.storedNum * (loopCount - 1) - 2);
            System.out.println("bic" + bic);
            if (bic < 2.0) {
                done = true;
                System.out.println("Kstep=" + kstep);
                continue;
            }
            ++kstep;
        }
        this.storedNum = 100;
        this.initialise();
        this.kstep = kstep;
        long sub = thread.getCurrentThreadCpuTime();
        long mill = System.nanoTime();
        System.out.println("CPU time: " + sub);
        System.out.println("Nano time: " + (mill -= time));
    }

    public double[] run(BitSetPBN pbn, StateBit initialState, String property) throws Exception {
        this.setExpressions(property);
        return this.run(pbn, initialState);
    }

    public double[] run(BitSetPBN pbn, StateBit initialState) throws Exception {
        this.initialise();
        BitSetPBNSimulationEngine simulationEngine = new BitSetPBNSimulationEngine(pbn, this);
        if (initialState == null) {
            initialState = new StateBit(pbn.getN());
        } else if (initialState.getN() != pbn.getN()) {
            System.out.println("State length does not coinside with PBN, use default state.");
            initialState = new StateBit(pbn.getN());
        }
        this.determinK(simulationEngine, initialState);
        double confidence = this.confidence;
        double approximation = this.approximation;
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + confidence), false);
        int burnIn = this.initialBurnIn;
        int reest = 0;
        int maxLength = 0;
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(this.outputName)), true);
        int Nmin = (int)Math.ceil(invPhi * invPhi * this.qMinN * (1.0 - this.qMinN) / (approximation * approximation)) * this.kstep;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        long time = System.currentTimeMillis();
        pw.println("Program started at " + df.format(start));
        initialState = (StateBit)simulationEngine.simulate(Nmin, (Object)initialState);
        this.updateAllTransition();
        pw.println("Approximation is " + approximation + ", confidence is " + confidence + ", epsilon is " + this.epsilon + ", fetch sample every " + this.kstep + " steps.");
        this.calAlphaBeta(burnIn);
        double alpha = this.getAlpha();
        double beta = this.getBeta();
        pw.println("Initial simulation steps are " + Nmin);
        pw.println("alpha=" + alpha + ",beta=" + beta);
        while (alpha < 1.0E-7 || beta < 1.0E-7 || alpha > 0.99999999 && beta > 0.99999999) {
            initialState = (StateBit)simulationEngine.simulate(Nmin, (Object)initialState);
            this.updateAllTransition();
            this.calAlphaBeta(burnIn);
            alpha = this.getAlpha();
            beta = this.getBeta();
            pw.println("alpha=" + alpha + ",beta=" + beta);
        }
        maxLength = Nmin;
        int M = (int)Math.ceil(Math.log(this.epsilon * (alpha + beta) / Math.max(alpha, beta)) / Math.log(Math.abs(1.0 - alpha - beta)));
        int N = (int)Math.ceil(alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(approximation / invPhi, 2.0))) * this.kstep;
        pw.println("M=" + M * this.kstep);
        pw.println("N=" + N);
        while (maxLength < N) {
            int simulateLength = N - maxLength;
            initialState = (StateBit)simulationEngine.simulate(simulateLength, (Object)initialState);
            this.updateAllTransition();
            maxLength = N;
            this.calAlphaBeta(M);
            alpha = this.getAlpha();
            beta = this.getBeta();
            while (alpha < 1.0E-7 || beta < 1.0E-7 || alpha > 0.99999999 && beta > 0.99999999) {
                initialState = (StateBit)simulationEngine.simulate(simulateLength, (Object)initialState);
                this.updateAllTransition();
                maxLength = N + simulateLength;
                this.calAlphaBeta(M);
                alpha = this.getAlpha();
                beta = this.getBeta();
            }
            M = (int)Math.ceil(Math.log(this.epsilon * (alpha + beta) / Math.max(alpha, beta)) / Math.log(Math.abs(1.0 - alpha - beta)));
            N = (int)Math.ceil(alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(approximation / invPhi, 2.0))) * this.kstep;
            pw.println("Re-estimating round " + ++reest + ": alpha=" + alpha + ", beta=" + beta + ", M=" + M + ", N" + N + ".");
            pw.println("M=" + Math.log(this.epsilon * (alpha + beta) / Math.max(alpha, beta)) / Math.log(Math.abs(1.0 - alpha - beta)) + ", N=" + alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(approximation / invPhi, 2.0)));
        }
        pw.println("Re-estimation times=" + reest);
        pw.println("final M=" + M * this.kstep);
        pw.println("final N=" + N);
        pw.println(this.getTimeCost(start, new Date(), ""));
        pw.println("alpha=" + alpha + ",beta=" + beta);
        pw.println("distribution=" + this.calDistribution(M));
        double distribution = this.calDistribution(M);
        pw.close();
        this.pwtmp.close();
        return new double[]{distribution, M * this.kstep + N, (double)(System.currentTimeMillis() - time) / 1000.0};
    }

    public void addMetaA(StateBit st) {
        this.metaA.add(st);
    }

    @Override
    public List<Object> getMetaA() {
        return this.metaA;
    }

    public void addMetaB(StateBit st) {
        this.metaB.add(st);
    }

    @Override
    public List<Object> getMetaB() {
        return this.metaB;
    }

    public void calAlphaBeta(int M) {
        int index1 = 0;
        int index2 = 0;
        int[][] transitionsLast = new int[2][2];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                transitionsLast[i][j] = this.transitionsLast[i][j];
                ++j;
            }
            ++i;
        }
        index1 = this.trajectory.get(0) ? 1 : 0;
        i = 1;
        while (i < M) {
            int bridge = index1;
            if (this.trajectory.get(i)) {
                index1 = 1;
                index2 = 1;
            } else {
                index1 = 0;
                index2 = 0;
            }
            int[] nArray = transitionsLast[bridge];
            int n = index2;
            nArray[n] = nArray[n] - 1;
            ++i;
        }
        this.beta = transitionsLast[0][0] + transitionsLast[0][1] == 0 ? 0.0 : (double)transitionsLast[0][1] / (double)(transitionsLast[0][0] + transitionsLast[0][1]);
        this.alpha = transitionsLast[1][0] + transitionsLast[1][1] == 0 ? 0.0 : (double)transitionsLast[1][0] / (double)(transitionsLast[1][0] + transitionsLast[1][1]);
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public double getBeta() {
        return this.beta;
    }

    public double calDistribution(int M) {
        long stateA = this.stateA;
        long stateB = this.stateB;
        int i = M;
        while (i < this.storedNum - 1) {
            if (this.state[i]) {
                ++stateA;
            } else {
                ++stateB;
            }
            ++i;
        }
        long total = stateA + stateB;
        if (total != 0L) {
            return (double)stateA / (double)total;
        }
        return 0.0;
    }

    private String getTimeCost(Date start, Date end, String work) {
        long l = end.getTime() - start.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return "Total time for " + work + " is " + day + " days " + hour + " hours " + min + " mins " + s + " seconds";
    }

    @Override
    public void calAlphaBeta() {
    }

    public boolean evaluateState(Object st) {
        if (!(st instanceof StateBit)) {
            return false;
        }
        StateBit state = (StateBit)st;
        int i = 0;
        while (i < this.positiveIndex.size()) {
            if (!state.get(this.positiveIndex.get(i))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.negativeIndex.size()) {
            if (state.get(this.negativeIndex.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void updateTransition(StateBit current, int para) {
        ++this.countSteps;
        this.pwtmp.println(this.evaluateState(current));
        if ((this.countSteps - 1L) % (long)this.kstep != 0L) {
            return;
        }
        this.trajectory.set(this.traIndex, this.evaluateState(current));
        ++this.traIndex;
    }

    public void updateAllTransition() {
        int index1 = 0;
        int index2 = 0;
        if (this.trajectory.get(this.updateIndex)) {
            index1 = 1;
            ++this.stateA;
        } else {
            index1 = 0;
            ++this.stateB;
        }
        int i = this.updateIndex + 1;
        while (i < this.traIndex) {
            int bridge = index1;
            if (this.trajectory.get(i)) {
                index1 = 1;
                index2 = 1;
                ++this.stateA;
            } else {
                index1 = 0;
                index2 = 0;
                ++this.stateB;
            }
            int[] nArray = this.transitionsLast[bridge];
            int n = index2;
            nArray[n] = nArray[n] + 1;
            ++i;
        }
        this.updateIndex = this.traIndex;
    }
}

