/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import simulator.Alias;

public final class AliasMethod {
    private final Random random;
    ThreadLocalRandom random2;
    private final int[] alias;
    private final double[] probability;
    private int[] column;

    public AliasMethod(double[] probabilities, int[] column) {
        this(probabilities, new Random(), column);
    }

    public AliasMethod(double[] probabilities, Random random, int[] column) {
        if (probabilities == null || random == null) {
            throw new NullPointerException();
        }
        if (probabilities.length == 0) {
            throw new IllegalArgumentException("Probability vector must be nonempty.");
        }
        if (column == null) {
            this.column = new int[probabilities.length];
            int i = 0;
            while (i < probabilities.length) {
                this.column[i] = i;
                ++i;
            }
        } else {
            this.column = column;
        }
        this.probability = new double[probabilities.length];
        this.alias = new int[probabilities.length];
        this.random = random;
        double average = 1.0 / (double)probabilities.length;
        probabilities = (double[])probabilities.clone();
        ArrayDeque<Integer> small = new ArrayDeque<Integer>();
        ArrayDeque<Integer> large = new ArrayDeque<Integer>();
        int i = 0;
        while (i < probabilities.length) {
            if (probabilities[i] >= average) {
                large.add(i);
            } else {
                small.add(i);
            }
            ++i;
        }
        while (!small.isEmpty() && !large.isEmpty()) {
            int less = (Integer)small.removeLast();
            int more = (Integer)large.removeLast();
            this.probability[less] = probabilities[less] * (double)probabilities.length;
            this.alias[less] = this.column[more];
            probabilities[more] = probabilities[more] + probabilities[less] - average;
            if (probabilities[more] >= average) {
                large.add(more);
                continue;
            }
            small.add(more);
        }
        while (!small.isEmpty()) {
            this.probability[((Integer)small.removeLast()).intValue()] = 1.0;
        }
        while (!large.isEmpty()) {
            this.probability[((Integer)large.removeLast()).intValue()] = 1.0;
        }
    }

    public List<Alias> getAlias() {
        ArrayList<Alias> listAlias = new ArrayList<Alias>();
        int i = 0;
        while (i < this.column.length) {
            Alias aliasElement = new Alias(this.column[i], this.alias[i], this.probability[i]);
            listAlias.add(aliasElement);
            ++i;
        }
        return listAlias;
    }

    public Alias[] getAliasArray() {
        Alias[] aliasArray = new Alias[this.column.length];
        int i = 0;
        while (i < this.column.length) {
            Alias aliasElement;
            aliasArray[i] = aliasElement = new Alias(this.column[i], this.alias[i], this.probability[i]);
            ++i;
        }
        return aliasArray;
    }

    public int next() {
        int columnIndex = ThreadLocalRandom.current().nextInt(this.probability.length);
        boolean coinToss = ThreadLocalRandom.current().nextDouble() < this.probability[columnIndex];
        return coinToss ? this.column[columnIndex] : this.alias[columnIndex];
    }

    public int next(double random1, double random2) {
        int columnIndex = (int)(random1 * (double)this.probability.length);
        boolean coinToss = random2 < this.probability[columnIndex];
        return coinToss ? this.column[columnIndex] : this.alias[columnIndex];
    }
}

