/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.math3.distribution.ExponentialDistribution;

public class MM1Queue {
    ExponentialDistribution arrivalExp;
    ExponentialDistribution serviceExp;
    Queue<Double> queue;
    boolean initialized = false;
    private int totalCustomer;
    double nextArrival;
    double nextDeparture;

    public MM1Queue(double lambda, double mu) {
        this.arrivalExp = new ExponentialDistribution(1.0 / lambda);
        this.serviceExp = new ExponentialDistribution(mu);
    }

    private void initialise() {
        if (this.initialized) {
            return;
        }
        this.queue = new LinkedList<Double>();
        this.totalCustomer = 0;
        this.nextArrival = this.arrivalExp.sample();
        this.nextDeparture = Double.POSITIVE_INFINITY;
        this.initialized = true;
    }

    public void reInitialise() {
        this.initialized = false;
    }

    public List<Double> run(int clientsSize) {
        this.initialise();
        this.totalCustomer += clientsSize;
        ArrayList<Double> usersTime = new ArrayList<Double>();
        while (usersTime.size() < clientsSize) {
            if (this.nextArrival <= this.nextDeparture) {
                if (this.queue.isEmpty()) {
                    this.nextDeparture = this.nextArrival + this.serviceExp.sample();
                }
                this.queue.add(this.nextArrival);
                this.nextArrival += this.arrivalExp.sample();
                continue;
            }
            double arrival = this.queue.remove();
            double wait = this.nextDeparture - arrival;
            usersTime.add(wait);
            if (this.queue.isEmpty()) {
                this.nextDeparture = Double.POSITIVE_INFINITY;
                continue;
            }
            this.nextDeparture += this.serviceExp.sample();
        }
        return usersTime;
    }

    public static void main(String[] args) {
        List<Double> u = new MM1Queue(0.9, 1.0).run(2000000);
        double sum = 0.0;
        for (double a : u) {
            sum += a;
        }
        System.out.println(sum / 2000000.0);
    }
}

