/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.StateBit;
import functionLib.Parameters;
import functionLib.RandomProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import simulationMethod.GaussSeidel;
import simulationMethod.GelmanFullStateParallel;
import simulationMethod.Jacob;
import simulationMethod.SkartPBN;
import simulationMethod.SkartPBNLarge;
import simulationMethod.SkartPBNParallel;
import simulationMethod.StepPerfectSimulationWalkerBitSet;
import simulationMethod.TwoStateBitSet;
import simulationMethod.TwostateMultiPropertyParallel;
import simulator.RandomNumberGenerator;
import userInterface.Version;

public class Assa {
    public BitSetPBN defineBitSetPBN(int n, double perturbation) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = n >= 20 ? 20 : n;
        System.out.println("Max number of functions and max number of parent nodes are set to " + maxVariableNum);
        BitSetPBN pbn = new BitSetPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomPBN(nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBNFromExpression(int n, double perturbation) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = n >= 20 ? 20 : n;
        System.out.println("Max number of functions and max number of parent nodes are set to " + maxVariableNum);
        BitSetPBN pbn = new BitSetPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomPBNWithExpression(nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, double perturbation, int maxFunction, int maxVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBN(n, perturbation);
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBN pbn = new BitSetPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxFunction) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariable) + 1);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomPBN(nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, boolean maxVariableNumLimit) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = maxVariableNumLimit && n >= 20 ? 20 : n;
        BitSetPBN pbn = new BitSetPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomPBN(nf, nv);
        pbn.setPerturbation(0.1);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBN(n, perturbation);
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            System.out.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            System.out.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            System.out.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            System.out.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBN pbn = new BitSetPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffFun = maxFunction - minFunction + 1;
        int diffVar = maxVariable - minVariable + 1;
        int i = 0;
        while (i < nf.length) {
            nf[i] = (int)(rng.randomUnifDouble() * (double)diffFun) + minFunction;
            int j = 0;
            while (j < nf[i]) {
                nv.add((int)(rng.randomUnifDouble() * (double)diffVar) + minVariable);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomPBN(nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBNFromExpression(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBNFromExpression(n, perturbation);
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            System.out.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            System.out.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            System.out.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            System.out.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBN pbn = new BitSetPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffFun = maxFunction - minFunction + 1;
        int diffVar = maxVariable - minVariable + 1;
        int i = 0;
        while (i < nf.length) {
            nf[i] = (int)(rng.randomUnifDouble() * (double)diffFun) + minFunction;
            int j = 0;
            while (j < nf[i]) {
                nv.add((int)(rng.randomUnifDouble() * (double)diffVar) + minVariable);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomPBNWithExpression(nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBNFromExpression(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable, String distributionFile) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBNFromExpression(n, perturbation);
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            System.out.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            System.out.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            System.out.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            System.out.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBN pbn = new BitSetPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffFun = maxFunction - minFunction + 1;
        int diffVar = maxVariable - minVariable + 1;
        double[] distribution = new double[diffVar];
        File file = new File(distributionFile);
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file));
        String tempString = null;
        int count = 0;
        tempString = reader.readLine();
        if (tempString != null) {
            StringTokenizer st = new StringTokenizer(tempString);
            while (st.hasMoreTokens()) {
                distribution[count] = Double.parseDouble(st.nextToken());
                if (count > 0) {
                    int n2 = count;
                    distribution[n2] = distribution[n2] + distribution[count - 1];
                }
                ++count;
            }
        }
        int i = 0;
        while (i < nf.length) {
            nf[i] = (int)(rng.randomUnifDouble() * (double)diffFun) + minFunction;
            int j = 0;
            while (j < nf[i]) {
                double random = rng.randomUnifDouble();
                count = 0;
                while (random > distribution[count]) {
                    ++count;
                }
                nv.add(count + minVariable);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomPBNWithExpression(nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN generatePBN(int n, String fileName, double perturbation, int type, int maxFunctionNum, int maxVariableNum, int minFunctionNum, int minVariableNum) throws Exception {
        if (perturbation < 0.0) {
            perturbation = RandomProvider.getInstance().getRandom().nextDouble();
        }
        BitSetPBN pbn = this.defineBitSetPBN(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum);
        BitSetPBNIO exp = new BitSetPBNIO();
        if (fileName == null || fileName.equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
            fileName = "model/PBN_Node" + n + "_" + df.format(new Date());
        }
        switch (type) {
            case 0: {
                exp.exportPBN(pbn, fileName);
                break;
            }
            case 1: {
                exp.exportPBNtoMatlab(pbn, fileName);
                break;
            }
            case 2: {
                exp.exportPBN(pbn, String.valueOf(fileName) + ".txt");
                exp.exportPBNtoMatlab(pbn, String.valueOf(fileName) + ".m");
                break;
            }
            default: {
                System.out.println("The export type is not recognized!");
            }
        }
        return pbn;
    }

    public BitSetPBN generatePBNExpression(int n, String fileName, double perturbation, int type, int maxFunctionNum, int maxVariableNum, int minFunctionNum, int minVariableNum, String distributionFile) throws Exception {
        if (perturbation < 0.0) {
            perturbation = RandomProvider.getInstance().getRandom().nextDouble();
        }
        BitSetPBN pbn = distributionFile == null ? this.defineBitSetPBNFromExpression(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum) : this.defineBitSetPBNFromExpression(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum, distributionFile);
        BitSetPBNIO exp = new BitSetPBNIO();
        if (fileName == null || fileName.equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
            fileName = "model/PBN_Node" + n + "_" + df.format(new Date());
        }
        switch (type) {
            case 0: {
                exp.exportPBN(pbn, fileName);
                break;
            }
            case 1: {
                exp.exportPBNtoMatlab(pbn, fileName);
                break;
            }
            case 2: {
                exp.exportPBN(pbn, String.valueOf(fileName) + ".txt");
                exp.exportPBNtoMatlab(pbn, String.valueOf(fileName) + ".m");
                break;
            }
            default: {
                System.out.println("The export type is not recognized!");
            }
        }
        return pbn;
    }

    public BitSetPBN generatePBNfromFile(String fromFile, int type, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.generatePBNFromFile(fromFile);
        switch (type) {
            case 0: {
                io.exportPBN(pbn, outputName);
                break;
            }
            case 1: {
                io.exportPBNtoMatlab(pbn, outputName);
                break;
            }
            case 2: {
                io.exportPBN(pbn, String.valueOf(outputName) + ".txt");
                io.exportPBNtoMatlab(pbn, String.valueOf(outputName) + ".m");
                break;
            }
        }
        return pbn;
    }

    public void runTwoStateBitSet(double precision, double confidence, String modelFileName, String property, boolean isMatlab, String outputName, boolean globalAlias) throws Exception {
        TwoStateBitSet ts = new TwoStateBitSet(precision, confidence, Parameters.epsilon, 1);
        double average = 0.0;
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(modelFileName, isMatlab);
        System.out.println("Performing the two state Markov chain approach on the PBN from file " + modelFileName);
        if (outputName != null) {
            ts.setLogFile(outputName);
        } else {
            outputName = ts.getLogFile();
        }
        System.out.println("Detailed information is stored in the file " + outputName + ".");
        StateBit initialState = new StateBit(0);
        int sampleSize = 0;
        double cpuTime = 0.0;
        if (!globalAlias) {
            ts.setDisableGlobalAlias(true);
        }
        ts.setExpressions(property);
        double[] result = ts.run(pbn, initialState);
        double time = result[3];
        System.out.println("Sample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCPU time cost\t" + (cpuTime += result[2]) + " s\nTime cost\t" + time);
    }

    public void runTwostateParallelSingleProperty(String pbnName, boolean isMatlab, String property, double precision, int m, int kstep, double confidence, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(pbnName, isMatlab);
        GelmanFullStateParallel gelman = new GelmanFullStateParallel(pbn);
        if (outputName != null) {
            gelman.setLogFile(outputName);
        } else {
            outputName = gelman.getLogFile();
        }
        System.out.println("Run the two-state approach in parallel for computing " + pbnName + " for property " + property + "...");
        int nThreads = Runtime.getRuntime().availableProcessors();
        System.out.println("number of processors: " + nThreads);
        gelman.setExpressions(property);
        gelman.setParameters(precision, confidence);
        if (m > nThreads) {
            System.out.println("Required number of chains is " + m + ", the program sets it to " + nThreads + " (the number of processors in the computer).\n");
            m = nThreads;
        }
        gelman.setM(m);
        gelman.setKstep(kstep);
        long start = System.nanoTime();
        double[] re = gelman.computeSteadyState();
        start = System.nanoTime() - start;
        gelman.printStatistic();
        System.out.println("precision=" + precision + ", probability=" + re[0] + ", time cost=" + (double)start / 1.0E9 + "s.");
    }

    public void runTwoStateParallelMultipleProperties(String pbnName, boolean isMatlab, String property, double precision, int m, int kstep, double confidence, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(pbnName, isMatlab);
        TwostateMultiPropertyParallel tsmp = new TwostateMultiPropertyParallel(pbn);
        if (outputName != null) {
            tsmp.setLogFile(outputName);
        } else {
            outputName = tsmp.getLogFile();
        }
        System.out.println("Run the two-state method in parallel for computing " + pbnName + " for property " + property + "...");
        int nThreads = Runtime.getRuntime().availableProcessors();
        System.out.println("number of processors: " + nThreads);
        tsmp.setExpressions(property);
        tsmp.setParameters(precision, confidence);
        if (m > nThreads) {
            System.out.println("Required number of chains is " + m + ", the program sets it to " + nThreads + " (the number of processors in the computer).\n");
            m = nThreads;
        }
        tsmp.setM(m);
        tsmp.setKstep(kstep);
        long start = System.nanoTime();
        double[][] re = tsmp.computeSteadyState();
        start = System.nanoTime() - start;
        tsmp.printStatistic();
        System.out.println("Total time cost: " + (double)start / 1.0E9);
        int i = 0;
        while (i < re[0].length) {
            System.out.println("Property " + i + ": ");
            System.out.println("\t probability\t" + re[0][i] + "\trequired sample size\t" + re[1][i] + "\tactual sample size\t" + re[2][i]);
            ++i;
        }
    }

    public void runStepPerfectSimulation(String modelFileName, boolean isMatlab, String propertyFileName, double confidence, double precision, String outputName, boolean useAlias, boolean cost) throws Exception {
        StepPerfectSimulationWalkerBitSet ps = StepPerfectSimulationWalkerBitSet.getInstance();
        BitSetPBNIO exp = new BitSetPBNIO();
        BitSetPBN pbn = exp.loadPBN(modelFileName, isMatlab);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        if (outputName == null) {
            outputName = "ps_" + df.format(new Date()) + ".txt";
        }
        ps.setIO(pbn, outputName);
        ps.setSampleSize(confidence, precision);
        ps.setUseAlias(useAlias);
        if (cost) {
            ps.setCost(true);
        }
        double average = 0.0;
        double sampleSize = 0.0;
        double simulationStep = 0.0;
        double couplingStep = 0.0;
        double cpu = 0.0;
        System.out.println("Performing the perfect simulation algorithm on the PBN from file " + modelFileName);
        System.out.println("Detailed information is stored in the file " + outputName + ".");
        double[] result = ps.runWalker(propertyFileName, 1000, true);
        System.out.println("Avg. coupling steps\t" + (couplingStep += result[1]) + "\nSimulation steps\t" + (simulationStep += result[2]) + "\nNumber of samples\t" + (int)(sampleSize += result[3]) + "\nCPU time cost\t\t" + (cpu += result[4]) + "s\nProbability\t\t" + (average += result[0]));
    }

    public void runPBNIO(String PBNfile, boolean isFromMatlab, String outputName, int type) throws Exception {
        BitSetPBNIO pbnIO = new BitSetPBNIO();
        BitSetPBN pbn = pbnIO.loadPBN(PBNfile, isFromMatlab);
        System.out.println("Start exporting model...");
        switch (type) {
            case 0: {
                pbnIO.exportPBN(pbn, outputName);
                break;
            }
            case 1: {
                pbnIO.exportPBNtoMatlab(pbn, outputName);
                break;
            }
            case 2: {
                pbnIO.exportPBN(pbn, String.valueOf(outputName) + ".txt");
                pbnIO.exportPBNtoMatlab(pbn, String.valueOf(outputName) + ".m");
                break;
            }
            case 3: {
                pbnIO.exportPBNtoGenYsis(pbn, String.valueOf(outputName) + ".net");
                break;
            }
            case 4: {
                pbnIO.exportPBNtoMCMAS(pbn, String.valueOf(outputName) + ".ispl");
                break;
            }
            case 5: {
                pbnIO.exportPBNtoMCMASWithOrder(pbn, String.valueOf(outputName) + "-withorder.ispl");
                break;
            }
            case 6: {
                pbnIO.exportPBNtoMCMASHeuristic1(pbn, String.valueOf(outputName) + "-heuristic1.ispl");
                break;
            }
            case 7: {
                pbnIO.exportPBNtoMCMASForceHeuristic(pbn, String.valueOf(outputName) + "-force.ispl");
                break;
            }
            case 8: {
                pbnIO.exportPBNtoMCMASWithOrder2(pbn, String.valueOf(outputName) + "-withorder2.ispl");
                break;
            }
        }
    }

    public void runSkartPBN(double precision, double confidence, String modelFileName, String property, boolean isMatlab, String outputName, boolean globalAlias) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(modelFileName, isMatlab);
        System.out.println("Performing the Skart method on the PBN from file " + modelFileName);
        SkartPBN skart = new SkartPBN(pbn);
        skart.setExpressions(property);
        skart.setAlpha(1.0 - confidence);
        skart.setPrecision(precision);
        if (!globalAlias) {
            skart.setDisableGlobalAlias(true);
        }
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        System.out.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double halfLength = 0.0;
        double timeCost = 0.0;
        double average = 0.0;
        double[] estimate = skart.run();
        halfLength = estimate[2] - estimate[0];
        System.out.println("Sample size\t" + (sampleSize += (int)estimate[3]) + "\nProbability\t" + (average += estimate[2]) + "\nCI half-length\t" + halfLength + "\nCPU time cost\t" + (timeCost += estimate[4]) + "s");
    }

    public void runSkartPBNLarge(double precision, double confidence, String modelFileName, String property, boolean isMatlab, String outputName, boolean globalAlias) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(modelFileName, isMatlab);
        System.out.println("Performing the full version Skart method on the PBN from file " + modelFileName + ".");
        SkartPBNLarge skart = new SkartPBNLarge(pbn);
        skart.setExpressions(property);
        skart.setAlpha(1.0 - confidence);
        skart.setPrecision(precision);
        if (!globalAlias) {
            skart.setDisableGlobalAlias(true);
        }
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        System.out.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double halfLength = 0.0;
        double timeCost = 0.0;
        double average = 0.0;
        double[] estimate = skart.run();
        halfLength = estimate[2] - estimate[0];
        System.out.println("Sample size\t" + (sampleSize += (int)estimate[3]) + "\nProbability\t" + (average += estimate[2]) + "\nCI half-length\t" + halfLength + "\nCPU time cost\t" + (timeCost += estimate[4]) + "s");
    }

    public void runSkartParallel(String pbnName, String property, double precision, double confidence, int m, String outputName, Boolean isMatlab) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(pbnName, isMatlab);
        System.out.println("Performing the Skart method (parallel version) to analyse " + property + " for model " + pbnName + "...");
        SkartPBNParallel skart = new SkartPBNParallel(pbn);
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        int nThreads = Runtime.getRuntime().availableProcessors();
        if (m > nThreads) {
            System.out.println("Required number of chains is " + m + ", the program sets it to " + nThreads + " (the number of processors in the computer).\n");
            m = nThreads;
        }
        skart.setM(m);
        skart.setExpressions(property);
        skart.setPrecision(precision);
        skart.setAlpha(1.0 - confidence);
        double[] re = skart.run();
        System.out.println("Precision=" + precision + ", confidence=" + confidence + ", number of chains=" + m);
        System.out.println("Detailed information is stored in the file " + outputName + ".");
        System.out.println("the CI low value\t" + re[0]);
        System.out.println("the CI high value\t" + re[1]);
        System.out.println("the average value\t" + re[2]);
        System.out.println("the sample size\t\t" + re[3]);
        System.out.println("the time cost\t\t" + re[5]);
        System.out.println("extention step2\t\t" + re[6]);
        System.out.println("extention step5\t\t" + re[7]);
    }

    public void run(String[] args) throws Exception {
        boolean gee = false;
        boolean gef = false;
        boolean skart = false;
        boolean ts = false;
        boolean ge = false;
        boolean cost = false;
        boolean skartLarge = false;
        boolean help = false;
        boolean gauss = false;
        boolean jacobi = false;
        boolean ps = false;
        boolean io = false;
        boolean isMatlab = false;
        boolean globalAlias = true;
        double precision = 0.01;
        double confidence = 0.95;
        double perturbation = 0.01;
        int maxFunction = 0;
        int maxVariable = 0;
        int maxIteration = 0;
        String parameterFileName = "";
        String modelFileName = "";
        String propertyName = "";
        String outputName = null;
        String distributionFile = null;
        int n = 0;
        int i = 0;
        int type = 7;
        int m = 1;
        int kstep = 1;
        int minFunction = 0;
        int minVariable = 0;
        if (args == null || args.length == 0) {
            help = true;
        } else if (args[0].equals("-gee")) {
            gee = true;
            n = Integer.parseInt(args[++i]);
            perturbation = Double.parseDouble(args[++i]);
            modelFileName = args.length > ++i ? args[i] : null;
            type = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                maxFunction = Integer.parseInt(args[i]);
                minFunction = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                maxVariable = Integer.parseInt(args[i]);
                minVariable = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                distributionFile = args[i];
            }
        } else if (args[0].equals("-ge")) {
            ge = true;
            n = Integer.parseInt(args[++i]);
            perturbation = Double.parseDouble(args[++i]);
            modelFileName = args.length > ++i ? args[i] : null;
            type = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                maxFunction = Integer.parseInt(args[i]);
                minFunction = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                maxVariable = Integer.parseInt(args[i]);
                minVariable = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-gef")) {
            gef = true;
            parameterFileName = args[++i];
            outputName = args[++i];
            type = Integer.parseInt(args[++i]);
        } else if (args[0].equals("-io")) {
            io = true;
            modelFileName = args[++i];
            isMatlab = Boolean.parseBoolean(args[++i]);
            outputName = args[++i];
            type = Integer.parseInt(args[++i]);
        } else if (args[0].equals("-gauss")) {
            gauss = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            propertyName = args[++i].equals("-dis") ? null : args[i];
            if (args.length > ++i) {
                precision = Double.parseDouble(args[i]);
                maxIteration = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-jacobi")) {
            jacobi = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            propertyName = args[++i].equals("-dis") ? null : args[i];
            if (args.length > ++i) {
                precision = Double.parseDouble(args[i]);
                maxIteration = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-ps")) {
            ps = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-global")) {
                    globalAlias = Boolean.parseBoolean(args[++i]);
                } else {
                    cost = Boolean.parseBoolean(args[i]);
                }
            }
            if (args.length > ++i) {
                cost = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-ts")) {
            ts = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-skart")) {
            skart = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-skartfull")) {
            skartLarge = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equalsIgnoreCase("-skartPa")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            m = Integer.parseInt(args[++i]);
            this.runSkartParallel(modelFileName, propertyName, precision, confidence, m, outputName, isMatlab);
        } else if (args[0].equals("-h") || args[0].equals("-help") || args[0].equals("-H")) {
            help = true;
        } else if (args[0].equals("-v") || args[0].equals("-V")) {
            new Version().showVersion();
            System.exit(0);
        } else if (args[0].equalsIgnoreCase("-tsPa")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            m = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                kstep = Integer.parseInt(args[i]);
            }
            this.runTwostateParallelSingleProperty(modelFileName, isMatlab, propertyName, precision, m, kstep, confidence, outputName);
        } else if (args[0].equalsIgnoreCase("-tsPam")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            m = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                kstep = Integer.parseInt(args[i]);
            }
            this.runTwoStateParallelMultipleProperties(modelFileName, isMatlab, propertyName, precision, m, kstep, confidence, outputName);
        } else {
            System.out.println("Wrong input parameter");
            this.showhelp();
            System.exit(0);
        }
        try {
            if (ge) {
                this.generatePBN(n, modelFileName, perturbation, type, maxFunction, maxVariable, minFunction, minVariable);
            } else if (gee) {
                this.generatePBNExpression(n, modelFileName, perturbation, type, maxFunction, maxVariable, minFunction, minVariable, distributionFile);
            } else if (gef) {
                this.generatePBNfromFile(parameterFileName, type, outputName);
            } else if (io) {
                this.runPBNIO(modelFileName, isMatlab, outputName, type);
            } else if (gauss) {
                this.runGauss(modelFileName, isMatlab, propertyName, precision, maxIteration);
            } else if (jacobi) {
                this.runJacobi(modelFileName, isMatlab, propertyName, precision, maxIteration);
            } else if (ps) {
                this.runStepPerfectSimulation(modelFileName, isMatlab, propertyName, confidence, precision, outputName, true, cost);
            } else if (ts) {
                this.runTwoStateBitSet(precision, confidence, modelFileName, propertyName, isMatlab, outputName, globalAlias);
            } else if (skart) {
                this.runSkartPBN(precision, confidence, modelFileName, propertyName, isMatlab, outputName, globalAlias);
            } else if (skartLarge) {
                this.runSkartPBNLarge(precision, confidence, modelFileName, propertyName, isMatlab, outputName, globalAlias);
            } else if (help) {
                this.showhelp();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runGauss(String modelFileName, boolean isMatlab, String property, double precision, int maxIteration) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(modelFileName, isMatlab);
        System.out.println("Performing the Gauss-Seidel method on the PBN from file " + modelFileName);
        GaussSeidel gauss = new GaussSeidel(pbn);
        if (maxIteration > 0) {
            gauss.setPrecsion(precision);
            gauss.setMaxIteration(maxIteration);
        }
        gauss.setProperty(property);
        gauss.run();
    }

    public void runJacobi(String modelFileName, boolean isMatlab, String property, double precision, int maxIteration) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN(modelFileName, isMatlab);
        System.out.println("Performing the Jacobi method on the PBN from file " + modelFileName);
        Jacob jacob = new Jacob(pbn);
        if (maxIteration > 0) {
            jacob.setPrecsion(precision);
            jacob.setMaxIteration(maxIteration);
        }
        jacob.setProperty(property);
        jacob.run();
    }

    public void showhelp() {
        System.out.println("-ge <number of node> <perturbation rate> <export file name> <export type> [<max function number> <min function number><max parents node><min parents node>]");
        System.out.println("Generate a PBN and export to a file in ASSA format or Matlab format.\n");
        System.out.println("-gef <parameter file name> <export file name> <export type>");
        System.out.println("Generate a PBN with given parameters in a file.\n");
        System.out.println("-io <import file name> <isMatlab> <export file name> <export type> ");
        System.out.println("Load a PBN from a file and export to a file in ASSA format or Matlab format.\n");
        System.out.println("-gauss <model file name>  [isMatlab] <property file name> [<precision> <max iteration>]");
        System.out.println("Perform the Gauss-Seidel method\n");
        System.out.println("-jacobi <model file name> [isMatlab]  <property file name> [<precision> <max iteration>]");
        System.out.println("Perform the Jacobi method.\n");
        System.out.println("-ps <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] [useCost]");
        System.out.println("Perform the perfect simulation approach. If the model file is exported from Matlab, please add true after the model file name.\n");
        System.out.println("-ts <model file name> [isMatlab] <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] [useGlobalAlias]");
        System.out.println("Perform the two-state Markov chain approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command\n");
        System.out.println("-tspa <model file name> [isMatlab] <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] <number of chains>");
        System.out.println("Perform the multi CPU cores parallel two-state Markov chain approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        System.out.println("-tspam <model file name> [isMatlab] <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] <number of chains>");
        System.out.println("Perform the multi CPU cores parallel two-state Markov chain approach for checking multiple properties at the same time. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        System.out.println("-skart <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] [useGlobalAlias]");
        System.out.println("Perform the fast version Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        System.out.println("-skartfull <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>]  [useGlobalAlias]");
        System.out.println("Perform the full version Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        System.out.println("-skartpa <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] <number of chains>");
        System.out.println("Perform the multi CPU core parallel Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        System.out.println("-v");
        System.out.println("Show version information.");
        System.out.println("-h");
        System.out.println("Show this help information.");
        System.out.println("");
        System.out.println("");
    }

    public static void main(String[] args) {
        Assa assa = new Assa();
        try {
            assa.run(args);
        }
        catch (Exception e) {
            System.out.println("Incorrect parameters! Type -h to show help.");
            System.out.println("Erorr information:\n" + e);
        }
    }
}

