/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import PBN.BitSetPBNIO;
import PBN.ContextEngine;
import PBN.ContextPBN;
import PBN.StateBit;
import functionLib.Parameters;
import java.util.ArrayList;
import simulationMethod.TwoStateBitSet;
import simulator.RandomNumberGenerator;

public class Test {
    public ContextPBN defineContextPBN(int n, double perturbation) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = n >= 20 ? 20 : n;
        System.out.println("Max number of functions and max number of parent nodes are set to " + maxVariableNum);
        ContextPBN pbn = new ContextPBN(n);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        pbn.generateRandomContextPBN(nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public void simulate(int steps) throws Exception {
        ContextPBN pbn = this.defineContextPBN(3, 0.01);
        ContextEngine engine = new ContextEngine(pbn);
        StateBit st = new StateBit(pbn.getStateLength());
        int i = 0;
        while (i < steps) {
            engine.pbnNextState(st);
            int j = 0;
            while (j < st.getN()) {
                System.out.print(st.get(j) ? 1 : 0);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void runTwoStateBitSet(double precision, double confidence, String property, String outputName) throws Exception {
        TwoStateBitSet ts = new TwoStateBitSet(precision, confidence, Parameters.epsilon, 1);
        double average = 0.0;
        BitSetPBNIO io = new BitSetPBNIO();
        ContextPBN pbn = io.loadContextPBN("model/contextPBN_2.txt");
        if (outputName != null) {
            ts.setLogFile(outputName);
        } else {
            outputName = ts.getLogFile();
        }
        System.out.println("Detailed information is stored in the file " + outputName + ".");
        StateBit initialState = new StateBit(0);
        int sampleSize = 0;
        double cpuTime = 0.0;
        ts.setExpressions(property);
        double[] result = ts.run(pbn, initialState);
        System.out.println("Sample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCpu time cost\t" + (cpuTime += result[2]) + "s");
    }

    public static void main(String[] args) {
        Test test = new Test();
        try {
            test.runTwoStateBitSet(1.0E-4, 0.95, "model/property_6.txt", "outputName");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

