%% This file is for exporting PBN from Matalb to JAVA (ASSA-PBN) format.
% To Run this file, first generating PBN using the Matalb-PBN-toolbox.
function [ success ] = exportPBNtoASSA( exportName )

global n;
global nf;
global nv;
global F;
global varF;
global cij;
global p;
global npNode;

% open a file for writing
fid = fopen(exportName, 'w');

% print a title
fprintf(fid, '//This file is exported from MATLAB.\n');

% print n in integer 
fprintf(fid, '%d \n', round(n));

% print nf in integer

fprintf(fid, '%d \t',round(nf));
fprintf(fid,'\n');

% print nv in integer
fprintf(fid, '%d \t',round(nv));
fprintf(fid,'\n');

% print F in 1 or 0
for i=1:length(F(1,:))%each column
    for j=1:length(F(:,i))%each row
        if(F(j,i)~=-1)
            fprintf(fid, '%d \t',round(F(j,i)));
        else
            break;
        end
    end
    fprintf(fid,'\n');
end 

% print varF in integer
for i=1:length(varF)%each column
    for j=1:length(varF(:,i))%each row
        if(varF(j,i)~=-1)
            fprintf(fid, '%d \t',round(varF(j,i)-1));%the variable index starts from 0 in java
        else
            break;
        end
    end
    fprintf(fid,'\n');
end 

% print cij in double
for i=1:length(cij(1,:))%each column
    for j=1:length(cij(:,i))%each row
        if(cij(j,i)~=-1)
            fprintf(fid, '%16.15f \t',cij(j,i));
        else
            break;
        end
    end
    fprintf(fid,'\n');
end
% print p
fprintf(fid, '%16.15f \t',p);

fprintf(fid,'\n // nodes index without perturbation\n');

for i=1:length(npNode)
    fprintf(fid, '%d \t',npNode(i)-1); %the variable index starts from 0 in java
end

fclose(fid);
success=1;

end

