/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.preferences;

import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import lu.uni.minus.preferences.DataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private static Preferences prefs;

    public Settings() {
        try {
            prefs = Preferences.userNodeForPackage(Settings.class);
            if (!prefs.getBoolean("settings saved", false)) {
                this.setDefault();
            }
        }
        catch (SecurityException e) {
            System.err.println("Security exception:");
            e.printStackTrace();
        }
    }

    public void setDefault() {
        prefs.putBoolean("settings saved", true);
        ArrayList<DataSet> ds = new ArrayList<DataSet>();
        this.saveDataSets(ds);
        this.setShowExit(true);
    }

    public boolean getShowExit() {
        return prefs.getBoolean("show exit dialog", true);
    }

    public void setShowExit(boolean swith) {
        prefs.putBoolean("show exit dialog", swith);
    }

    public ArrayList<DataSet> getDatasets() {
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        int n = prefs.getInt("no datasets", 0);
        int i = 0;
        while (i < n) {
            String id = "ds" + new Integer(i).toString();
            result.add(new DataSet(prefs.get(String.valueOf(id) + " name", "empty"), prefs.get(String.valueOf(id) + " type", "GPS"), prefs.get(String.valueOf(id) + " inPath", "empty"), prefs.get(String.valueOf(id) + " outPath", "empty")));
            ++i;
        }
        return result;
    }

    public void saveDataSets(ArrayList<DataSet> ds) {
        int n = prefs.getInt("no datasets", 0);
        prefs.putInt("no datasets", ds.size());
        while (n >= ds.size()) {
            String id = "ds" + new Integer(n).toString();
            prefs.remove(String.valueOf(id) + " name");
            prefs.remove(String.valueOf(id) + " type");
            prefs.remove(String.valueOf(id) + " inPath");
            prefs.remove(String.valueOf(id) + " outPath");
            --n;
        }
        int i = 0;
        for (DataSet aDs : ds) {
            this.storeDataset(aDs, i);
            ++i;
        }
    }

    public void replaceDataset(String oldName, DataSet ds) {
        int n = prefs.getInt("no datasets", 0);
        int i = 0;
        while (i < n) {
            String id = "ds" + new Integer(i).toString();
            String str = prefs.get(String.valueOf(id) + " name", "");
            if (oldName.equalsIgnoreCase(str)) {
                this.storeDataset(ds, i);
                return;
            }
            ++i;
        }
    }

    public void addDataSet(DataSet ds) {
        int n = prefs.getInt("no datasets", 0);
        prefs.putInt("no datasets", n + 1);
        this.storeDataset(ds, n);
    }

    public void removeDataSet(DataSet ds) {
        ArrayList<DataSet> ar = this.getDatasets();
        ar.remove(ds);
        this.saveDataSets(ar);
    }

    public void clearPreferences() {
        try {
            prefs.removeNode();
            prefs.flush();
            prefs = Preferences.userNodeForPackage(Settings.class);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private void storeDataset(DataSet ds, int i) {
        String id = "ds" + new Integer(i).toString();
        prefs.put(String.valueOf(id) + " name", ds.getName());
        prefs.put(String.valueOf(id) + " type", ds.getType().name());
        prefs.put(String.valueOf(id) + " inPath", ds.getInputPath().toString());
        prefs.put(String.valueOf(id) + " outPath", ds.getOutputPath().toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

