/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.Announcer;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.ui.WideJComboBox;
import lu.uni.minus.utils.PSExtractor;

public class ExtractFPSPanel
extends JPanel
implements Announcer {
    private static final long serialVersionUID = -1406202306902077691L;
    private final MainWindow mw;
    private final Dimension space = new Dimension(6, 6);
    private JTextField tfThreshold;
    private JTextField tfSidelength;
    private JTextField tfTolerance;
    public JButton btnStart;
    private JTextPane messageArea;
    private HTMLEditorKit kit;
    private HTMLDocument doc;
    private DataSet dataset;
    private String selectedSP;
    private final ButtonGroup buttonGroup = new ButtonGroup();

    public ExtractFPSPanel(MainWindow aMw, DataSet aDataset) {
        this.mw = aMw;
        this.dataset = aDataset;
        this.createGui();
    }

    private void createGui() {
        JSplitPane splitPane = new JSplitPane();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)splitPane, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        titlePanel.setBorder(new TitledBorder(null, "Parameters for extracting frequent pattern sets", 4, 2, null, null));
        JPanel subtitlePanel = new JPanel();
        subtitlePanel.setLayout(new BoxLayout(subtitlePanel, 0));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.setMaximumSize(new Dimension(250, 100));
        leftPanel.add(this.createLabelPanel("Support threshold :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel("Side length of cell :"));
        leftPanel.add(Box.createRigidArea(this.space));
        subtitlePanel.add(leftPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.setMaximumSize(new Dimension(250, 100));
        Dimension fieldSize = new Dimension(100, 20);
        this.tfThreshold = new JTextField("0.1");
        this.tfThreshold.setPreferredSize(fieldSize);
        this.tfThreshold.setMaximumSize(fieldSize);
        this.tfThreshold.setToolTipText("<html>\r\nIt specifies the minimum percentage of trajectories that support a specific pattern \r\n<br/>\r\nfor it to be a frequent pattern. \r\n<br/>\r\nIt should be between 0 and 1. A typical value is 0.1.\r\n<html/>");
        this.tfSidelength = new JTextField("0.02");
        this.tfSidelength.setPreferredSize(fieldSize);
        this.tfSidelength.setMaximumSize(fieldSize);
        this.tfSidelength.setToolTipText("<html>\r\nIt refers to the span of latitudes or longitudes a cell covers. \r\n<br/>\r\na cell is a terminology used in course of trajectory pattern mining.\r\n<br/>\r\nA typical value is 0.02.\r\n<html/>");
        rightPanel.add(this.createComponentPanel(this.tfThreshold, " "));
        rightPanel.add(this.createComponentPanel(this.tfSidelength, " "));
        subtitlePanel.add(rightPanel);
        JPanel leftPanel2 = new JPanel();
        leftPanel2.setLayout(new BoxLayout(leftPanel2, 1));
        leftPanel2.setMaximumSize(new Dimension(250, 100));
        leftPanel2.add(this.createLabelPanel("Time tolerance :"));
        leftPanel2.add(Box.createRigidArea(this.space));
        subtitlePanel.add(leftPanel2);
        JPanel rightPanel2 = new JPanel();
        rightPanel2.setLayout(new BoxLayout(rightPanel2, 1));
        this.tfTolerance = new JTextField("7200");
        this.tfTolerance.setPreferredSize(fieldSize);
        this.tfTolerance.setMaximumSize(fieldSize);
        this.tfTolerance.setToolTipText("<html>\r\nIt is the maximum allowed time length that a time length between two RoIs in a \r\n<br/>\r\npattern can differ from a time length between two points in a trajectory in order to \r\n<br/>\r\nlet the trajectory contain the pattern. A typical value is 7200.\r\n<html/>");
        rightPanel2.add(this.createComponentPanel(this.tfTolerance, " s"));
        final WideJComboBox<String> comboRoI = new WideJComboBox<String>();
        rightPanel2.add(this.createComponentPanel(comboRoI, " "));
        comboRoI.setMaximumSize(new Dimension(200, 25));
        comboRoI.setPrototypeDisplayValue("MMMMMMMMMMMM");
        final JList<String> usersList = new JList<String>();
        subtitlePanel.add(rightPanel2);
        subtitlePanel.add(Box.createHorizontalGlue());
        titlePanel.add(subtitlePanel);
        JPanel daysPanel = new JPanel();
        daysPanel.setLayout(new BoxLayout(daysPanel, 0));
        daysPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Type of days taken into account", 4, 2, null, null));
        daysPanel.add(Box.createHorizontalGlue());
        final JRadioButton rdbtnAllDays = new JRadioButton("All days");
        this.buttonGroup.add(rdbtnAllDays);
        daysPanel.add(rdbtnAllDays);
        final JRadioButton rdbtnWeekdays = new JRadioButton("Weekdays");
        this.buttonGroup.add(rdbtnWeekdays);
        daysPanel.add(rdbtnWeekdays);
        final JRadioButton rdbtnWeekends = new JRadioButton("Weekends");
        this.buttonGroup.add(rdbtnWeekends);
        rdbtnAllDays.setSelected(true);
        daysPanel.add(rdbtnWeekends);
        daysPanel.add(Box.createHorizontalGlue());
        titlePanel.add(daysPanel);
        mainPanel.add(titlePanel);
        JScrollPane scrollMessage = new JScrollPane();
        this.messageArea = new JTextPane();
        this.messageArea.setPreferredSize(new Dimension(300, 200));
        this.messageArea.setContentType("text/html");
        this.messageArea.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.messageArea.setEditorKit(this.kit);
        this.doc = new HTMLDocument();
        this.messageArea.setDocument(this.doc);
        scrollMessage.setViewportView(this.messageArea);
        mainPanel.add(scrollMessage);
        splitPane.setRightComponent(mainPanel);
        JPanel usersPanel = new JPanel();
        usersPanel.setBorder(null);
        usersPanel.setLayout(new BoxLayout(usersPanel, 1));
        JScrollPane scrollPane = new JScrollPane();
        this.selectedSP = null;
        if (this.dataset.getType() == DataSet.Type.GPS) {
            usersPanel.add(new JLabel("Generated RoIs"));
            DefaultComboBoxModel<String> cModel = new DefaultComboBoxModel<String>(this.dataset.getSPList());
            final JComboBox<String> comboBox = new JComboBox<String>(cModel);
            comboBox.setMaximumSize(new Dimension(200, 25));
            comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExtractFPSPanel.this.selectedSP = (String)comboBox.getSelectedItem();
                    if (ExtractFPSPanel.this.selectedSP != null) {
                        String[] roiFiles = ExtractFPSPanel.this.dataset.getRoiList();
                        HashSet<String> usersInRoIFilesUnderThePara = new HashSet<String>();
                        String[] stringArray = roiFiles;
                        int n = roiFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] usersInTheRoIFile;
                            String anRoIFile = stringArray[n2];
                            String[] fields = anRoIFile.split("-");
                            String[] stringArray2 = usersInTheRoIFile = fields[0].split("_");
                            int n3 = usersInTheRoIFile.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String aUser = stringArray2[n4];
                                usersInRoIFilesUnderThePara.add(aUser);
                                ++n4;
                            }
                            ++n2;
                        }
                        usersList.setListData(usersInRoIFilesUnderThePara.toArray(new String[0]));
                    }
                }
            });
            usersPanel.add(comboBox);
            this.selectedSP = (String)comboBox.getSelectedItem();
            if (this.selectedSP != null) {
                usersList.setListData(this.dataset.getSPUsers(this.selectedSP));
            }
            comboRoI.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent arg0) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                    String[] roiFiles;
                    List selectedList = usersList.getSelectedValuesList();
                    if (selectedList.size() == 0) {
                        return;
                    }
                    ArrayList<String> usableRoIFiles = new ArrayList<String>();
                    ExtractFPSPanel.this.selectedSP = (String)comboBox.getSelectedItem();
                    HashSet selectedUsersSet = new HashSet(selectedList);
                    String[] stringArray = roiFiles = ExtractFPSPanel.this.dataset.createRoIDir(ExtractFPSPanel.this.selectedSP).list();
                    int n = roiFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String aFile = stringArray[n2];
                        String[] fields = aFile.split("-");
                        String[] users = fields[0].split("_");
                        HashSet<String> usersAnRoI = new HashSet<String>();
                        String[] stringArray2 = users;
                        int n3 = users.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String aUser = stringArray2[n4];
                            usersAnRoI.add(aUser);
                            ++n4;
                        }
                        if (usersAnRoI.containsAll(selectedUsersSet)) {
                            usableRoIFiles.add(aFile);
                        }
                        ++n2;
                    }
                    comboRoI.removeAllItems();
                    for (String aUsableRoIFile : usableRoIFiles) {
                        comboRoI.addItem(aUsableRoIFile);
                    }
                    comboRoI.setWide(true);
                }
            });
        } else {
            usersList.setListData(this.dataset.getUserList());
        }
        usersPanel.add(new JLabel("User list:"));
        usersPanel.add(scrollPane);
        scrollPane.setViewportView(usersList);
        usersPanel.setPreferredSize(new Dimension(100, 500));
        splitPane.setLeftComponent(usersPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createRigidArea(this.space));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalGlue());
        this.btnStart = new JButton("Start");
        final ExtractFPSPanel me = this;
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                byte selected;
                ExtractFPSPanel.this.messageArea.setText("");
                List selectedList = usersList.getSelectedValuesList();
                if (selectedList.size() == 0) {
                    JOptionPane.showMessageDialog(null, "Please first choose some users.", "Choose users", 1);
                    return;
                }
                String selectedRoIFile = (String)comboRoI.getSelectedItem();
                if (selectedRoIFile == null) {
                    JOptionPane.showMessageDialog(null, "You haven't chosen an RoI file yet.", "Choose an RoI file", 1);
                    return;
                }
                double threshold = Double.parseDouble(ExtractFPSPanel.this.tfThreshold.getText().trim());
                double tolerance = Double.parseDouble(ExtractFPSPanel.this.tfTolerance.getText().trim());
                double side = Double.parseDouble(ExtractFPSPanel.this.tfSidelength.getText().trim());
                if (threshold < 0.0 || threshold > 1.0) {
                    JOptionPane.showMessageDialog(null, "The support threshold you entered is not between 0 and 1.", "Input error", 0);
                    return;
                }
                if (tolerance < 0.0) {
                    JOptionPane.showMessageDialog(null, "The time tolerance you entered is not non-negative.", "Input error", 0);
                    return;
                }
                if (side <= 0.0) {
                    JOptionPane.showMessageDialog(null, "The time tolerance you entered is not positive.", "Input error", 0);
                    return;
                }
                byte by = rdbtnAllDays.isSelected() ? (byte)-1 : (rdbtnWeekdays.isSelected() ? (byte)1 : (selected = rdbtnWeekends.isSelected() ? (byte)0 : -2));
                if (selected == -2) {
                    JOptionPane.showMessageDialog(null, "Please first choose a type of days.", "Choose a type of days", 0);
                    return;
                }
                File fpsDir = ExtractFPSPanel.this.dataset.getFPSDir(selected, ExtractFPSPanel.this.selectedSP, selectedRoIFile, threshold, tolerance, side);
                ArrayList<String> filteredList = new ArrayList<String>(selectedList);
                if (fpsDir.exists()) {
                    Object[] filenamesPS = fpsDir.list();
                    int i = 0;
                    while (i < filenamesPS.length) {
                        filenamesPS[i] = ((String)filenamesPS[i]).substring(0, 3);
                        ++i;
                    }
                    Arrays.sort(filenamesPS);
                    for (String anSelectedUser : selectedList) {
                        if (Arrays.binarySearch(filenamesPS, anSelectedUser) < 0) continue;
                        filteredList.remove(anSelectedUser);
                    }
                }
                if (filteredList.size() == 0) {
                    JOptionPane.showMessageDialog(null, "All the users you selected have already been extracted from.\nNo more work needs to be done.", "Duplicate operation", 1);
                    return;
                }
                ExtractFPSPanel.this.btnStart.setEnabled(false);
                PSExtractor worker = null;
                worker = new PSExtractor(ExtractFPSPanel.this.dataset, me, filteredList, threshold, tolerance, side, selectedRoIFile, selected, ExtractFPSPanel.this.selectedSP, fpsDir);
                Thread t = new Thread(worker);
                t.setPriority(10);
                t.start();
            }
        });
        buttonPanel.add(this.btnStart);
        buttonPanel.add(Box.createRigidArea(this.space));
        buttonPanel.add(Box.createRigidArea(this.space));
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtractFPSPanel.this.mw.goHome();
            }
        });
        buttonPanel.add(btnClose);
        mainPanel.add(buttonPanel);
        usersList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                String[] roiFiles;
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                List selectedList = usersList.getSelectedValuesList();
                if (selectedList.size() == 0) {
                    return;
                }
                ArrayList<String> usableRoIFiles = new ArrayList<String>();
                HashSet selectedUsersSet = new HashSet(selectedList);
                String[] stringArray = roiFiles = ExtractFPSPanel.this.dataset.createRoIDir(ExtractFPSPanel.this.selectedSP).list();
                int n = roiFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String aFile = stringArray[n2];
                    String[] fields = aFile.split("-");
                    String[] users = fields[0].split("_");
                    HashSet<String> usersAnRoI = new HashSet<String>();
                    String[] stringArray2 = users;
                    int n3 = users.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String aUser = stringArray2[n4];
                        usersAnRoI.add(aUser);
                        ++n4;
                    }
                    if (usersAnRoI.containsAll(selectedUsersSet)) {
                        usableRoIFiles.add(aFile);
                    }
                    ++n2;
                }
                comboRoI.removeAllItems();
                for (String aUsableRoIFile : usableRoIFiles) {
                    comboRoI.addItem(aUsableRoIFile);
                }
                ExtractFPSPanel.this.btnStart.setEnabled(usableRoIFiles.size() > 0);
                comboRoI.setWide(true);
            }
        });
    }

    private JPanel createLabelPanel(String text) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.add(Box.createHorizontalGlue());
        result.add(Box.createRigidArea(this.space));
        result.add(new JLabel(text));
        result.add(Box.createRigidArea(this.space));
        return result;
    }

    private JPanel createComponentPanel(JComponent component, String text) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.add(Box.createRigidArea(this.space));
        result.add(component);
        result.add(new JLabel(text));
        result.add(Box.createHorizontalGlue());
        return result;
    }

    public void addMessage(String html) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), html, 0, 0, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

