/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.Announcer;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.utils.TextPaneWorker;
import lu.uni.minus.utils.roi.SPClusteringWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateRoIPanel
extends JPanel
implements Announcer {
    private static final long serialVersionUID = 8744363387885045523L;
    private final MainWindow mw;
    private final Dimension space = new Dimension(6, 6);
    private JTextField tfPercentage;
    private JTextField tfLowerK;
    private JTextField tfUpperK;
    private JButton btnStart;
    private JButton btnCancel;
    private Action cancelAction;
    private JTextPane messageArea;
    private JProgressBar progressBar;
    private TextPaneWorker worker;
    private HTMLEditorKit kit;
    private HTMLDocument doc;
    private DataSet dataset;
    private String selectedSP;

    public GenerateRoIPanel(MainWindow aMw, DataSet aDataset) {
        this.mw = aMw;
        this.dataset = aDataset;
        this.createGui();
    }

    private void createGui() {
        JSplitPane splitPane = new JSplitPane();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)splitPane, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.setBorder(new TitledBorder(null, "Parameters for generating RoIs", 4, 2, null, null));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.setMaximumSize(new Dimension(250, 100));
        leftPanel.add(this.createLabelPanel("Deletion percentage :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel("Lower bound of K :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel("Upper bound of K :"));
        leftPanel.add(Box.createRigidArea(this.space));
        titlePanel.add(leftPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        Dimension fieldSize = new Dimension(100, 20);
        this.tfPercentage = new JTextField("25");
        this.tfPercentage.setPreferredSize(fieldSize);
        this.tfPercentage.setMaximumSize(fieldSize);
        this.tfPercentage.setToolTipText("<html>\r\nIt specifies the percentage of stay points to constitute noise and be removed.\r\n<br/>\r\nA typical value is 20 or 30.\r\n<html/>");
        this.tfLowerK = new JTextField("5");
        this.tfLowerK.setPreferredSize(fieldSize);
        this.tfLowerK.setMaximumSize(fieldSize);
        this.tfLowerK.setToolTipText("<html>\r\nK is a parameter used when removing outliers. Typical bounds are 5 and 35 \r\n<br/>\r\nwhen the number of stay points to be clustered is less than 1000, 10 and 50 when\r\n<br/>\r\nthe number is between 1000 and 3000, 20 and 100 when the number is more than\r\n<br/>\r\n3000. But these are not necessarily applicable. Different sets of stay points may\r\n<br/>\r\nrequire different bounds of K.\r\n<html/>\r\n\r\n");
        this.tfUpperK = new JTextField("35");
        this.tfUpperK.setPreferredSize(fieldSize);
        this.tfUpperK.setMaximumSize(fieldSize);
        this.tfUpperK.setToolTipText("<html>\r\nK is a parameter used when removing outliers. Typical bounds are 5 and 35 \r\n<br/>\r\nwhen the number of stay points to be clustered is less than 1000, 10 and 50 when\r\n<br/>\r\nthe number is between 1000 and 3000, 20 and 100 when the number is more than\r\n<br/>\r\n3000. But these are not necessarily applicable. Different sets of stay points may\r\n<br/>\r\nrequire different bounds of K.\r\n<html/>");
        rightPanel.add(this.createComponentPanel(this.tfPercentage, " %"));
        rightPanel.add(this.createComponentPanel(this.tfLowerK, " "));
        rightPanel.add(this.createComponentPanel(this.tfUpperK, " "));
        titlePanel.add(rightPanel);
        titlePanel.add(Box.createHorizontalGlue());
        mainPanel.add(titlePanel);
        JScrollPane scrollMessage = new JScrollPane();
        this.messageArea = new JTextPane();
        this.messageArea.setPreferredSize(new Dimension(300, 200));
        this.messageArea.setContentType("text/html");
        this.messageArea.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.messageArea.setEditorKit(this.kit);
        this.doc = new HTMLDocument();
        this.messageArea.setDocument(this.doc);
        scrollMessage.setViewportView(this.messageArea);
        mainPanel.add(scrollMessage);
        splitPane.setRightComponent(mainPanel);
        JPanel usersPanel = new JPanel();
        usersPanel.setBorder(null);
        usersPanel.setLayout(new BoxLayout(usersPanel, 1));
        final JList<String> usersList = new JList<String>();
        JScrollPane scrollPane = new JScrollPane();
        this.selectedSP = null;
        if (this.dataset.getType() == DataSet.Type.GPS) {
            usersPanel.add(new JLabel("Stay point paras"));
            DefaultComboBoxModel<String> cModel = new DefaultComboBoxModel<String>(this.dataset.getSPList());
            final JComboBox<String> comboBox = new JComboBox<String>(cModel);
            comboBox.setMaximumSize(new Dimension(200, 25));
            comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenerateRoIPanel.this.selectedSP = (String)comboBox.getSelectedItem();
                    if (GenerateRoIPanel.this.selectedSP != null) {
                        usersList.setListData(GenerateRoIPanel.this.dataset.getSPUsers(GenerateRoIPanel.this.selectedSP));
                    }
                }
            });
            usersPanel.add(comboBox);
            this.selectedSP = (String)comboBox.getSelectedItem();
            if (this.selectedSP != null) {
                usersList.setListData(this.dataset.getSPUsers(this.selectedSP));
            }
        } else {
            usersList.setListData(this.dataset.getUserList());
        }
        usersPanel.add(new JLabel("User list:"));
        usersPanel.add(scrollPane);
        scrollPane.setViewportView(usersList);
        usersPanel.setPreferredSize(new Dimension(100, 500));
        splitPane.setLeftComponent(usersPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createRigidArea(this.space));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        this.progressBar.setPreferredSize(new Dimension(800, 20));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.progressBar);
        buttonPanel.add(Box.createHorizontalGlue());
        this.btnStart = new JButton("Start");
        final GenerateRoIPanel me = this;
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ans;
                GenerateRoIPanel.this.messageArea.setText("");
                List<String> selectedList = usersList.getSelectedValuesList();
                if (selectedList.size() == 0) {
                    JOptionPane.showMessageDialog(null, "Please first choose some users.", "Choose users", 1);
                    return;
                }
                int percentage = Integer.parseInt(GenerateRoIPanel.this.tfPercentage.getText().trim());
                int lowerK = Integer.parseInt(GenerateRoIPanel.this.tfLowerK.getText().trim());
                int upperK = Integer.parseInt(GenerateRoIPanel.this.tfUpperK.getText().trim());
                if (percentage <= 0 || lowerK <= 0 || upperK <= 0 || percentage > 100) {
                    JOptionPane.showMessageDialog(null, "The three parameters must be positive integers and percentage must be lower that 100.", "Number format error", 0);
                    return;
                }
                if (upperK <= lowerK) {
                    JOptionPane.showMessageDialog(null, "The upper bound of K you entered is not greater than the lower bound.", "Input error", 0);
                    return;
                }
                String msg = GenerateRoIPanel.this.getPopupMsg(selectedList, percentage, lowerK, upperK);
                if (msg != null && (ans = JOptionPane.showConfirmDialog(GenerateRoIPanel.this, msg, "Confirmation", 0)) == 1) {
                    return;
                }
                GenerateRoIPanel.this.btnStart.setEnabled(false);
                GenerateRoIPanel.this.btnCancel.setEnabled(true);
                GenerateRoIPanel.this.progressBar.setVisible(true);
                GenerateRoIPanel.this.worker = new SPClusteringWorker(GenerateRoIPanel.this.dataset, selectedList, percentage, lowerK, upperK, GenerateRoIPanel.this.selectedSP);
                GenerateRoIPanel.this.worker.setAnnouncer(me);
                GenerateRoIPanel.this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("progress")) {
                            GenerateRoIPanel.this.progressBar.setIndeterminate(false);
                            GenerateRoIPanel.this.progressBar.setValue((Integer)event.getNewValue());
                        } else if (event.getPropertyName().equals("state")) {
                            switch ((SwingWorker.StateValue)((Object)event.getNewValue())) {
                                case DONE: {
                                    try {
                                        Integer result = (Integer)GenerateRoIPanel.this.worker.get();
                                        if (result != 0) {
                                            GenerateRoIPanel.this.progressBar.setValue(0);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    GenerateRoIPanel.this.btnStart.setEnabled(true);
                                    GenerateRoIPanel.this.btnCancel.setEnabled(false);
                                    break;
                                }
                                case PENDING: 
                                case STARTED: {
                                    GenerateRoIPanel.this.progressBar.setIndeterminate(true);
                                }
                            }
                        }
                    }
                });
                GenerateRoIPanel.this.worker.execute();
            }
        });
        buttonPanel.add(this.btnStart);
        buttonPanel.add(Box.createRigidArea(this.space));
        this.cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 7666652133260327969L;

            public void actionPerformed(ActionEvent e) {
                GenerateRoIPanel.this.worker.cancel(true);
            }
        };
        this.btnCancel = new JButton(this.cancelAction);
        this.btnCancel.setEnabled(false);
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(Box.createRigidArea(this.space));
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GenerateRoIPanel.this.mw.goHome();
            }
        });
        buttonPanel.add(btnClose);
        mainPanel.add(buttonPanel);
    }

    private JPanel createLabelPanel(String text) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.add(Box.createHorizontalGlue());
        result.add(Box.createRigidArea(this.space));
        result.add(new JLabel(text));
        result.add(Box.createRigidArea(this.space));
        return result;
    }

    private JPanel createComponentPanel(JComponent component, String text) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.add(Box.createRigidArea(this.space));
        result.add(component);
        result.add(new JLabel(text));
        result.add(Box.createHorizontalGlue());
        return result;
    }

    private String getPopupMsg(List<String> selectedList, int percentage, int lowerK, int upperK) {
        int popupMessageDecision = 0;
        if (this.dataset.getType() == DataSet.Type.GPS) {
            File theParaRoISubfoler;
            File RoIFolder = new File(this.dataset.getOutputPath() + File.separator + "RoIs");
            if (RoIFolder.exists() && (theParaRoISubfoler = new File(RoIFolder + "/" + this.selectedSP)).exists()) {
                String[] RoIFiles;
                HashSet<String> selectedUsers = new HashSet<String>(selectedList);
                String[] stringArray = RoIFiles = theParaRoISubfoler.list();
                int n = RoIFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String aFile = stringArray[n2];
                    String[] fields = aFile.split("-");
                    String[] theUsers = fields[0].split("_");
                    HashSet<String> usersAnRoIFile = new HashSet<String>();
                    String[] stringArray2 = theUsers;
                    int n3 = theUsers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String aUser = stringArray2[n4];
                        usersAnRoIFile.add(aUser);
                        ++n4;
                    }
                    if (usersAnRoIFile.equals(selectedUsers)) {
                        if (fields[1].equals(String.valueOf(percentage) + "_" + lowerK + "_" + upperK + ".txt")) {
                            popupMessageDecision = 1;
                        } else if (popupMessageDecision != 1) {
                            popupMessageDecision = 2;
                        }
                    }
                    if (usersAnRoIFile.containsAll(selectedUsers) && popupMessageDecision != 1 && popupMessageDecision != 2) {
                        popupMessageDecision = 3;
                    }
                    ++n2;
                }
            }
        } else {
            HashSet<String> selectedUsers = new HashSet<String>(selectedList);
            File RoIFolder = new File(this.dataset.getOutputPath() + File.separator + "RoIs");
            if (RoIFolder.exists()) {
                String[] RoIFiles;
                String[] stringArray = RoIFiles = RoIFolder.list();
                int n = RoIFiles.length;
                int n5 = 0;
                while (n5 < n) {
                    String aFile = stringArray[n5];
                    String[] fields = aFile.split("-");
                    String[] users = fields[0].split("_");
                    HashSet<String> usersAnRoIFile = new HashSet<String>();
                    String[] stringArray3 = users;
                    int n6 = users.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String aUser = stringArray3[n7];
                        usersAnRoIFile.add(aUser);
                        ++n7;
                    }
                    if (usersAnRoIFile.equals(selectedUsers)) {
                        if (fields[1].equals(String.valueOf(percentage) + "_" + lowerK + "_" + upperK + ".txt")) {
                            popupMessageDecision = 1;
                        } else if (popupMessageDecision != 1) {
                            popupMessageDecision = 2;
                        }
                    }
                    if (usersAnRoIFile.containsAll(selectedUsers) && popupMessageDecision != 1 && popupMessageDecision != 2) {
                        popupMessageDecision = 3;
                    }
                    ++n5;
                }
            }
        }
        if (popupMessageDecision == 1) {
            return "You have generated the RoI file of these selected users using these parameters.\nDo you want to do it again?";
        }
        if (popupMessageDecision == 2) {
            return "You have generated the RoI file of these selected users using a different parameter setting.\nDo you want to do it using the current parameter setting?";
        }
        if (popupMessageDecision == 3) {
            return "You have generated an RoI file whose users include these selected users.\nDo you want to continue generating their RoI file?";
        }
        return null;
    }

    @Override
    public void addMessage(String html) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), html, 0, 0, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

