/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.AboutDialog;
import lu.uni.minus.ui.AddDSPane;
import lu.uni.minus.ui.CompareUsersPanel;
import lu.uni.minus.ui.DataFlowPane;
import lu.uni.minus.ui.DetectSPPanel;
import lu.uni.minus.ui.EditDSPanel;
import lu.uni.minus.ui.ExtractFPSPanel;
import lu.uni.minus.ui.GenerateRoIPanel;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.ui.ManageDistFilesPanel;
import lu.uni.minus.ui.StatDSPanel;
import lu.uni.minus.ui.ViewUserPanel;
import lu.uni.minus.ui.VisualisePanel;
import lu.uni.minus.ui.epub.EpubViewer;
import lu.uni.minus.utils.ProcessRunner;
import org.apache.commons.io.FileUtils;

public class MainMenu
extends JMenuBar {
    private static final long serialVersionUID = -6736607039942971939L;
    private static ADAction fileAdd;
    private static ADAction fileEdit;
    private static ADAction fileDelete;
    private static ADAction fileViewData;
    private static ADAction fileViewUser;
    private static ADAction fileReset;
    private static ADAction fileExit;
    private static ADAction profileSP;
    private static ADAction profileRoI;
    private static ADAction profileFPS;
    private static ADAction profileVisualize;
    private static ADAction similarityCU;
    private static ADAction similarityMSF;
    private static ADAction helpManual;
    private static ADAction helpStartPage;
    private static ADAction helpAbout;
    private static MainWindow mw;
    private static JPanel manual;
    private static DataFlowPane background;

    static {
        manual = null;
        background = null;
    }

    public MainMenu(MainWindow aMw) {
        mw = aMw;
        background = new DataFlowPane();
        this.createActions();
        helpStartPage.actionPerformed(new ActionEvent(this, 1001, null));
        this.add(this.createFileMenu());
        this.add(this.createUserProfileMenu());
        this.add(this.createUserSimilMenu());
        this.add(this.createHelpMenu());
    }

    private void createActions() {
        fileAdd = new ADAction(this, "Add Dataset"){
            private static final long serialVersionUID = -618696261748903055L;

            public void actionPerformed(ActionEvent e) {
                AddDSPane addPane = new AddDSPane(mw);
                mw.setContent(addPane);
            }
        };
        fileAdd.setMnemonic(65);
        fileAdd.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        fileAdd.setToolTip("Add new DataSet");
        fileEdit = new ADAction(this, "Edit Dataset"){
            private static final long serialVersionUID = -7289253008537115308L;

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = this.getNode();
                if (node != null) {
                    EditDSPanel panel = new EditDSPanel(mw, node);
                    mw.setContent(panel);
                }
            }
        };
        fileEdit.setMnemonic(69);
        fileEdit.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        fileEdit.setToolTip("Edit DataSet output path");
        fileDelete = new ADAction(this, "Delete Dataset"){
            private static final long serialVersionUID = 6047147350467024375L;

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = this.getNode();
                if (node != null) {
                    DataSet dataset = (DataSet)node.getUserObject();
                    int ans = JOptionPane.showConfirmDialog(mw, "Delete also output directory:\"" + dataset.getOutputPath().toString() + "\" ?", "Confirm", 1);
                    if (ans != 2) {
                        DefaultTreeModel treeModel = (DefaultTreeModel)mw.getDataSetPane().getTree().getModel();
                        treeModel.removeNodeFromParent(node);
                        mw.getSettings().removeDataSet(dataset);
                        if (ans == 0) {
                            try {
                                FileUtils.deleteDirectory(dataset.getOutputPath());
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(mw, "An error deleting \"" + dataset.getOutputPath() + "\":" + ex.getMessage(), "Error", 0);
                                return;
                            }
                        }
                    }
                }
            }
        };
        fileDelete.setMnemonic(68);
        fileDelete.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        fileDelete.setToolTip("Delete DataSet");
        fileViewData = new ADAction(this, "View Dataset's Info"){
            private static final long serialVersionUID = -5761368747300826480L;

            public void actionPerformed(ActionEvent e) {
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    StatDSPanel panel = new StatDSPanel(mw, ds);
                    mw.setContent(panel);
                }
            }
        };
        fileViewData.setMnemonic(86);
        fileViewData.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        fileViewData.setToolTip("View Dataset's Info");
        fileViewUser = new ADAction(this, "View User Stats"){
            private static final long serialVersionUID = 9195585245323216127L;

            public void actionPerformed(ActionEvent e) {
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    ViewUserPanel panel = new ViewUserPanel(mw, ds);
                    mw.setContent(panel);
                }
            }
        };
        fileViewUser.setMnemonic(85);
        fileViewUser.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        fileViewUser.setToolTip("View User Stats");
        fileReset = new ADAction(this, "Reset Settings"){
            private static final long serialVersionUID = -1991063302215411335L;

            public void actionPerformed(ActionEvent e) {
                mw.getSettings().clearPreferences();
                mw.getSettings().setDefault();
            }
        };
        fileReset.setMnemonic(82);
        fileReset.setToolTip("Reset the settings of the program to the default values");
        fileExit = new ADAction(this, "Exit"){
            private static final long serialVersionUID = -6586817922511469697L;

            public void actionPerformed(ActionEvent e) {
                WindowEvent windowClosing = new WindowEvent(mw, 201);
                mw.dispatchEvent(windowClosing);
            }
        };
        fileExit.setMnemonic(88);
        fileExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        fileExit.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/exit.png")));
        profileSP = new ADAction(this, "Detect stay points"){
            private static final long serialVersionUID = -8654654165123569697L;

            public void actionPerformed(ActionEvent e) {
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    if (ds.getType() == DataSet.Type.GPS) {
                        DetectSPPanel panel = new DetectSPPanel(mw, ds);
                        mw.setContent(panel);
                    } else {
                        JOptionPane.showMessageDialog(mw, "We need to detect stay points only for GPS type of dataset.", "Wrong dataset", 1);
                    }
                }
            }
        };
        profileSP.setMnemonic(83);
        profileRoI = new ADAction(this, "Generate RoI"){
            private static final long serialVersionUID = -8122226658463666667L;

            public void actionPerformed(ActionEvent e) {
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    GenerateRoIPanel panel = new GenerateRoIPanel(mw, ds);
                    mw.setContent(panel);
                }
            }
        };
        profileRoI.setMnemonic(71);
        profileFPS = new ADAction(this, "Extract frequent pattern sets"){
            private static final long serialVersionUID = -1566545631658665457L;

            public void actionPerformed(ActionEvent e) {
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    ExtractFPSPanel panel = new ExtractFPSPanel(mw, ds);
                    mw.setContent(panel);
                }
            }
        };
        profileFPS.setMnemonic(69);
        profileVisualize = new ADAction(this, "Visualize"){
            private static final long serialVersionUID = -2350956653269249550L;

            public void actionPerformed(ActionEvent e) {
                if (!ProcessRunner.isWindows()) {
                    JOptionPane.showMessageDialog(mw, "The tool for visualisation works only under Microsoft Windos.", "Wrong system", 1);
                    return;
                }
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    VisualisePanel panel = new VisualisePanel(mw, ds);
                    mw.setContent(panel);
                }
            }
        };
        profileVisualize.setMnemonic(86);
        similarityCU = new ADAction(this, "Compare users"){
            private static final long serialVersionUID = 9095216058966524914L;

            public void actionPerformed(ActionEvent e) {
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    CompareUsersPanel panel = new CompareUsersPanel(ds);
                    mw.setContent(panel);
                }
            }
        };
        similarityCU.setMnemonic(67);
        similarityMSF = new ADAction(this, "Manage semantic files"){
            private static final long serialVersionUID = 5439405409660547113L;

            public void actionPerformed(ActionEvent e) {
                DataSet ds = this.getDataSet();
                if (ds != null) {
                    ManageDistFilesPanel panel = new ManageDistFilesPanel(ds);
                    mw.setContent(panel);
                }
            }
        };
        similarityMSF.setMnemonic(77);
        helpManual = new ADAction(this, "Help contents"){
            private static final long serialVersionUID = 1354242457785397409L;

            public void actionPerformed(ActionEvent e) {
                if (manual == null) {
                    manual = new EpubViewer();
                }
                mw.setContent(manual);
            }
        };
        helpManual.setMnemonic(72);
        helpManual.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpManual.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/help.png")));
        helpStartPage = new ADAction(this, "Start page"){
            private static final long serialVersionUID = 3364237774054136963L;

            public void actionPerformed(ActionEvent e) {
                JScrollPane scrollPane = new JScrollPane(background);
                scrollPane.setAutoscrolls(true);
                mw.setContent(scrollPane);
            }
        };
        helpStartPage.setMnemonic(83);
        helpStartPage.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        helpStartPage.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/home.png")));
        helpAbout = new ADAction(this, "About"){
            private static final long serialVersionUID = 6650789708603730200L;

            public void actionPerformed(ActionEvent e) {
                AboutDialog ad = new AboutDialog(mw);
                ad.setVisible(true);
            }
        };
        helpAbout.setMnemonic(65);
        helpAbout.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/about.png")));
    }

    private final JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menu.add(fileAdd);
        menu.add(fileEdit);
        menu.add(fileDelete);
        menu.addSeparator();
        menu.add(fileViewData);
        menu.add(fileViewUser);
        menu.addSeparator();
        menu.add(fileReset);
        menu.add(fileExit);
        return menu;
    }

    private JMenu createUserProfileMenu() {
        JMenu menu = new JMenu("User Profile");
        menu.setMnemonic('P');
        menu.add(profileSP);
        menu.add(profileRoI);
        menu.add(profileFPS);
        menu.addSeparator();
        menu.add(profileVisualize);
        return menu;
    }

    private JMenu createUserSimilMenu() {
        JMenu menu = new JMenu("User Similarity");
        menu.setMnemonic('U');
        menu.add(similarityCU);
        menu.add(similarityMSF);
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic(72);
        menu.add(helpManual);
        menu.add(helpStartPage);
        menu.add(helpAbout);
        return menu;
    }

    public static ADAction getHelpStartPage() {
        return helpStartPage;
    }

    private DataSet getDataSet() {
        DefaultMutableTreeNode node = this.getNode();
        if (node != null) {
            return (DataSet)node.getUserObject();
        }
        return null;
    }

    private DefaultMutableTreeNode getNode() {
        DefaultMutableTreeNode node = mw.getDataSetPane().getSelected();
        if (node == null) {
            JOptionPane.showMessageDialog(mw, "Please first choose a dataset by selecting a node.", "Choose a dataset", 1);
            return null;
        }
        return node;
    }

    public abstract class ADAction
    extends AbstractAction {
        private static final long serialVersionUID = 8109471079193338016L;

        public ADAction(String text) {
            super(text);
        }

        public final void setAccelerator(KeyStroke accelerator) {
            this.putValue("AcceleratorKey", accelerator);
        }

        public final void setSmallIcon(Icon icon) {
            this.putValue("SmallIcon", icon);
        }

        public final void setToolTip(String text) {
            this.putValue("ShortDescription", text);
        }

        public final void setDescription(String text) {
            this.putValue("LongDescription", text);
        }

        public final void setMnemonic(Integer mnemonic) {
            this.putValue("MnemonicKey", mnemonic);
        }
    }
}

