/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.WideJComboBox;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.distribution.NormalDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageDistFilesPanel
extends JPanel {
    private static final long serialVersionUID = -7417506924694365280L;
    private JPanel panel;
    private DataSet dataset;
    private HashMap<String, String> distStats;
    private JTextField textField;
    private JTextField textField_1;

    public ManageDistFilesPanel(DataSet aDataset) {
        this.dataset = aDataset;
        this.distStats = new HashMap();
        DistFileReader reader = new DistFileReader();
        reader.execute();
        this.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel_1.setLayout(new BorderLayout(0, 0));
        final JPanel panel_3 = new JPanel();
        panel_1.add((Component)panel_3, "Center");
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[4];
        gbl_panel_3.rowHeights = new int[7];
        gbl_panel_3.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_3.setLayout(gbl_panel_3);
        JLabel lblTheNumberOf = new JLabel("The number of semantic tags: ");
        GridBagConstraints gbc_lblTheNumberOf = new GridBagConstraints();
        gbc_lblTheNumberOf.insets = new Insets(10, 10, 5, 5);
        gbc_lblTheNumberOf.gridx = 1;
        gbc_lblTheNumberOf.gridy = 3;
        panel_3.add((Component)lblTheNumberOf, gbc_lblTheNumberOf);
        final JLabel lblNewLabel = new JLabel("");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 15;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 0);
        gbc_lblNewLabel.gridx = 2;
        gbc_lblNewLabel.gridy = 3;
        panel_3.add((Component)lblNewLabel, gbc_lblNewLabel);
        JLabel lblTheNumberOf_1 = new JLabel("The number of RoIs: ");
        GridBagConstraints gbc_lblTheNumberOf_1 = new GridBagConstraints();
        gbc_lblTheNumberOf_1.anchor = 13;
        gbc_lblTheNumberOf_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblTheNumberOf_1.gridx = 1;
        gbc_lblTheNumberOf_1.gridy = 4;
        panel_3.add((Component)lblTheNumberOf_1, gbc_lblTheNumberOf_1);
        final JLabel lblNewLabel_1 = new JLabel("");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 0);
        gbc_lblNewLabel_1.gridx = 2;
        gbc_lblNewLabel_1.gridy = 4;
        panel_3.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        JPanel panel_7 = new JPanel();
        panel_7.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Two ways of adding a new semantic file", 4, 2, null, null));
        panel_1.add((Component)panel_7, "North");
        panel_7.setLayout(new BoxLayout(panel_7, 1));
        JPanel panel_2 = new JPanel();
        panel_7.add(panel_2);
        panel_2.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Add an existing one", 4, 2, null, null));
        JButton btnAdd = new JButton("Add");
        panel_2.add(btnAdd);
        JButton btnDelete = new JButton("Delete");
        panel_2.add(btnDelete);
        JPanel panel_8 = new JPanel();
        panel_8.setBorder(new TitledBorder(null, "Generate one using an RoI file", 4, 2, null, null));
        panel_7.add(panel_8);
        panel_8.setLayout(new BoxLayout(panel_8, 1));
        JPanel panel_9 = new JPanel();
        panel_9.setVisible(false);
        panel_8.add(panel_9);
        GridBagLayout gbl_panel_9 = new GridBagLayout();
        gbl_panel_9.columnWidths = new int[4];
        int[] nArray = new int[2];
        nArray[0] = 25;
        gbl_panel_9.rowHeights = nArray;
        gbl_panel_9.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_9.rowWeights = new double[]{0.0, 1.0};
        panel_9.setLayout(gbl_panel_9);
        JLabel lblRoiFile = new JLabel("RoI file:");
        GridBagConstraints gbc_lblRoiFile = new GridBagConstraints();
        gbc_lblRoiFile.anchor = 14;
        gbc_lblRoiFile.insets = new Insets(0, 0, 5, 5);
        gbc_lblRoiFile.gridx = 0;
        gbc_lblRoiFile.gridy = 0;
        panel_9.add((Component)lblRoiFile, gbc_lblRoiFile);
        this.textField = new JTextField();
        this.textField.setEditable(false);
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.anchor = 15;
        gbc_textField.weightx = 1.0;
        gbc_textField.insets = new Insets(0, 0, 5, 5);
        gbc_textField.fill = 2;
        gbc_textField.gridx = 1;
        gbc_textField.gridy = 0;
        panel_9.add((Component)this.textField, gbc_textField);
        this.textField.setColumns(10);
        JButton btnSelect = new JButton("Select");
        GridBagConstraints gbc_btnSelect = new GridBagConstraints();
        gbc_btnSelect.anchor = 15;
        gbc_btnSelect.insets = new Insets(0, 0, 5, 0);
        gbc_btnSelect.gridx = 2;
        gbc_btnSelect.gridy = 0;
        panel_9.add((Component)btnSelect, gbc_btnSelect);
        JPanel panel_14 = new JPanel();
        panel_14.setBorder(new TitledBorder(null, "Select an RoI file of the dataset " + this.dataset.getName(), 4, 2, null, null));
        panel_8.add(panel_14);
        GridBagLayout gbl_panel_14 = new GridBagLayout();
        gbl_panel_14.columnWidths = new int[5];
        int[] nArray2 = new int[2];
        nArray2[0] = 25;
        gbl_panel_14.rowHeights = nArray2;
        gbl_panel_14.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_14.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_14.setLayout(gbl_panel_14);
        JLabel lblStayPointPara = new JLabel("Stay point para:");
        GridBagConstraints gbc_lblStayPointPara = new GridBagConstraints();
        gbc_lblStayPointPara.anchor = 13;
        gbc_lblStayPointPara.insets = new Insets(0, 0, 0, 5);
        gbc_lblStayPointPara.gridx = 0;
        gbc_lblStayPointPara.gridy = 0;
        panel_14.add((Component)lblStayPointPara, gbc_lblStayPointPara);
        final WideJComboBox<String> comboBox_3 = new WideJComboBox<String>();
        GridBagConstraints gbc_comboBox_3 = new GridBagConstraints();
        gbc_comboBox_3.insets = new Insets(0, 0, 0, 5);
        gbc_comboBox_3.fill = 2;
        gbc_comboBox_3.gridx = 1;
        gbc_comboBox_3.gridy = 0;
        panel_14.add(comboBox_3, gbc_comboBox_3);
        JLabel lblRoiFiles = new JLabel("RoI files:");
        GridBagConstraints gbc_lblRoiFiles = new GridBagConstraints();
        gbc_lblRoiFiles.insets = new Insets(0, 0, 0, 5);
        gbc_lblRoiFiles.anchor = 13;
        gbc_lblRoiFiles.gridx = 2;
        gbc_lblRoiFiles.gridy = 0;
        panel_14.add((Component)lblRoiFiles, gbc_lblRoiFiles);
        final WideJComboBox<String> comboBox_2 = new WideJComboBox<String>();
        GridBagConstraints gbc_comboBox_2 = new GridBagConstraints();
        gbc_comboBox_2.fill = 2;
        gbc_comboBox_2.gridx = 3;
        gbc_comboBox_2.gridy = 0;
        panel_14.add(comboBox_2, gbc_comboBox_2);
        JPanel panel_11 = new JPanel();
        panel_8.add(panel_11);
        GridBagLayout gbl_panel_11 = new GridBagLayout();
        int[] nArray3 = new int[3];
        nArray3[0] = 123;
        nArray3[1] = 55;
        gbl_panel_11.columnWidths = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 25;
        gbl_panel_11.rowHeights = nArray4;
        gbl_panel_11.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_11.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_11.setLayout(gbl_panel_11);
        JLabel lblNumberOfSemantic = new JLabel("Number of semantic tags:");
        GridBagConstraints gbc_lblNumberOfSemantic = new GridBagConstraints();
        gbc_lblNumberOfSemantic.anchor = 17;
        gbc_lblNumberOfSemantic.insets = new Insets(0, 5, 0, 5);
        gbc_lblNumberOfSemantic.gridx = 0;
        gbc_lblNumberOfSemantic.gridy = 0;
        panel_11.add((Component)lblNumberOfSemantic, gbc_lblNumberOfSemantic);
        this.textField_1 = new JTextField();
        GridBagConstraints gbc_textField_1 = new GridBagConstraints();
        gbc_textField_1.anchor = 17;
        gbc_textField_1.gridx = 1;
        gbc_textField_1.gridy = 0;
        panel_11.add((Component)this.textField_1, gbc_textField_1);
        this.textField_1.setColumns(8);
        JPanel panel_10 = new JPanel();
        panel_8.add(panel_10);
        JButton btnGenerate = new JButton("Generate");
        panel_10.add(btnGenerate);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem mntmViewFilePopup = new JMenuItem("View file");
        popup.add(mntmViewFilePopup);
        JSplitPane splitPane = new JSplitPane();
        this.add((Component)splitPane, "Center");
        this.panel = new JPanel();
        this.panel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.panel.add((Component)scrollPane, "Center");
        final JList userList = new JList();
        userList.setSelectionMode(0);
        scrollPane.setViewportView(userList);
        JPanel panel_4 = new JPanel();
        this.panel.add((Component)panel_4, "North");
        panel_4.setLayout(new BoxLayout(panel_4, 1));
        JPanel panel_6 = new JPanel();
        panel_6.setBorder(new MatteBorder(0, 0, 1, 0, new Color(0, 0, 0)));
        FlowLayout flowLayout = (FlowLayout)panel_6.getLayout();
        flowLayout.setVgap(0);
        panel_4.add(panel_6);
        JLabel lblDataset = new JLabel("Dataset " + this.dataset.getName());
        panel_6.add(lblDataset);
        JPanel panel_12 = new JPanel();
        FlowLayout flowLayout_3 = (FlowLayout)panel_12.getLayout();
        flowLayout_3.setVgap(0);
        panel_4.add(panel_12);
        JLabel lblStayPointParameter = new JLabel("Stay point parameter:");
        panel_12.add(lblStayPointParameter);
        final WideJComboBox<String> comboSP = new WideJComboBox<String>();
        panel_4.add(comboSP);
        JPanel panel_13 = new JPanel();
        FlowLayout flowLayout_4 = (FlowLayout)panel_13.getLayout();
        flowLayout_4.setVgap(0);
        panel_4.add(panel_13);
        JLabel lblRoiFile_1 = new JLabel("RoI file:");
        panel_13.add(lblRoiFile_1);
        final WideJComboBox<String> comboRoI = new WideJComboBox<String>();
        panel_4.add(comboRoI);
        JPanel panel_5 = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)panel_5.getLayout();
        flowLayout_1.setVgap(0);
        panel_4.add(panel_5);
        JLabel lblDistributionFileList = new JLabel("Semantic file list:");
        panel_5.add(lblDistributionFileList);
        lblDistributionFileList.setHorizontalAlignment(0);
        splitPane.setLeftComponent(this.panel);
        splitPane.setRightComponent(panel_1);
        splitPane.setDividerLocation(150);
        comboRoI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String roiFile = (String)comboRoI.getSelectedItem();
                if (roiFile != null) {
                    String spPara = (String)comboSP.getSelectedItem();
                    String[] distFiles = ManageDistFilesPanel.this.dataset.createDistRoIDir(spPara, roiFile).list();
                    userList.setListData(distFiles);
                }
            }
        });
        comboSP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String spPara = (String)comboSP.getSelectedItem();
                if (spPara != null) {
                    String[] roiFiles = ManageDistFilesPanel.this.dataset.createDistDir(spPara).list();
                    comboRoI.removeAllItems();
                    String[] stringArray = roiFiles;
                    int n = roiFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String anRoIFile = stringArray[n2];
                        comboRoI.addItem(anRoIFile);
                        ++n2;
                    }
                    comboRoI.setWide(true);
                }
            }
        });
        comboBox_3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String spPara = (String)comboBox_3.getSelectedItem();
                if (spPara != null) {
                    String[] RoIFiles = new File(ManageDistFilesPanel.this.dataset.getOutputPath() + "/RoIs/" + spPara).list();
                    comboBox_2.removeAllItems();
                    String[] stringArray = RoIFiles;
                    int n = RoIFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String anRoIFile = stringArray[n2];
                        comboBox_2.addItem(anRoIFile);
                        ++n2;
                    }
                    comboBox_2.setWide(true);
                }
            }
        });
        if (this.dataset.getType() == DataSet.Type.GPS) {
            this.fillComboBox(comboSP);
        } else {
            panel_12.setVisible(false);
            comboSP.setVisible(false);
            this.fillComboBox(comboRoI);
        }
        String[] FilesInRoIDir = this.dataset.getRoiList();
        if (this.dataset.getType() == DataSet.Type.GPS) {
            String[] stringArray = FilesInRoIDir;
            int n = FilesInRoIDir.length;
            int n2 = 0;
            while (n2 < n) {
                String anSpParaInRoIDir = stringArray[n2];
                comboBox_3.addItem(anSpParaInRoIDir);
                ++n2;
            }
            comboBox_3.setWide(true);
        } else {
            lblStayPointPara.setVisible(false);
            comboBox_3.setVisible(false);
            String[] stringArray = FilesInRoIDir;
            int n = FilesInRoIDir.length;
            int n3 = 0;
            while (n3 < n) {
                String anRoIFile = stringArray[n3];
                comboBox_2.addItem(anRoIFile);
                ++n3;
            }
            comboBox_2.setWide(true);
        }
        comboSP.setPrototypeDisplayValue("MMMMMMMMMMMM");
        comboRoI.setPrototypeDisplayValue("MMMMMMMMMMMM");
        comboBox_2.setPrototypeDisplayValue("MMMMMMMMMMMM");
        comboBox_3.setPrototypeDisplayValue("MMMMMMMMMMMM");
        userList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                String selectedItem = (String)userList.getSelectedValue();
                if (selectedItem != null) {
                    String stat = null;
                    String RoIFilename = (String)comboRoI.getSelectedItem();
                    if (ManageDistFilesPanel.this.dataset.getType() == DataSet.Type.GPS) {
                        String spPara = (String)comboSP.getSelectedItem();
                        stat = (String)ManageDistFilesPanel.this.distStats.get(ManageDistFilesPanel.this.dataset.getOutputPath() + File.separator + "Dist" + File.separator + spPara + File.separator + RoIFilename + File.separator + selectedItem);
                    } else {
                        stat = (String)ManageDistFilesPanel.this.distStats.get(ManageDistFilesPanel.this.dataset.getOutputPath() + File.separator + "Dist" + File.separator + RoIFilename + File.separator + selectedItem);
                    }
                    if (stat != null) {
                        String[] fields = stat.split(" ");
                        lblNewLabel.setText(fields[0]);
                        lblNewLabel_1.setText(fields[1]);
                    }
                    panel_3.setVisible(true);
                }
            }
        });
        userList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index;
                Rectangle bound;
                if (SwingUtilities.isRightMouseButton(e) && (bound = userList.getCellBounds(index = userList.locationToIndex(e.getPoint()), index)).contains(e.getPoint())) {
                    userList.setSelectedIndex(index);
                    popup.show(userList, e.getX(), e.getY());
                }
            }
        });
        btnSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser fc = new JFileChooser();
                    int ans = fc.showOpenDialog(ManageDistFilesPanel.this);
                    if (ans == 0) {
                        ManageDistFilesPanel.this.textField.setText(fc.getSelectedFile().getAbsolutePath());
                    }
                }
                catch (HeadlessException ex) {
                    ex.printStackTrace();
                }
            }
        });
        btnGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int tags;
                String RoIFile = (String)comboBox_2.getSelectedItem();
                if (RoIFile == null) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Please first select an RoI file.", "Select an RoI file", 1);
                    return;
                }
                try {
                    tags = Integer.parseInt(ManageDistFilesPanel.this.textField_1.getText().trim());
                    if (tags <= 0 || tags > 50) {
                        JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "The number of semantic tags you entered is not between 1 and 50.", "Error", 0);
                        return;
                    }
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "The number of semantic tags you entered is not an integer.", "Number format error", 0);
                    return;
                }
                DistFileGenerator worker = new DistFileGenerator((String)comboBox_3.getSelectedItem(), RoIFile, tags, comboSP, comboRoI);
                worker.execute();
            }
        });
        mntmViewFilePopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String RoIFilename = (String)comboRoI.getSelectedItem();
                String filePath = null;
                if (ManageDistFilesPanel.this.dataset.getType() == DataSet.Type.GPS) {
                    String spPara = (String)comboSP.getSelectedItem();
                    filePath = ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/" + spPara + File.separator + RoIFilename + File.separator + (String)userList.getSelectedValue();
                } else {
                    filePath = ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/" + RoIFilename + File.separator + (String)userList.getSelectedValue();
                }
                String[] cmd = new String[]{"write.exe", filePath};
                ProcessBuilder pb = new ProcessBuilder(cmd);
                try {
                    pb.start();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred while opening the distribution file.", "Error", 0);
                }
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String spPara = null;
                if (ManageDistFilesPanel.this.dataset.getType() == DataSet.Type.GPS && (spPara = (String)comboSP.getSelectedItem()) == null) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Please first select a stay point parameter in the combo box.", "Info", 1);
                    return;
                }
                String RoIFilename = (String)comboRoI.getSelectedItem();
                if (RoIFilename == null) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Please first select an RoI file in the combo box.", "Info", 1);
                    return;
                }
                JFileChooser parseDir = new JFileChooser();
                File selectedFile = null;
                try {
                    int returnValue = parseDir.showOpenDialog(ManageDistFilesPanel.this);
                    if (returnValue != 0) {
                        return;
                    }
                    selectedFile = parseDir.getSelectedFile();
                }
                catch (HeadlessException ex) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred when opening the file choosing dialog.", "Error", 0);
                    return;
                }
                try {
                    if (ManageDistFilesPanel.this.dataset.getType() == DataSet.Type.GPS) {
                        File dir = new File(ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/" + spPara + File.separator + RoIFilename);
                        if (FileUtils.directoryContains(dir, selectedFile)) {
                            JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "The distribution file you chose has already been added.", "Info", 1);
                            return;
                        }
                        int ans = JOptionPane.showConfirmDialog(ManageDistFilesPanel.this, "Do you want to delete the original file?", "Confirmation", 0);
                        DistFileAdder worker = new DistFileAdder(selectedFile, String.valueOf(spPara) + File.separator + RoIFilename, ans, comboRoI);
                        worker.execute();
                    } else {
                        File dir = new File(ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/" + RoIFilename);
                        if (FileUtils.directoryContains(dir, selectedFile)) {
                            JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "The distribution file you chose has already been added.", "Info", 1);
                            return;
                        }
                        int ans = JOptionPane.showConfirmDialog(ManageDistFilesPanel.this, "Do you want to delete the original file?", "Confirmation", 0);
                        DistFileAdder worker = new DistFileAdder(selectedFile, RoIFilename, ans, comboRoI);
                        worker.execute();
                    }
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred when checking if the distribution file is already in the dataset's folder.", "Error", 0);
                }
            }
        });
        btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedItem = (String)userList.getSelectedValue();
                if (selectedItem != null) {
                    String RoIFilename = (String)comboRoI.getSelectedItem();
                    String distFilePathname = null;
                    if (ManageDistFilesPanel.this.dataset.getType() == DataSet.Type.GPS) {
                        String spPara = (String)comboSP.getSelectedItem();
                        distFilePathname = ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/" + spPara + File.separator + RoIFilename + File.separator + selectedItem;
                    } else {
                        distFilePathname = ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/" + RoIFilename + File.separator + selectedItem;
                    }
                    ManageDistFilesPanel.this.distStats.remove(distFilePathname);
                    int ans = JOptionPane.showConfirmDialog(ManageDistFilesPanel.this, "Are you sure that you want to delete the distribution file?", "Confirm", 0);
                    if (ans == 0) {
                        DistFileWriter writer = new DistFileWriter(distFilePathname, comboRoI, RoIFilename);
                        writer.execute();
                    }
                }
            }
        });
    }

    private void fillComboBox(WideJComboBox<String> comboBox) {
        File distDir = new File(this.dataset.getOutputPath() + "/Dist");
        if (distDir.exists()) {
            String[] spPara;
            comboBox.removeAllItems();
            String[] stringArray = spPara = new File(this.dataset.getOutputPath() + "/Dist").list();
            int n = spPara.length;
            int n2 = 0;
            while (n2 < n) {
                String anSPPara = stringArray[n2];
                if (!anSPPara.equals("DistributionFilesStats.txt")) {
                    comboBox.addItem(anSPPara);
                }
                ++n2;
            }
            comboBox.setWide(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistFileAdder
    extends SwingWorker<Byte, Void> {
        private File selectedFile;
        private String middleDir;
        private int ans;
        private JComboBox<String> comboBox_1;

        public DistFileAdder(File aFile, String aDir, int anInt, JComboBox<String> aComboBox) {
            this.selectedFile = aFile;
            this.middleDir = aDir;
            this.ans = anInt;
            this.comboBox_1 = aComboBox;
        }

        @Override
        protected Byte doInBackground() throws Exception {
            File destFile = new File(ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/" + this.middleDir + File.separator + this.selectedFile.getName());
            try {
                if (this.ans == 0) {
                    FileUtils.moveFile(this.selectedFile, destFile);
                } else {
                    FileUtils.copyFile(this.selectedFile, destFile);
                }
            }
            catch (IOException e) {
                return (byte)1;
            }
            try {
                String lastLine;
                RandomAccessFile rf = new RandomAccessFile(destFile.getAbsolutePath(), "r");
                long pos = rf.length();
                while (true) {
                    if (pos <= 0L) {
                        rf.seek(0L);
                        lastLine = rf.readLine();
                        if (lastLine != null && !lastLine.trim().isEmpty()) break;
                        destFile.delete();
                        rf.close();
                        return (byte)2;
                    }
                    rf.seek(pos - 1L);
                    char theChar = (char)rf.readByte();
                    String aLine = rf.readLine();
                    if (theChar == '\n' && aLine != null && !aLine.trim().isEmpty()) {
                        rf.seek(pos);
                        lastLine = rf.readLine();
                        break;
                    }
                    --pos;
                }
                rf.close();
                String[] fields = lastLine.split("\t");
                BufferedWriter bw = new BufferedWriter(new FileWriter(ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/DistributionFilesStats.txt", true));
                bw.write(String.valueOf(destFile.getAbsolutePath()) + ";" + (fields.length - 1) + " " + (Integer.parseInt(fields[0]) + 1) + "\n");
                bw.close();
                ManageDistFilesPanel.this.distStats.put(destFile.getAbsolutePath(), String.valueOf(fields.length - 1) + " " + (Integer.parseInt(fields[0]) + 1));
            }
            catch (FileNotFoundException e) {
                return (byte)2;
            }
            catch (IOException e) {
                return (byte)2;
            }
            catch (NumberFormatException e) {
                return (byte)2;
            }
            DistFileReader reader = new DistFileReader();
            reader.execute();
            return (byte)-1;
        }

        @Override
        public void done() {
            try {
                byte result = (Byte)this.get();
                if (result == -1) {
                    this.comboBox_1.setSelectedItem(this.comboBox_1.getSelectedItem());
                    ManageDistFilesPanel.this.panel.setVisible(true);
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Succeeded in adding the new distribution file.", "Successful operation", 1);
                } else if (result == 1) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred when moving or copying the distribution file.", "Error", 0);
                } else if (result == 2) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred when processing the stats of the distribution file.", "Error", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Unknown error: cannot know the result of the adding process.", "Error", 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistFileGenerator
    extends SwingWorker<Message, Void> {
        private String spPara;
        private String roiFile;
        private int tags;
        private WideJComboBox<String> comboBox;
        private WideJComboBox<String> comboBox_1;

        public DistFileGenerator(String anSPPara, String aFilename, int anInt, WideJComboBox<String> aComboBox, WideJComboBox<String> aComboBox2) {
            this.spPara = anSPPara;
            this.roiFile = aFilename;
            this.tags = anInt;
            this.comboBox = aComboBox;
            this.comboBox_1 = aComboBox2;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected Message doInBackground() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void done() {
            try {
                Message result = (Message)this.get();
                if (result.type == 0) {
                    if (ManageDistFilesPanel.this.dataset.getType() == DataSet.Type.GPS) {
                        ManageDistFilesPanel.this.fillComboBox(this.comboBox);
                        this.comboBox.setSelectedItem(this.spPara);
                        this.comboBox_1.setSelectedItem(this.roiFile);
                    } else {
                        ManageDistFilesPanel.this.fillComboBox(this.comboBox_1);
                        this.comboBox_1.setSelectedItem(this.roiFile);
                    }
                    ManageDistFilesPanel.this.panel.setVisible(true);
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Succeeded in generating and adding the distribution file " + result.message + ".", "Successful operation", 1);
                } else if (result.type == 1) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Cannot find the specified RoI file.", "Error", 0);
                } else if (result.type == 2 || result.type == 3) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "The specified RoI file is malformatted.", "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred while performing file input or output.", "Error", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Unknown error: cannot know the result of the operation.", "Error", 0);
            }
        }

        public double[] generateDistribution(int n) {
            NormalDistribution nd = new NormalDistribution();
            double[] a = new double[n];
            double[] x = new double[n];
            double[] densities = new double[n];
            Random r = new Random();
            int i = 0;
            while (i < n) {
                x[i] = r.nextDouble() * 5.0;
                ++i;
            }
            i = 0;
            while (i < n) {
                densities[i] = nd.density(x[i]);
                ++i;
            }
            double sum = 0.0;
            double[] dArray = densities;
            int n2 = densities.length;
            int n3 = 0;
            while (n3 < n2) {
                double v = dArray[n3];
                sum += v;
                ++n3;
            }
            int i2 = 0;
            while (i2 < n) {
                int n4 = i2++;
                densities[n4] = densities[n4] / sum;
            }
            ArrayList<Integer> al = new ArrayList<Integer>();
            int i3 = 0;
            while (i3 < n) {
                al.add(i3);
                ++i3;
            }
            i3 = 0;
            while (al.size() != 0) {
                int alIndex = r.nextInt(al.size());
                int tagIndex = (Integer)al.remove(alIndex);
                a[tagIndex] = densities[i3++];
            }
            return a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistFileReader
    extends SwingWorker<Boolean, Void> {
        private DistFileReader() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            File DistFolder = new File(ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist");
            if (!DistFolder.exists()) {
                return true;
            }
            try {
                String aLine;
                BufferedReader bf = new BufferedReader(new FileReader(ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/DistributionFilesStats.txt"));
                while ((aLine = bf.readLine()) != null) {
                    String[] fields = aLine.split(";");
                    ManageDistFilesPanel.this.distStats.put(fields[0], fields[1]);
                }
                bf.close();
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        @Override
        public void done() {
            try {
                boolean result = (Boolean)this.get();
                if (!result) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred when reading the distribution file.", "Error", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Unknown error: cannot know the result of the reading process.", "Error", 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistFileWriter
    extends SwingWorker<Boolean, Void> {
        private String pathName;
        private WideJComboBox<String> comboBox_1;
        private String RoIFilename;

        public DistFileWriter(String aPathName, WideJComboBox<String> aComboBox, String anRoIFilename) {
            this.pathName = aPathName;
            this.comboBox_1 = aComboBox;
            this.RoIFilename = anRoIFilename;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            new File(this.pathName).delete();
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(ManageDistFilesPanel.this.dataset.getOutputPath() + "/Dist/DistributionFilesStats.txt"));
                for (Map.Entry anEntry : ManageDistFilesPanel.this.distStats.entrySet()) {
                    bw.write(String.valueOf((String)anEntry.getKey()) + ";" + (String)anEntry.getValue() + "\n");
                }
                bw.close();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        @Override
        public void done() {
            try {
                boolean result = (Boolean)this.get();
                if (!result) {
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "An error occurred when deleting the distribution file.", "Error", 0);
                } else {
                    this.comboBox_1.setSelectedItem(this.RoIFilename);
                    JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Succeeded in deleting the distribution file.", "Successful operation", 1);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ManageDistFilesPanel.this, "Unknown error: cannot know the result of the deleting process.", "Error", 0);
            }
        }
    }

    private class Message {
        public Byte type;
        public String message;

        private Message() {
        }
    }
}

