/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.utils.ProcessRunner;
import org.apache.commons.io.FileUtils;

public class VisualisePanel
extends JPanel {
    private static final long serialVersionUID = -2391648635093066444L;
    private final MainWindow mw;
    private DataSet dataset;
    private final JList<String> userList = new JList();
    private final JList<String> spList = new JList();
    private final JList<String> roiList = new JList();
    private final JButton btnStart = new JButton("Start");
    private final JButton btnClose = new JButton("Close");

    public VisualisePanel(MainWindow aMw, DataSet aDataset) {
        this.mw = aMw;
        this.dataset = aDataset;
        this.createGui();
    }

    private void createGui() {
        JScrollPane scrollPane;
        JLabel tempLabel;
        JSplitPane leftSplitPane = new JSplitPane();
        JSplitPane rightSplitPane = new JSplitPane();
        JPanel userPanel = new JPanel();
        JPanel spPanel = new JPanel();
        JPanel roiPanel = new JPanel();
        Dimension space = new Dimension(10, 10);
        Dimension smallSpace = new Dimension(5, 5);
        this.setLayout(new BorderLayout(0, 0));
        userPanel.setMinimumSize(new Dimension(150, 150));
        spPanel.setMinimumSize(new Dimension(150, 150));
        roiPanel.setMinimumSize(new Dimension(150, 150));
        String[] users = this.dataset.getUserList();
        final JLabel spLabel = new JLabel("Stay point file list");
        if (this.dataset.getType() == DataSet.Type.GPS) {
            this.add((Component)leftSplitPane, "Center");
            leftSplitPane.setRightComponent(rightSplitPane);
            leftSplitPane.setLeftComponent(userPanel);
            userPanel.setLayout(new BoxLayout(userPanel, 1));
            tempLabel = new JLabel("GPS user list");
            tempLabel.setAlignmentX(0.5f);
            userPanel.add(Box.createRigidArea(space));
            userPanel.add(tempLabel);
            userPanel.add(Box.createRigidArea(space));
            scrollPane = new JScrollPane();
            scrollPane.setViewportView(this.userList);
            this.userList.setListData((String[])users);
            this.userList.setSelectionMode(0);
            userPanel.add(scrollPane);
            JButton btnClearUsers = new JButton("Clear Selection");
            btnClearUsers.setAlignmentX(0.5f);
            userPanel.add(Box.createRigidArea(smallSpace));
            btnClearUsers.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VisualisePanel.this.userList.clearSelection();
                }
            });
            userPanel.add(btnClearUsers);
            userPanel.add(Box.createRigidArea(smallSpace));
            this.spList.setToolTipText("<html>Each item is the parameter settings used when forming the stay point file it represents.<br/>Its format is \"distance threshold_time threshold_stay point merging threshold\".</html>");
            this.userList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    String user = (String)VisualisePanel.this.userList.getSelectedValue();
                    if (user != null) {
                        File[] spFiles;
                        ArrayList<String> spParas = new ArrayList<String>();
                        File[] fileArray = spFiles = VisualisePanel.this.dataset.getSPFiles();
                        int n = spFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File anSPDir = fileArray[n2];
                            File supposedSPFile = new File(anSPDir + File.separator + user + ".txt");
                            try {
                                if (FileUtils.directoryContains(anSPDir, supposedSPFile)) {
                                    spParas.add(anSPDir.getName());
                                }
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            ++n2;
                        }
                        spLabel.setText("SP file list of user " + user);
                        VisualisePanel.this.spList.setListData(spParas.toArray(new String[0]));
                    }
                }
            });
        } else {
            this.add((Component)rightSplitPane, "Center");
            this.spList.setListData((String[])users);
        }
        rightSplitPane.setLeftComponent(spPanel);
        spPanel.setLayout(new BoxLayout(spPanel, 1));
        spLabel.setAlignmentX(0.5f);
        spPanel.add(Box.createRigidArea(space));
        spPanel.add(spLabel);
        spPanel.add(Box.createRigidArea(space));
        scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.spList);
        this.spList.setSelectionMode(0);
        spPanel.add(scrollPane);
        JButton btnClearSp = new JButton("Clear Selection");
        btnClearSp.setAlignmentX(0.5f);
        btnClearSp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualisePanel.this.spList.clearSelection();
            }
        });
        spPanel.add(Box.createRigidArea(smallSpace));
        spPanel.add(btnClearSp);
        spPanel.add(Box.createRigidArea(smallSpace));
        rightSplitPane.setRightComponent(roiPanel);
        roiPanel.setLayout(new BoxLayout(roiPanel, 1));
        tempLabel = new JLabel("RoI file list");
        tempLabel.setAlignmentX(0.5f);
        roiPanel.add(Box.createRigidArea(space));
        roiPanel.add(tempLabel);
        roiPanel.add(Box.createRigidArea(space));
        scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.roiList);
        this.roiList.setSelectionMode(0);
        this.roiList.setToolTipText("<html>\r\nThe first part after splitting each item with \"-\" is a list of all users separated by \"_\".<br/>The second part is the parameter settings used when detecting stay points involved in forming the RoI file.<br/>The format of the second part  is \"distance threshold_time threshold_stay point merging threshold\".</html>");
        roiPanel.add(scrollPane);
        JButton btnClearRoI = new JButton("Clear Selection");
        btnClearRoI.setAlignmentX(0.5f);
        btnClearRoI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualisePanel.this.roiList.clearSelection();
            }
        });
        roiPanel.add(Box.createRigidArea(smallSpace));
        roiPanel.add(btnClearRoI);
        roiPanel.add(Box.createRigidArea(smallSpace));
        rightSplitPane.setResizeWeight(0.5);
        leftSplitPane.setResizeWeight(0.333);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.btnStart);
        buttonPanel.add(Box.createRigidArea(space));
        buttonPanel.add(this.btnClose);
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualisePanel.this.mw.goHome();
            }
        });
        buttonPanel.add(Box.createHorizontalGlue());
        this.add((Component)buttonPanel, "South");
        this.spList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                String spPara = (String)VisualisePanel.this.spList.getSelectedValue();
                String user = VisualisePanel.this.dataset.getType() == DataSet.Type.GPS ? (String)VisualisePanel.this.userList.getSelectedValue() : (String)VisualisePanel.this.spList.getSelectedValue();
                if (spPara != null && user != null) {
                    ArrayList<String> usableRoIFiles = new ArrayList<String>();
                    if (VisualisePanel.this.dataset.isRoiDir(spPara)) {
                        String[] roiFiles;
                        File selectedParaRoIDir = VisualisePanel.this.dataset.createRoIDir(spPara);
                        String[] stringArray = roiFiles = selectedParaRoIDir.list();
                        int n = roiFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String anRoIFile = stringArray[n2];
                            String[] fields = anRoIFile.split("-");
                            String[] users = fields[0].split("_");
                            HashSet<String> usersAnRoI = new HashSet<String>();
                            String[] stringArray2 = users;
                            int n3 = users.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String aUser = stringArray2[n4];
                                usersAnRoI.add(aUser);
                                ++n4;
                            }
                            if (usersAnRoI.contains(user)) {
                                usableRoIFiles.add(anRoIFile.substring(0, anRoIFile.length() - 4));
                            }
                            ++n2;
                        }
                        VisualisePanel.this.roiList.setListData(usableRoIFiles.toArray(new String[0]));
                    }
                } else {
                    VisualisePanel.this.roiList.setListData(new String[0]);
                }
            }
        });
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] cmd;
                Process p;
                ArrayList<String> cmdBuilder = new ArrayList<String>();
                cmdBuilder.add("map.exe");
                if (VisualisePanel.this.dataset.getType() == DataSet.Type.GPS) {
                    String user = (String)VisualisePanel.this.userList.getSelectedValue();
                    String sp = (String)VisualisePanel.this.spList.getSelectedValue();
                    String roi = (String)VisualisePanel.this.roiList.getSelectedValue();
                    if (user == null && sp == null && roi == null) {
                        JOptionPane.showMessageDialog(VisualisePanel.this, "You must choose user, stay point and RoI.", "Information", 1);
                        return;
                    }
                    if (user != null) {
                        cmdBuilder.add("-gps");
                        cmdBuilder.add(VisualisePanel.this.dataset.getUserInDir(user).toString());
                    }
                    if (sp != null) {
                        cmdBuilder.add("-staypoint");
                        cmdBuilder.add(VisualisePanel.this.dataset.getSPFile(sp, user).toString());
                    }
                    if (roi != null) {
                        cmdBuilder.add("-roi");
                        cmdBuilder.add(VisualisePanel.this.dataset.getOutputPath() + "/RoIs/" + sp + "/" + roi + ".txt");
                    }
                } else {
                    String sp = (String)VisualisePanel.this.spList.getSelectedValue();
                    String roi = (String)VisualisePanel.this.roiList.getSelectedValue();
                    if (sp == null && roi == null) {
                        JOptionPane.showMessageDialog(VisualisePanel.this, "You haven't selected anything to be visualized.", "Information", 1);
                        return;
                    }
                    if (sp != null) {
                        cmdBuilder.add("-staypoint");
                        cmdBuilder.add(VisualisePanel.this.dataset.getInputPath() + File.separator + sp + ".txt");
                    }
                    if (roi != null) {
                        cmdBuilder.add("-roi");
                        cmdBuilder.add(VisualisePanel.this.dataset.getOutputPath() + File.separator + "RoIs" + File.separator + roi + ".txt");
                    }
                }
                if ((p = ProcessRunner.getMapProcess(cmd = cmdBuilder.toArray(new String[0]), VisualisePanel.this.mw)) == null) {
                    JOptionPane.showMessageDialog(VisualisePanel.this.mw, "Could not start visualisation tool.", "Error", 0);
                    return;
                }
                BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String line;
                    while ((line = bri.readLine()) != null) {
                        System.out.println(line);
                    }
                    bri.close();
                    while ((line = bre.readLine()) != null) {
                        System.err.println(line);
                    }
                    bre.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }
}

