/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui.epub;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import lu.uni.minus.ui.epub.ContentPane;
import lu.uni.minus.ui.epub.ValueHolder;
import lu.uni.minus.ui.epub.ViewerUtil;
import nl.siegmann.epublib.browsersupport.Navigator;

class ButtonBar
extends JPanel {
    private static final long serialVersionUID = 6431437924245035812L;
    private JButton startButton = ViewerUtil.createButton("chapter-first", "|<");
    private JButton previousChapterButton = ViewerUtil.createButton("chapter-previous", "<<");
    private JButton previousPageButton = ViewerUtil.createButton("page-previous", "<");
    private JButton nextPageButton = ViewerUtil.createButton("page-next", ">");
    private JButton nextChapterButton = ViewerUtil.createButton("chapter-next", ">>");
    private JButton endButton = ViewerUtil.createButton("chapter-last", ">|");
    private ContentPane chapterPane;
    private final ValueHolder<Navigator> navigatorHolder = new ValueHolder();

    public ButtonBar(Navigator navigator, ContentPane chapterPane) {
        super(new GridLayout(0, 4));
        this.chapterPane = chapterPane;
        JPanel bigPrevious = new JPanel(new GridLayout(0, 2));
        bigPrevious.add(this.startButton);
        bigPrevious.add(this.previousChapterButton);
        this.add(bigPrevious);
        this.add(this.previousPageButton);
        this.add(this.nextPageButton);
        JPanel bigNext = new JPanel(new GridLayout(0, 2));
        bigNext.add(this.nextChapterButton);
        bigNext.add(this.endButton);
        this.add(bigNext);
        this.setSectionWalker(navigator);
    }

    public void setSectionWalker(Navigator navigator) {
        this.navigatorHolder.setValue(navigator);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Navigator)ButtonBar.this.navigatorHolder.getValue()).gotoFirstSpineSection(ButtonBar.this);
            }
        });
        this.previousChapterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Navigator)ButtonBar.this.navigatorHolder.getValue()).gotoPreviousSpineSection(ButtonBar.this);
            }
        });
        this.previousPageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonBar.this.chapterPane.gotoPreviousPage();
            }
        });
        this.nextPageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonBar.this.chapterPane.gotoNextPage();
            }
        });
        this.nextChapterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Navigator)ButtonBar.this.navigatorHolder.getValue()).gotoNextSpineSection(ButtonBar.this);
            }
        });
        this.endButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Navigator)ButtonBar.this.navigatorHolder.getValue()).gotoLastSpineSection(ButtonBar.this);
            }
        });
    }
}

