/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui.epub;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import lu.uni.minus.ui.epub.BrowseBar;
import lu.uni.minus.ui.epub.ContentPane;
import lu.uni.minus.ui.epub.TableOfContentsPane;
import nl.siegmann.epublib.browsersupport.Navigator;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.epub.EpubReader;

public class EpubViewer
extends JPanel {
    private static final long serialVersionUID = 1041636930664130189L;
    private BrowseBar browseBar;
    private JSplitPane mainSplitPane;
    private Navigator navigator = new Navigator();

    public EpubViewer() {
        this.createContent();
        this.openBook("MinUSManual.epub");
    }

    private void createContent() {
        this.setLayout(new BorderLayout());
        ContentPane htmlPane = new ContentPane(this.navigator);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)htmlPane, "Center");
        this.browseBar = new BrowseBar(this.navigator, htmlPane);
        contentPanel.add((Component)this.browseBar, "South");
        this.mainSplitPane = new JSplitPane(1);
        this.mainSplitPane.setLeftComponent(new TableOfContentsPane(this.navigator));
        this.mainSplitPane.setRightComponent(contentPanel);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setContinuousLayout(true);
        this.mainSplitPane.setResizeWeight(0.0);
        this.add((Component)this.mainSplitPane, "Center");
        this.setPreferredSize(new Dimension(1000, 750));
        this.mainSplitPane.setDividerLocation(0.2);
    }

    private void openBook(String name) {
        try {
            InputStream in = EpubViewer.class.getResourceAsStream("/manual/" + name);
            Book book = new EpubReader().readEpub(in);
            this.navigator.gotoBook(book, this);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }
}

