/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui.epub;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.text.html.HTMLDocument;
import nl.siegmann.epublib.browsersupport.Navigator;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.util.CollectionUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageLoaderCache
extends Dictionary<String, Image> {
    public static final String IMAGE_URL_PREFIX = "http:/";
    private Map<String, Image> cache = new HashMap<String, Image>();
    private Book book;
    private String currentFolder = "";
    private Navigator navigator;

    public ImageLoaderCache(Navigator navigator) {
        this.navigator = navigator;
        this.initBook(navigator.getBook());
    }

    public void initBook(Book book) {
        if (book == null) {
            return;
        }
        this.book = book;
        this.cache.clear();
        this.currentFolder = "";
    }

    public void setContextResource(Resource resource) {
        int lastSlashPos;
        if (resource == null) {
            return;
        }
        if (StringUtils.isNotBlank(resource.getHref()) && (lastSlashPos = resource.getHref().lastIndexOf(47)) >= 0) {
            this.currentFolder = resource.getHref().substring(0, lastSlashPos + 1);
        }
    }

    public void initImageLoader(HTMLDocument document) {
        try {
            document.setBase(new URL(IMAGE_URL_PREFIX));
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
        }
        this.setContextResource(this.navigator.getCurrentResource());
        document.getDocumentProperties().put("imageCache", this);
    }

    private String getResourceHref(String requestUrl) {
        String resourceHref = requestUrl.toString().substring(IMAGE_URL_PREFIX.length());
        resourceHref = String.valueOf(this.currentFolder) + resourceHref;
        resourceHref = FilenameUtils.normalize(resourceHref);
        resourceHref = resourceHref.replaceAll("\\\\", "/");
        return resourceHref;
    }

    private Image createImage(Resource imageResource) {
        BufferedImage result = null;
        try {
            result = ImageIO.read(imageResource.getInputStream());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    @Override
    public Image get(Object key) {
        if (this.book == null) {
            return null;
        }
        String imageURL = key.toString();
        Image result = this.cache.get(imageURL);
        if (result != null) {
            return result;
        }
        String resourceHref = this.getResourceHref(imageURL);
        Resource imageResource = this.book.getResources().getByHref(resourceHref);
        if (imageResource == null) {
            return result;
        }
        result = this.createImage(imageResource);
        if (result != null) {
            this.cache.put(imageURL.toString(), result);
        }
        return result;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return CollectionUtil.createEnumerationFromIterator(this.cache.keySet().iterator());
    }

    @Override
    public Enumeration<Image> elements() {
        return CollectionUtil.createEnumerationFromIterator(this.cache.values().iterator());
    }

    @Override
    public Image put(String key, Image value) {
        return this.cache.put(key.toString(), value);
    }

    @Override
    public Image remove(Object key) {
        return this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public String toString() {
        return this.cache.toString();
    }
}

