/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import lu.uni.minus.preferences.DataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 712694630593475842L;
    private String[] columnNames = new String[]{"User", "Number of days", "Total number", "Min number in a day", "Max number in a day", "Average number"};
    private Object[][] data;

    public StatTableModel(List<String> selectedList, DataSet dataset, boolean sourceData, String selectedParaSetting) {
        if (sourceData || dataset.getType().equals((Object)DataSet.Type.SP)) {
            this.data = new Object[selectedList.size()][this.columnNames.length];
            String inputPath = sourceData ? String.valueOf(dataset.getOutputPath().toString()) + "/Stats/SourceDataAndStayPoints/SourceData.txt" : String.valueOf(dataset.getOutputPath().toString()) + "/Stats/StayPoints.txt";
            try {
                String aLine;
                Object[] selectedUsers = selectedList.toArray(new String[0]);
                Arrays.sort(selectedUsers);
                int foundUsers = 0;
                BufferedReader br = new BufferedReader(new FileReader(inputPath));
                while (foundUsers < selectedUsers.length && (aLine = br.readLine()) != null) {
                    String[] fields = aLine.split(" ");
                    if (Arrays.binarySearch(selectedUsers, fields[0]) < 0) continue;
                    int i = 0;
                    while (i < 6) {
                        this.data[foundUsers][i] = i != 5 ? fields[i] : String.format("%1$.1f", Double.parseDouble(fields[i]));
                        ++i;
                    }
                    ++foundUsers;
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String inputPath = String.valueOf(dataset.getOutputPath().toString()) + "/Stats/SourceDataAndStayPoints/" + selectedParaSetting;
            ArrayList<String[]> initialData = new ArrayList<String[]>();
            try {
                String aLine;
                Object[] selectedUsers = selectedList.toArray(new String[0]);
                Arrays.sort(selectedUsers);
                int foundUsers = 0;
                BufferedReader br = new BufferedReader(new FileReader(inputPath));
                while (foundUsers < selectedUsers.length && (aLine = br.readLine()) != null) {
                    String[] fields = aLine.split(" ");
                    if (Arrays.binarySearch(selectedUsers, fields[0]) < 0) continue;
                    initialData.add(fields);
                    ++foundUsers;
                }
                this.data = new Object[initialData.size()][this.columnNames.length];
                int i = 0;
                while (i < initialData.size()) {
                    String[] aRow = (String[])initialData.get(i);
                    int j = 0;
                    while (j < 6) {
                        this.data[i][j] = j != 5 ? aRow[j] : String.format("%1$.1f", Double.parseDouble(aRow[j]));
                        ++j;
                    }
                    ++i;
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Class<? extends Object> getColumnClass(int c) {
        return Number.class;
    }
}

