/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.cps;

import java.util.Arrays;
import lu.uni.minus.utils.cps.SemanticTags;

public class Distribution {
    private double[] probabilities;
    private static final double distanceThreshold = 0.5;

    public Distribution(double[] someProbabilities) {
        this.probabilities = someProbabilities;
    }

    public Distribution() {
        this.probabilities = new double[SemanticTags.values().length];
    }

    public double[] getProbabilites() {
        return this.probabilities;
    }

    public String toString() {
        return Arrays.toString(this.probabilities);
    }

    public Distribution merge(Distribution anotherDistribution) {
        Distribution newDistribution = new Distribution();
        int index = 0;
        while (index < SemanticTags.values().length) {
            newDistribution.getProbabilites()[index] = (this.probabilities[index] + anotherDistribution.getProbabilites()[index]) / 2.0;
            ++index;
        }
        return newDistribution;
    }

    public double relativeEntropy(Distribution anotherDistribution) {
        double sum = 0.0;
        int index = 0;
        while (index < this.probabilities.length) {
            sum += this.probabilities[index] * Math.log(this.probabilities[index] / anotherDistribution.getProbabilites()[index]);
            ++index;
        }
        return sum;
    }

    public double calculateDistance(Distribution anotherDistribution) {
        return (this.relativeEntropy(anotherDistribution) + anotherDistribution.relativeEntropy(this)) / 2.0;
    }

    public boolean isLSsimilar(Distribution anotherDistribution) {
        return this.calculateDistance(anotherDistribution) <= 0.5;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        if (!(anObject instanceof Distribution)) {
            return false;
        }
        return Arrays.equals(this.probabilities, ((Distribution)anObject).getProbabilites());
    }
}

