/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.cps;

import java.util.ArrayList;
import java.util.Arrays;
import lu.uni.minus.utils.cps.TimeInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoIFrequentPattern {
    private ArrayList<TimeInterval> transitionTimes = new ArrayList();
    private double relativeSupport;
    private int absoluteSupport;
    private int[] RoIIDs;

    public RoIFrequentPattern() {
    }

    public RoIFrequentPattern(RoIFrequentPattern aFrequentPattern) {
        this.relativeSupport = aFrequentPattern.getRelativeSupport();
        this.absoluteSupport = aFrequentPattern.getAbsoluteSupport();
        this.RoIIDs = aFrequentPattern.getRoIIDs();
    }

    public RoIFrequentPattern(double aRelativeSupport, int anAbsoluteSupport, int[] someRoIIDs) {
        this.relativeSupport = aRelativeSupport;
        this.absoluteSupport = anAbsoluteSupport;
        this.RoIIDs = someRoIIDs;
    }

    public ArrayList<TimeInterval> getTransitionTimes() {
        return this.transitionTimes;
    }

    public void setTransitionTimes(ArrayList<TimeInterval> someTransitionTimes) {
        this.transitionTimes = someTransitionTimes;
    }

    public double getRelativeSupport() {
        return this.relativeSupport;
    }

    public void setRelativeSupport(double aRelativeSupport) {
        this.relativeSupport = aRelativeSupport;
    }

    public int getAbsoluteSupport() {
        return this.absoluteSupport;
    }

    public void setAbsoluteSupport(int anAbsoluteSupport) {
        this.absoluteSupport = anAbsoluteSupport;
    }

    public int[] getRoIIDs() {
        return this.RoIIDs;
    }

    public void setRoIIDs(int[] someRoIIDs) {
        this.RoIIDs = someRoIIDs;
    }

    public final boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (anotherObject == null) {
            return false;
        }
        if (!(anotherObject instanceof RoIFrequentPattern)) {
            return false;
        }
        return Arrays.equals(this.RoIIDs, ((RoIFrequentPattern)anotherObject).getRoIIDs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int[] nArray = this.RoIIDs;
        int n = this.RoIIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int RoIID = nArray[n2];
            sb.append("(");
            sb.append(RoIID);
            sb.append(")\t");
            ++n2;
        }
        sb.append(": ");
        sb.append(this.relativeSupport);
        sb.append("\t\t");
        sb.append(this.absoluteSupport);
        sb.append("\n");
        for (TimeInterval transitionTime : this.transitionTimes) {
            sb.append(transitionTime);
        }
        sb.append("\n");
        return sb.toString();
    }
}

