/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.cps;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import lu.uni.minus.utils.cps.CommonRoIFrequentPattern;
import lu.uni.minus.utils.cps.Distribution;
import lu.uni.minus.utils.cps.DistributionFrequentPattern;
import lu.uni.minus.utils.cps.DistributionFrequentPatternSet;
import lu.uni.minus.utils.cps.RoIFrequentPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoIFrequentPatternSet {
    private CopyOnWriteArraySet<RoIFrequentPattern> frequentPatterns;

    public RoIFrequentPatternSet() {
        this.frequentPatterns = new CopyOnWriteArraySet();
    }

    public RoIFrequentPatternSet(CopyOnWriteArraySet<RoIFrequentPattern> someFrequentPatterns) {
        this.frequentPatterns = someFrequentPatterns;
    }

    public boolean add(RoIFrequentPattern aFrequentPattern) {
        return this.frequentPatterns.add(aFrequentPattern);
    }

    public CopyOnWriteArraySet<RoIFrequentPattern> getFrequentPatterns() {
        return this.frequentPatterns;
    }

    public DistributionFrequentPatternSet convertToDistributionPatternSet(HashMap<String, Distribution> mapFromRegionToDistribution) throws Exception {
        LinkedList<DistributionFrequentPattern> distributionFrequentPatterns = new LinkedList<DistributionFrequentPattern>();
        for (RoIFrequentPattern anRoIPattern : this.frequentPatterns) {
            LinkedList<Distribution> distributions = new LinkedList<Distribution>();
            int[] nArray = anRoIPattern.getRoIIDs();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int anRoI = nArray[n2];
                Distribution distributionOfTheRoI = mapFromRegionToDistribution.get(Integer.toString(anRoI));
                if (distributionOfTheRoI == null) {
                    throw new Exception();
                }
                distributions.add(distributionOfTheRoI);
                ++n2;
            }
            DistributionFrequentPattern aDistributionPattern = new DistributionFrequentPattern(distributions, anRoIPattern.getRelativeSupport(), anRoIPattern.getAbsoluteSupport());
            distributionFrequentPatterns.add(aDistributionPattern);
        }
        return new DistributionFrequentPatternSet(distributionFrequentPatterns);
    }

    public RoIFrequentPatternSet intersect(RoIFrequentPatternSet anotherFrequentPatternSet) {
        RoIFrequentPatternSet intersection = new RoIFrequentPatternSet();
        for (RoIFrequentPattern aFrequentPattern : this.frequentPatterns) {
            for (RoIFrequentPattern anotherFrequentPattern : anotherFrequentPatternSet.getFrequentPatterns()) {
                if (!aFrequentPattern.equals(anotherFrequentPattern)) continue;
                CommonRoIFrequentPattern aCommonFrequentPattern = new CommonRoIFrequentPattern(aFrequentPattern, anotherFrequentPattern);
                intersection.add(aCommonFrequentPattern);
            }
        }
        return intersection;
    }

    public double functionF() {
        double sumOfSupports = 0.0;
        for (RoIFrequentPattern aFrequentPattern : this.frequentPatterns) {
            sumOfSupports += (double)aFrequentPattern.getRoIIDs().length * aFrequentPattern.getRelativeSupport();
        }
        return sumOfSupports;
    }

    public double functionF(int user) {
        double sumOfSupports = 0.0;
        if (user == 1) {
            for (RoIFrequentPattern aFrequentPattern : this.frequentPatterns) {
                sumOfSupports += (double)aFrequentPattern.getRoIIDs().length * aFrequentPattern.getRelativeSupport();
            }
            return sumOfSupports;
        }
        for (RoIFrequentPattern aFrequentPattern : this.frequentPatterns) {
            sumOfSupports += (double)aFrequentPattern.getRoIIDs().length * ((CommonRoIFrequentPattern)aFrequentPattern).getRelativeSupport2();
        }
        return sumOfSupports;
    }

    public void adjustSupport() {
        Integer nextKey;
        TreeMap patternMapByLength = new TreeMap();
        for (RoIFrequentPattern aFrequentPattern : this.frequentPatterns) {
            int length = aFrequentPattern.getRoIIDs().length;
            if (patternMapByLength.containsKey(length)) {
                ((HashSet)patternMapByLength.get(length)).add(aFrequentPattern);
                continue;
            }
            HashSet<RoIFrequentPattern> newSetByLength = new HashSet<RoIFrequentPattern>();
            newSetByLength.add(aFrequentPattern);
            patternMapByLength.put(length, newSetByLength);
        }
        Iterator keyIterator = patternMapByLength.keySet().iterator();
        while (!(nextKey = (Integer)keyIterator.next()).equals(patternMapByLength.lastKey())) {
            for (RoIFrequentPattern aFrequentPatternWithLengthNextKey : (HashSet)patternMapByLength.get(nextKey)) {
                double maximumSupport = 0.0;
                for (RoIFrequentPattern aFrequentPatternWithLengthNextKeyPlus1 : (HashSet)patternMapByLength.get(nextKey + 1)) {
                    double supportOfPatternWithLengthNextKeyPlus1;
                    int[] RoIIDsOfPatternLengthNextKeyPlus1 = aFrequentPatternWithLengthNextKeyPlus1.getRoIIDs();
                    int[] RoIIDsOfPatternLengthNextKey = aFrequentPatternWithLengthNextKey.getRoIIDs();
                    if (!this.subArray(RoIIDsOfPatternLengthNextKey, RoIIDsOfPatternLengthNextKeyPlus1) || !((supportOfPatternWithLengthNextKeyPlus1 = aFrequentPatternWithLengthNextKeyPlus1.getRelativeSupport()) > maximumSupport)) continue;
                    maximumSupport = supportOfPatternWithLengthNextKeyPlus1;
                }
                aFrequentPatternWithLengthNextKey.setRelativeSupport(aFrequentPatternWithLengthNextKey.getRelativeSupport() - maximumSupport);
            }
        }
    }

    private boolean subArray(int[] array1, int[] array2) {
        int i = 0;
        int k = 0;
        k = 0;
        while (k < array1.length) {
            int j = i;
            while (j < array2.length) {
                if (array2[j] != array1[k] && j == array2.length - 1) {
                    return false;
                }
                if (array2[j] == array1[k]) {
                    i = j + 1;
                    break;
                }
                ++j;
            }
            if (i == array2.length && k != array1.length - 1) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public void adjustSupport(RoIFrequentPatternSet user1, RoIFrequentPatternSet user2) {
        if (this.frequentPatterns.size() != 0) {
            TreeMap patternMapByLength = new TreeMap();
            for (RoIFrequentPattern aFrequentPattern : this.frequentPatterns) {
                int length = aFrequentPattern.getRoIIDs().length;
                if (patternMapByLength.containsKey(length)) {
                    ((HashSet)patternMapByLength.get(length)).add(aFrequentPattern);
                    continue;
                }
                HashSet<RoIFrequentPattern> newSetByLength = new HashSet<RoIFrequentPattern>();
                newSetByLength.add(aFrequentPattern);
                patternMapByLength.put(length, newSetByLength);
            }
            for (RoIFrequentPattern aCommonFrequentPattern : this.frequentPatterns) {
                for (RoIFrequentPattern aFrequentPattern : user1.getFrequentPatterns()) {
                    if (!aCommonFrequentPattern.equals(aFrequentPattern)) continue;
                    aCommonFrequentPattern.setRelativeSupport(aFrequentPattern.getRelativeSupport());
                }
            }
            for (RoIFrequentPattern aCommonFrequentPattern : this.frequentPatterns) {
                for (RoIFrequentPattern aFrequentPattern : user2.getFrequentPatterns()) {
                    if (!aCommonFrequentPattern.equals(aFrequentPattern)) continue;
                    ((CommonRoIFrequentPattern)aCommonFrequentPattern).setRelativeSupport2(aFrequentPattern.getRelativeSupport());
                }
            }
        }
    }

    public double supSim() {
        double sumDif = 0.0;
        double sum = 0.0;
        for (RoIFrequentPattern aCommonFrequentPattern : this.frequentPatterns) {
            sumDif += Math.abs(aCommonFrequentPattern.getRelativeSupport() - ((CommonRoIFrequentPattern)aCommonFrequentPattern).getRelativeSupport2());
            sum += aCommonFrequentPattern.getRelativeSupport() + ((CommonRoIFrequentPattern)aCommonFrequentPattern).getRelativeSupport2();
        }
        if (sum == 0.0) {
            return 1.0;
        }
        return 1.0 - sumDif / sum;
    }
}

